/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension.kafka;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.ozhera.log.stream.job.LogDataTransfer;
import org.apache.ozhera.log.stream.job.extension.SinkJob;
import org.apache.ozhera.log.stream.job.extension.kafka.KafkaConfig;
import org.apache.ozhera.log.stream.job.extension.kafka.KafkaConsumerRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSinkJob
implements SinkJob {
    private static final Logger log = LoggerFactory.getLogger(KafkaSinkJob.class);
    private final KafkaConfig kafkaConfig;
    private final KafkaConsumer<String, String> consumer;
    private final LogDataTransfer dataTransfer;
    private KafkaConsumerRunner kafkaConsumerRunner;

    public KafkaSinkJob(KafkaConfig kafkaConfig, KafkaConsumer<String, String> consumer, LogDataTransfer dataTransfer) {
        this.kafkaConfig = kafkaConfig;
        this.consumer = consumer;
        this.dataTransfer = dataTransfer;
    }

    @Override
    public boolean start() throws Exception {
        try {
            this.consumer.subscribe((Collection)Lists.newArrayList((Object[])new String[]{this.kafkaConfig.getTopicName()}));
            this.kafkaConsumerRunner = new KafkaConsumerRunner(this.consumer, this.dataTransfer);
            Thread.ofVirtual().start(this.kafkaConsumerRunner);
        }
        catch (Exception e) {
            log.error("start kafka consumer error", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void shutdown() throws Exception {
        this.kafkaConsumerRunner.shutdown();
    }
}

