/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.AlarmStrategyInfo;
import org.apache.ozhera.monitor.bo.AlarmStrategyParam;
import org.apache.ozhera.monitor.bo.AlarmStrategyType;
import org.apache.ozhera.monitor.bo.AppViewType;
import org.apache.ozhera.monitor.dao.AppAlarmRuleDao;
import org.apache.ozhera.monitor.dao.AppAlarmStrategyDao;
import org.apache.ozhera.monitor.dao.AppMonitorDao;
import org.apache.ozhera.monitor.dao.model.AlarmStrategy;
import org.apache.ozhera.monitor.dao.model.AppAlarmRule;
import org.apache.ozhera.monitor.dao.model.AppMonitor;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AlarmStrategyService;
import org.apache.ozhera.monitor.service.AppAlarmService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.prometheus.AlarmRuleRequest;
import org.apache.ozhera.monitor.service.prometheus.PrometheusService;
import org.apache.ozhera.monitor.service.user.LocalUser;
import org.apache.ozhera.monitor.service.user.UseDetailInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AlarmStrategyServiceImpl
implements AlarmStrategyService {
    private static final Logger log = LoggerFactory.getLogger(AlarmStrategyServiceImpl.class);
    @Autowired
    private AppAlarmStrategyDao appAlarmStrategyDao;
    @Autowired
    private AppAlarmRuleDao appAlarmRuleDao;
    @Autowired
    private AppAlarmService appAlarmService;
    @Autowired
    private AppMonitorDao appMonitorDao;
    @Autowired
    private PrometheusService prometheusService;
    private static final List<String> orderSorts = Lists.newArrayList((Object[])new String[]{"asc", "ASC", "desc", "DESC"});
    private static final List<String> orderColumn = Lists.newArrayList((Object[])new String[]{"update_time", "strategy_name"});

    @Override
    public AlarmStrategy getById(Integer id) {
        return this.appAlarmStrategyDao.getById(id);
    }

    @Override
    public boolean updateById(AlarmStrategy strategy) {
        return this.appAlarmStrategyDao.updateById(strategy);
    }

    @Override
    public AlarmStrategy create(AlarmRuleRequest param, AppMonitor app) {
        if (StringUtils.isBlank((CharSequence)param.getStrategyName()) || param.getStrategyType() == null) {
            throw new IllegalArgumentException("strategy name or type is null");
        }
        AlarmStrategy strategy = new AlarmStrategy();
        strategy.setCreater(param.getUser());
        strategy.setStrategyName(param.getStrategyName());
        strategy.setStrategyType(param.getStrategyType());
        strategy.setAppId(app.getProjectId());
        strategy.setIamId(app.getIamTreeId());
        strategy.setAppName(param.getStrategyType().equals(AlarmStrategyType.TESLA.getCode()) ? param.getAppAlias() : app.getProjectName());
        strategy.setDesc(param.getStrategyDesc());
        strategy.setStatus(0);
        if (StringUtils.isNotBlank((CharSequence)param.getAlertTeam())) {
            strategy.setAlertTeam(param.getAlertTeam());
        } else if (!CollectionUtils.isEmpty(param.getAlarmRules())) {
            strategy.setAlertTeam(param.getAlarmRules().get(0).getAlertTeam());
        }
        Map<Integer, UseDetailInfo.DeptDescr> deptMap = LocalUser.getDepts();
        if (deptMap.containsKey(3)) {
            strategy.setGroup3(deptMap.get(3).getDeptName());
        }
        if (deptMap.containsKey(4)) {
            strategy.setGroup4(deptMap.get(4).getDeptName());
        }
        if (deptMap.containsKey(5)) {
            strategy.setGroup5(deptMap.get(5).getDeptName());
        }
        JsonObject envs = new JsonObject();
        if (!CollectionUtils.isEmpty(param.getIncludeEnvs())) {
            envs.addProperty("includeEnvs", String.join((CharSequence)",", param.getIncludeEnvs()));
        }
        if (!CollectionUtils.isEmpty(param.getExceptEnvs())) {
            envs.addProperty("exceptEnvs", String.join((CharSequence)",", param.getExceptEnvs()));
        }
        if (!CollectionUtils.isEmpty(param.getIncludeZones())) {
            envs.addProperty("includeZones", String.join((CharSequence)",", param.getIncludeZones()));
        }
        if (!CollectionUtils.isEmpty(param.getExceptZones())) {
            envs.addProperty("exceptZones", String.join((CharSequence)",", param.getExceptZones()));
        }
        if (!CollectionUtils.isEmpty(param.getIncludeContainerName())) {
            envs.addProperty("includeContainerName", String.join((CharSequence)",", param.getIncludeContainerName()));
        }
        if (!CollectionUtils.isEmpty(param.getExceptContainerName())) {
            envs.addProperty("exceptContainerName", String.join((CharSequence)",", param.getExceptContainerName()));
        }
        if (!CollectionUtils.isEmpty(param.getIncludeModules())) {
            envs.addProperty("includeModules", String.join((CharSequence)",", param.getIncludeModules()));
        }
        if (!CollectionUtils.isEmpty(param.getExceptModules())) {
            envs.addProperty("exceptModules", String.join((CharSequence)",", param.getExceptModules()));
        }
        if (!CollectionUtils.isEmpty(param.getIncludeFunctions())) {
            envs.addProperty("includeFunctions", String.join((CharSequence)",", param.getIncludeFunctions()));
        }
        if (!CollectionUtils.isEmpty(param.getExceptFunctions())) {
            envs.addProperty("exceptFunctions", String.join((CharSequence)",", param.getExceptFunctions()));
        }
        strategy.setEnvs(envs.toString());
        if (!CollectionUtils.isEmpty(param.getAlertMembers())) {
            strategy.setAlertMembers(String.join((CharSequence)",", param.getAlertMembers()));
        }
        if (!CollectionUtils.isEmpty(param.getAtMembers())) {
            strategy.setAtMembers(String.join((CharSequence)",", param.getAtMembers()));
        }
        if (!this.appAlarmStrategyDao.insert(strategy)) {
            return null;
        }
        log.info("\u63d2\u5165\u89c4\u5219\u7b56\u7565\u6210\u529f\uff1astrategy={}", (Object)strategy);
        return strategy;
    }

    @Override
    public Result<AlarmStrategy> updateByParam(AlarmRuleRequest param) {
        AlarmStrategy strategy = new AlarmStrategy();
        strategy.setId(param.getStrategyId());
        strategy.setStrategyName(param.getStrategyName());
        strategy.setDesc(param.getStrategyDesc());
        if (StringUtils.isNotBlank((CharSequence)param.getAlertTeam())) {
            strategy.setAlertTeam(param.getAlertTeam());
        }
        JsonObject envs = new JsonObject();
        if (!CollectionUtils.isEmpty(param.getIncludeEnvs())) {
            envs.addProperty("includeEnvs", String.join((CharSequence)",", param.getIncludeEnvs()));
        }
        if (!CollectionUtils.isEmpty(param.getExceptEnvs())) {
            envs.addProperty("exceptEnvs", String.join((CharSequence)",", param.getExceptEnvs()));
        }
        if (!CollectionUtils.isEmpty(param.getIncludeZones())) {
            envs.addProperty("includeZones", String.join((CharSequence)",", param.getIncludeZones()));
        }
        if (!CollectionUtils.isEmpty(param.getExceptZones())) {
            envs.addProperty("exceptZones", String.join((CharSequence)",", param.getExceptZones()));
        }
        if (!CollectionUtils.isEmpty(param.getIncludeContainerName())) {
            envs.addProperty("includeContainerName", String.join((CharSequence)",", param.getIncludeContainerName()));
        }
        if (!CollectionUtils.isEmpty(param.getExceptContainerName())) {
            envs.addProperty("exceptContainerName", String.join((CharSequence)",", param.getExceptContainerName()));
        }
        if (!CollectionUtils.isEmpty(param.getIncludeModules())) {
            envs.addProperty("includeModules", String.join((CharSequence)",", param.getIncludeModules()));
        }
        if (!CollectionUtils.isEmpty(param.getExceptModules())) {
            envs.addProperty("exceptModules", String.join((CharSequence)",", param.getExceptModules()));
        }
        if (!CollectionUtils.isEmpty(param.getIncludeFunctions())) {
            envs.addProperty("includeFunctions", String.join((CharSequence)",", param.getIncludeFunctions()));
        }
        if (!CollectionUtils.isEmpty(param.getExceptFunctions())) {
            envs.addProperty("exceptFunctions", String.join((CharSequence)",", param.getExceptFunctions()));
        }
        strategy.setEnvs(envs.toString());
        strategy.setAlertMembers(String.join((CharSequence)",", param.getAlertMembers() == null ? new ArrayList() : param.getAlertMembers()));
        strategy.setAtMembers(String.join((CharSequence)",", param.getAtMembers() == null ? new ArrayList() : param.getAtMembers()));
        if (!this.appAlarmStrategyDao.updateById(strategy)) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        log.info("\u66f4\u65b0\u89c4\u5219\u7b56\u7565\u6210\u529f\uff1astrategy={}", (Object)strategy);
        return Result.success((Object)strategy);
    }

    @Override
    public Result enabled(String user, AlarmStrategyParam param) {
        AppMonitor app;
        AlarmStrategy strategy = this.appAlarmStrategyDao.getById(param.getId());
        if (strategy == null) {
            return Result.fail((ErrorCode)ErrorCode.nonExistentStrategy);
        }
        AppMonitor appMonitor = app = AlarmStrategyType.TESLA.getCode().equals(strategy.getStrategyType()) ? this.appMonitorDao.getByIamTreeId(strategy.getIamId()) : this.appMonitorDao.getMyApp(strategy.getAppId(), strategy.getIamId(), user, AppViewType.MyApp);
        if (app == null) {
            return Result.fail((ErrorCode)ErrorCode.NoOperPermission);
        }
        Integer ruleStat = param.getStatus() == 0 ? 1 : 0;
        Result result = this.appAlarmService.enabledRules(strategy.getIamId(), strategy.getId(), ruleStat, user);
        if (result.getCode() != ErrorCode.success.getCode()) {
            return result;
        }
        strategy = new AlarmStrategy();
        strategy.setId(param.getId());
        strategy.setStatus(param.getStatus());
        if (!this.appAlarmStrategyDao.updateById(strategy)) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        log.info("enabled\u89c4\u5219\u7b56\u7565\u6210\u529f\uff1astrategy={}", (Object)strategy);
        return Result.success(null);
    }

    @Override
    public Result batchDeleteStrategy(String user, List<Integer> strategyIds) {
        if (CollectionUtils.isEmpty(strategyIds)) {
            log.error("batchDeleteStrategy param error!user:{} strategyIds:{}", (Object)user, strategyIds);
            return Result.success();
        }
        for (Integer id : strategyIds) {
            try {
                Result result = this.deleteById(user, id);
                if (result.isSuccess()) continue;
                log.error("deleteById fail! user : {}, id : {} ,result : {}", new Object[]{user, id, new Gson().toJson((Object)result)});
            }
            catch (Exception e) {
                log.error("deleteById error!user:" + user + ",strategyId:" + id + ",exception:" + e.getMessage(), (Throwable)e);
            }
        }
        return Result.success();
    }

    @Override
    public Result deleteById(String user, Integer strategyId) {
        AppMonitor app;
        if (strategyId == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        AlarmStrategy strategy = this.appAlarmStrategyDao.getById(strategyId);
        if (strategy == null) {
            return Result.fail((ErrorCode)ErrorCode.nonExistentStrategy);
        }
        log.info("AlarmStrategyService.deleteById strategy : {}", (Object)new Gson().toJson((Object)strategy));
        AppMonitor appMonitor = app = AlarmStrategyType.TESLA.getCode().equals(strategy.getStrategyType()) ? this.appMonitorDao.getByIamTreeId(strategy.getIamId()) : this.appMonitorDao.getMyApp(strategy.getAppId(), strategy.getIamId(), user, AppViewType.MyApp);
        if (app == null) {
            return Result.fail((ErrorCode)ErrorCode.NoOperPermission);
        }
        Result result = this.appAlarmService.deleteRulesByIamId(strategy.getIamId(), strategyId, user);
        if (result.getCode() != ErrorCode.success.getCode()) {
            return result;
        }
        if (!this.appAlarmStrategyDao.deleteById(strategyId)) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        log.info("\u5220\u9664\u89c4\u5219\u7b56\u7565\u6210\u529f\uff1astrategy={}", (Object)strategy);
        return Result.success(null);
    }

    @Override
    public Result deleteByStrategyId(String user, Integer strategyId) {
        if (strategyId == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        AlarmStrategy strategy = this.appAlarmStrategyDao.getById(strategyId);
        if (strategy == null) {
            return Result.fail((ErrorCode)ErrorCode.nonExistentStrategy);
        }
        log.info("AlarmStrategyService.deleteById strategy : {}", (Object)new Gson().toJson((Object)strategy));
        Result result = this.appAlarmService.deleteRulesByIamId(strategy.getIamId(), strategyId, user);
        if (result.getCode() != ErrorCode.success.getCode()) {
            return result;
        }
        if (!this.appAlarmStrategyDao.deleteById(strategyId)) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        log.info("\u5220\u9664\u89c4\u5219\u7b56\u7565\u6210\u529f\uff1astrategy={}", (Object)strategy);
        return Result.success(null);
    }

    @Override
    public Result<AlarmStrategyInfo> detailed(String user, AlarmStrategyParam param) {
        AlarmStrategyInfo info = this.appAlarmStrategyDao.getInfoById(param.getId());
        if (info != null) {
            this.setRuleListData(info);
        }
        return Result.success((Object)info);
    }

    private void setRuleListData(AlarmStrategyInfo info) {
        if (info == null) {
            return;
        }
        List<AppAlarmRule> ruleList = this.appAlarmRuleDao.selectByStrategyId(info.getId());
        info.setAlarmRules(ruleList);
        if (StringUtils.isBlank((CharSequence)info.getAlertTeam()) && !CollectionUtils.isEmpty(ruleList)) {
            info.setAlertTeam(ruleList.get(0).getAlertTeam());
        }
    }

    @Override
    public Result<PageData<List<AlarmStrategyInfo>>> search(String user, AlarmStrategyParam param) {
        if (!this.paramCheck(param)) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        AlarmStrategy strategy = new AlarmStrategy();
        strategy.setStrategyName(param.getStrategyName());
        strategy.setStrategyType(param.getStrategyType());
        strategy.setAppId(param.getAppId());
        strategy.setAppName(param.getAppName());
        strategy.setStatus(param.getStatus());
        Map<Integer, UseDetailInfo.DeptDescr> deptMap = LocalUser.getDepts();
        if (deptMap.containsKey(3)) {
            strategy.setGroup3(deptMap.get(3).getDeptName());
        }
        if (deptMap.containsKey(4)) {
            strategy.setGroup4(deptMap.get(4).getDeptName());
        }
        if (deptMap.containsKey(5)) {
            strategy.setGroup5(deptMap.get(5).getDeptName());
        }
        PageData<List<AlarmStrategyInfo>> pageData = this.appAlarmStrategyDao.searchByCond(user, param.isOwner(), strategy, param.getPage(), param.getPageSize(), param.getSortBy(), param.getSortOrder());
        this.ruleDataHandler(pageData.getList());
        return Result.success(pageData);
    }

    private boolean paramCheck(AlarmStrategyParam param) {
        if (!orderColumn.contains(param.getSortBy())) {
            log.info("param sortBy is error!");
            log.error("param sortBy is error!");
            return false;
        }
        if (!orderSorts.contains(param.getSortOrder())) {
            log.info("param sortOrder is error!");
            log.error("param sortOrder is error!");
            return false;
        }
        return true;
    }

    private List<AlarmStrategyInfo> listStrategyByAppIdAndIamId(Integer appId, Integer iamId) {
        AlarmStrategy strategy = new AlarmStrategy();
        strategy.setStatus(0);
        strategy.setAppId(appId);
        strategy.setIamId(iamId);
        PageData<List<AlarmStrategyInfo>> listPageData = this.appAlarmStrategyDao.searchByCondNoUser(strategy, 1, 5000, null, null);
        if (listPageData == null) {
            return null;
        }
        return listPageData.getList();
    }

    @Override
    public void deleteByAppIdAndIamId(Integer appId, Integer iamId) {
        List<AlarmStrategyInfo> alarmStrategyInfos = this.listStrategyByAppIdAndIamId(appId, iamId);
        if (CollectionUtils.isEmpty(alarmStrategyInfos)) {
            log.info("AlarmStrategyService#deleteByAppIdAndIamId no data found!appId:{},iamId:{}", (Object)appId, (Object)iamId);
            return;
        }
        for (AlarmStrategyInfo strategy : alarmStrategyInfos) {
            Result result = this.appAlarmService.deleteRulesByIamId(strategy.getIamId(), strategy.getId(), null);
            if (result.getCode() != ErrorCode.success.getCode()) {
                log.error("deleteByAppIdAndIamId delete alarmRules fail! strategy : {}", (Object)strategy.toString());
                continue;
            }
            if (this.appAlarmStrategyDao.deleteById(strategy.getId())) continue;
            log.error("deleteByAppIdAndIamId delete strategy fail! strategy : {}", (Object)strategy.toString());
        }
    }

    @Override
    public Result<PageData> dubboSearch(String user, AlarmStrategyParam param) {
        StringBuilder metricStr = new StringBuilder();
        metricStr.append("sum(sum_over_time(staging_").append(param.getAppId()).append("_").append(param.getAppName()).append("_jaeger_dubboBisTotalCount_total{}[24h])) by (serviceName)");
        return this.prometheusService.queryByMetric(metricStr.toString());
    }

    private void ruleDataHandler(List<AlarmStrategyInfo> infoList) {
        if (infoList == null || infoList.isEmpty()) {
            return;
        }
        Map<Integer, AlarmStrategyInfo> infoMap = this.listToMap(infoList);
        List<AppAlarmRule> ruleList = this.appAlarmRuleDao.selectByStrategyIdList(infoMap.keySet().stream().collect(Collectors.toList()));
        if (ruleList == null) {
            return;
        }
        AlarmStrategyInfo info = null;
        for (AppAlarmRule rule : ruleList) {
            if (rule.getStrategyId() == null || (info = infoMap.get(rule.getStrategyId())) == null) continue;
            if (info.getAlarmRules() == null) {
                info.setAlarmRules(new ArrayList<AppAlarmRule>());
            }
            info.getAlarmRules().add(rule);
            if (!StringUtils.isBlank((CharSequence)info.getAlertTeam())) continue;
            info.setAlertTeam(rule.getAlertTeam());
        }
    }

    private Map<Integer, AlarmStrategyInfo> listToMap(List<AlarmStrategyInfo> infoList) {
        if (CollectionUtils.isEmpty(infoList)) {
            return null;
        }
        HashMap<Integer, AlarmStrategyInfo> infoMap = new HashMap<Integer, AlarmStrategyInfo>();
        for (AlarmStrategyInfo info : infoList) {
            if (infoMap.containsKey(info.getId()) && !info.isOwner()) continue;
            infoMap.put(info.getId(), info);
        }
        return infoMap;
    }
}

