/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.prometheus;

import com.google.gson.Gson;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ozhera.monitor.dao.AppCapacityAutoAdjustDao;
import org.apache.ozhera.monitor.dao.model.AppCapacityAutoAdjust;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.api.PrometheusServiceExtension;
import org.apache.ozhera.monitor.service.extension.MetricsExtensionService;
import org.apache.ozhera.monitor.service.http.MoneSpec;
import org.apache.ozhera.monitor.service.http.RestTemplateService;
import org.apache.ozhera.monitor.service.kubernetes.CapacityAdjustMessageService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.prometheus.Metric;
import org.apache.ozhera.monitor.service.model.prometheus.MetricData;
import org.apache.ozhera.monitor.service.model.prometheus.MetricDataSet;
import org.apache.ozhera.monitor.service.model.prometheus.MetricDataSetVector;
import org.apache.ozhera.monitor.service.model.prometheus.MetricDataVector;
import org.apache.ozhera.monitor.service.model.prometheus.MetricResponse;
import org.apache.ozhera.monitor.service.model.prometheus.MetricResponseVector;
import org.apache.ozhera.monitor.service.model.prometheus.ServiceQps;
import org.apache.ozhera.monitor.service.model.prometheus.TeslaMetric;
import org.apache.ozhera.monitor.service.model.prometheus.TeslaMetricData;
import org.apache.ozhera.monitor.service.model.prometheus.TeslaMetricDataSet;
import org.apache.ozhera.monitor.service.model.prometheus.TeslaMetricResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PrometheusService {
    private static final Logger log = LoggerFactory.getLogger(PrometheusService.class);
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static final String URI_QUERY_MOMENT = "/api/v1/query";
    private static final String URI_QUERY_RANGE = "/api/v1/query_range";
    private static final String P_QUERY = "query";
    private static final String P_TIME = "time";
    private static final String P_STEP = "step";
    private static final String P_START = "start";
    private static final String P_END = "end";
    private static final String P_DEDUP = "dedup";
    private static final String P_PARTIAL_RESPONSE = "partial_response";
    private static final String UNDER_LINE = "_";
    private static final String METRIC_HERA_SIGN = "hera";
    private static final int YOUPIN_GROUP_ORACLE = 2;
    private static final int CHINA_GROUP_ORACLE = 0;
    private static final double LOAD_THRESHOLD_ORACLE = 0.7;
    public static final String RANGE_REQUEST_MODE = "range";
    public static final String MOMENT_REQUEST_MODE = "moment";
    private final Gson gson = new Gson();
    @Autowired
    private PrometheusServiceExtension prometheusServiceImpl;
    @Autowired
    RestTemplateService restTemplateService;
    @Autowired
    AppCapacityAutoAdjustDao appCapacityAutoAdjustDao;
    @Autowired
    CapacityAdjustMessageService capacityAdjustMessageService;
    @Autowired
    MetricsExtensionService metricsExtensionService;
    @Value(value="${prometheus.url}")
    private String prometheusUrl;
    @Value(value="${server.type}")
    private String env;

    public Result<PageData> queryRange(String metric_, Map labels, String projectName, String metricSuffix, Long startTime, Long endTime, Long step, String op, double value) {
        log.info("PrometheusService.queryRange received param metric_ : {}, labels : {}, projectName : {}, metricSuffix : {}, startTime : {}, endTime: {}, step : {}, op : {},value : {} ", new Object[]{metric_, labels, projectName, metricSuffix, startTime, endTime, step, op, value});
        String metric = this.completePromQL(metric_, labels, projectName, metricSuffix, op, value, null, null);
        log.info("PrometheusService.queryRange metric : {} ", (Object)metric);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, metric);
        map.put(P_START, startTime);
        map.put(P_END, endTime);
        map.put(P_STEP, step);
        map.put(P_DEDUP, true);
        map.put(P_PARTIAL_RESPONSE, true);
        String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_RANGE), map);
        log.info("PrometheusService.queryRange  metric : {}, labels : {}, projectName : {}, metricSuffix : {}, startTime : {}, endTime: {}, step : {}, op : {},value : {},result : {} ", new Object[]{metric, labels, projectName, metricSuffix, startTime, endTime, step, op, value, data});
        MetricResponse metricResult = (MetricResponse)new Gson().fromJson(data, MetricResponse.class);
        if (metricResult == null || !"success".equals(metricResult.getStatus())) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        MetricData metricData = metricResult.getData();
        List<MetricDataSet> result = metricData.getResult();
        PageData<List<Metric>> pageData = new PageData<List<Metric>>();
        pageData.setTotal(CollectionUtils.isEmpty(result) ? 0L : (long)result.size());
        List<Metric> metrics = this.convertMetric(result);
        pageData.setList(metrics);
        return Result.success(pageData);
    }

    public Result<PageData> queryRangeSumOverTime(String metric_, Map labels, String projectName, String metricSuffix, Long startTime, Long endTime, Long step, String duration, String sumBy) {
        String offset = null;
        Long offsetLong = System.currentTimeMillis() / 1000L - endTime;
        if (offsetLong > 0L) {
            offset = offsetLong + "s";
        }
        endTime = System.currentTimeMillis() / 1000L;
        String metricSource = this.completePromQL(metric_, labels, projectName, metricSuffix, null, 0.0, duration, offset);
        String sumOverTimeFunc = this.sumSumOverTimeFunc(metricSource, metric_, sumBy);
        log.info("PrometheusService.queryRangeSumOverTime sumOverTimeFunc : {} ", (Object)sumOverTimeFunc);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, sumOverTimeFunc);
        map.put(P_TIME, endTime);
        map.put(P_START, startTime);
        map.put(P_END, endTime);
        map.put(P_STEP, step);
        map.put(P_DEDUP, true);
        map.put(P_PARTIAL_RESPONSE, true);
        String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_MOMENT), map);
        log.info("PrometheusService.queryRangeSumOverTime sumOverTimeFunc : {},startTime : {},endTime : {}, step : {}, result : {}", new Object[]{sumOverTimeFunc, startTime, endTime, step, data});
        MetricResponseVector metricResult = (MetricResponseVector)new Gson().fromJson(data, MetricResponseVector.class);
        if (metricResult == null || !"success".equals(metricResult.getStatus())) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        MetricDataVector metricData = metricResult.getData();
        List<MetricDataSetVector> result = metricData.getResult();
        PageData<List<Metric>> pageData = new PageData<List<Metric>>();
        List<Metric> metrics = this.convertValidMetric(result);
        pageData.setList(metrics);
        pageData.setTotal(CollectionUtils.isEmpty(metrics) ? 0L : (long)metrics.size());
        return Result.success(pageData);
    }

    public Result<PageData> queryCountOverTime(String metric_, Map labels, String projectName, String metricSuffix, Long startTime, Long endTime, Long step, String duration) {
        String offset = null;
        Long offsetLong = System.currentTimeMillis() / 1000L - endTime;
        if (offsetLong > 0L) {
            offset = offsetLong + "s";
        }
        String metric = this.completePromQL(metric_, labels, projectName, metricSuffix, null, 0.0, duration, offset);
        String countOverTimeFunc = this.countOverTimeFunc(metric);
        log.info("PrometheusService.queryCountOverTime countOverTimeFunc : {} ", (Object)countOverTimeFunc);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, countOverTimeFunc);
        map.put(P_TIME, endTime);
        map.put(P_START, startTime);
        map.put(P_END, endTime);
        map.put(P_STEP, step);
        map.put(P_DEDUP, true);
        map.put(P_PARTIAL_RESPONSE, true);
        String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_MOMENT), map);
        log.info("PrometheusService.queryRangeSumOverTime sumOverTimeFunc : {},startTime : {},endTime : {}, step : {}, result : {}", new Object[]{countOverTimeFunc, startTime, endTime, step, data});
        MetricResponseVector metricResult = (MetricResponseVector)new Gson().fromJson(data, MetricResponseVector.class);
        if (metricResult == null || !"success".equals(metricResult.getStatus())) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        MetricDataVector metricData = metricResult.getData();
        List<MetricDataSetVector> result = metricData.getResult();
        PageData<List<Metric>> pageData = new PageData<List<Metric>>();
        List<Metric> metrics = this.convertValidMetric(result);
        pageData.setList(metrics);
        pageData.setTotal(CollectionUtils.isEmpty(metrics) ? 0L : (long)metrics.size());
        return Result.success(pageData);
    }

    public Result<PageData> queryIncrease(String metric_, Map labels, String projectName, String metricSuffix, Long startTime, Long endTime, Long step, String duration) {
        String offset = null;
        Long offsetLong = System.currentTimeMillis() / 1000L - endTime;
        if (offsetLong > 0L) {
            offset = offsetLong + "s";
        }
        String metric = this.completePromQL(metric_, labels, projectName, metricSuffix, null, 0.0, duration, offset);
        String increaseFunc = this.increaseFunc(metric);
        log.info("PrometheusService.queryIncrease increaseFunc : {} ", (Object)increaseFunc);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, increaseFunc);
        map.put(P_TIME, endTime);
        map.put(P_START, startTime);
        map.put(P_END, endTime);
        map.put(P_STEP, step);
        map.put(P_DEDUP, true);
        map.put(P_PARTIAL_RESPONSE, true);
        String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_MOMENT), map);
        log.info("PrometheusService.queryIncrease increaseFunc : {},startTime : {},endTime : {}, step : {}, result : {}", new Object[]{increaseFunc, startTime, endTime, step, data});
        MetricResponseVector metricResult = (MetricResponseVector)new Gson().fromJson(data, MetricResponseVector.class);
        if (metricResult == null || !"success".equals(metricResult.getStatus())) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        MetricDataVector metricData = metricResult.getData();
        List<MetricDataSetVector> result = metricData.getResult();
        PageData<List<Metric>> pageData = new PageData<List<Metric>>();
        List<Metric> metrics = this.convertValidMetric(result);
        pageData.setList(metrics);
        pageData.setTotal(CollectionUtils.isEmpty(metrics) ? 0L : (long)metrics.size());
        return Result.success(pageData);
    }

    public Result<PageData> queryByMetric(String metric) {
        Long time = System.currentTimeMillis() / 1000L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, metric);
        map.put(P_TIME, time);
        map.put(P_DEDUP, true);
        map.put(P_PARTIAL_RESPONSE, true);
        String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_MOMENT), map);
        log.info("PrometheusService.queryByMetric metric : {}, result : {}", (Object)metric, (Object)data);
        MetricResponseVector metricResult = (MetricResponseVector)new Gson().fromJson(data, MetricResponseVector.class);
        if (metricResult == null || !"success".equals(metricResult.getStatus())) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        MetricDataVector metricData = metricResult.getData();
        List<MetricDataSetVector> result = metricData.getResult();
        PageData<List<Metric>> pageData = new PageData<List<Metric>>();
        List<Metric> metrics = this.convertValidMetric(result);
        pageData.setList(metrics);
        pageData.setTotal(CollectionUtils.isEmpty(metrics) ? 0L : (long)metrics.size());
        return Result.success(pageData);
    }

    private List<Metric> convertMetric(List<MetricDataSet> result) {
        ArrayList<Metric> list = new ArrayList<Metric>();
        if (!CollectionUtils.isEmpty(result)) {
            for (MetricDataSet metricDataSet : result) {
                Metric metric = metricDataSet.getMetric();
                try {
                    List<List<Long>> values = metricDataSet.getValues();
                    List<Long> longs = values.get(values.size() - 1);
                    Long time = longs.get(0);
                    String lastCreateTime = this.formatDate(time * 1000L);
                    Long cost = longs.get(1);
                    metric.setLastCreateTime(lastCreateTime);
                    metric.setValue(cost.longValue());
                }
                catch (Exception e) {
                    log.error("convertMetric error:{}", (Object)e.getMessage());
                }
                list.add(metric);
            }
        }
        return list;
    }

    private List<TeslaMetric> convertTeslaMetric(List<TeslaMetricDataSet> result) {
        ArrayList<TeslaMetric> list = new ArrayList<TeslaMetric>();
        if (!CollectionUtils.isEmpty(result)) {
            for (TeslaMetricDataSet metricDataSet : result) {
                TeslaMetric metric = metricDataSet.getMetric();
                try {
                    List<List<Long>> values = metricDataSet.getValues();
                    List<Long> longs = values.get(values.size() - 1);
                    Long time = longs.get(0);
                    String lastCreateTime = this.formatDate(time * 1000L);
                    Long cost = longs.get(1);
                    metric.setValue(cost.longValue());
                }
                catch (Exception e) {
                    log.error("convertMetric error:{}", (Object)e.getMessage());
                }
                list.add(metric);
            }
        }
        return list;
    }

    private List<Metric> convertValidMetric(List<MetricDataSetVector> result) {
        ArrayList<Metric> list = new ArrayList<Metric>();
        if (!CollectionUtils.isEmpty(result)) {
            int count = 0;
            for (MetricDataSetVector metricDataVector : result) {
                if (count > 1000) break;
                Metric metric = metricDataVector.getMetric();
                if (Double.valueOf(metricDataVector.getValue().get(1)) == 0.0) continue;
                try {
                    List<String> values = metricDataVector.getValue();
                    Long time = Long.valueOf(values.get(0));
                    String lastCreateTime = this.formatDate(time * 1000L);
                    double value = Double.valueOf(metricDataVector.getValue().get(1));
                    metric.setLastCreateTime(lastCreateTime);
                    metric.setValue(value);
                }
                catch (Exception e) {
                    log.error("convertMetric error:{}", (Object)e.getMessage());
                }
                list.add(metric);
                ++count;
            }
        }
        return list;
    }

    private String formatDate(Long date) {
        return simpleDateFormat.format(date);
    }

    public String queryRangeSum(String metric_, Map labels, String projectName, String metricSuffix, Long startTime, Long endTime, Long step, List groups) {
        String metric = this.completePromQL(metric_, labels, projectName, metricSuffix, null, 0.0, null, null);
        String sumFunc = this.sumFunc(metric, groups);
        log.info("PrometheusService.queryRangeSum sumFunc : {} ", (Object)sumFunc);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, sumFunc);
        map.put(P_START, startTime);
        map.put(P_END, endTime);
        map.put(P_STEP, step);
        map.put(P_DEDUP, true);
        map.put(P_PARTIAL_RESPONSE, true);
        String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_RANGE), map);
        log.info("PrometheusService.queryRangeSum sumFunc : {},startTime : {},endTime : {}, step : {}, result : {}", new Object[]{sumFunc, startTime, endTime, step, data});
        return data;
    }

    private String sumFunc(String source, List<String> groups) {
        StringBuilder sb = new StringBuilder();
        sb.append(" sum(");
        sb.append(source);
        sb.append(") ");
        if (!CollectionUtils.isEmpty(groups)) {
            String s = StringUtils.collectionToCommaDelimitedString(groups);
            sb.append(" by (").append(s).append(")");
        }
        return sb.toString();
    }

    private String sumOverTimeFunc(String source) {
        StringBuilder sb = new StringBuilder();
        sb.append(" sum_over_time(");
        sb.append(source);
        sb.append(") ");
        return sb.toString();
    }

    private String sumSumOverTimeFunc(String source, String metric, String sumBy) {
        StringBuilder sb = new StringBuilder();
        sb.append("sum(sum_over_time(");
        sb.append(source);
        sb.append(")) ");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sumBy)) {
            sb.append(" by (").append(sumBy).append(")");
        } else {
            switch (metric) {
                case "dubboProviderSLAError": {
                    sb.append(" by (application,methodName,serviceName,serverEnv,serverZone,clientProjectName,clientEnv) ");
                    break;
                }
                case "dubboConsumerError": {
                    sb.append(" by (serverIp,application,methodName,serviceName,serverEnv,serverZone) ");
                    break;
                }
                case "dubboProviderError": {
                    sb.append(" by (serverIp,application,methodName,serviceName,serverEnv,serverZone) ");
                    break;
                }
                case "httpError": {
                    sb.append(" by (serverIp,application,methodName,serviceName,serverEnv,serverZone,errorCode) ");
                    break;
                }
                case "httpClientError": {
                    sb.append(" by (serverIp,application,methodName,serviceName,serverEnv,serverZone,errorCode) ");
                    break;
                }
                case "redisError": {
                    sb.append(" by (serverIp,application,method,serverEnv,serverZone) ");
                    break;
                }
                case "dbError": {
                    sb.append(" by (serverIp,application,dataSource,sqlMethod,sql,serverEnv,serverZone) ");
                    break;
                }
                case "grpcClientError": {
                    sb.append(" by (serverIp,application,methodName,serviceName,serverEnv,serverZone) ");
                    break;
                }
                case "grpcServerError": {
                    sb.append(" by (serverIp,application,methodName,serviceName,serverEnv,serverZone) ");
                    break;
                }
                case "thriftServerError": {
                    sb.append(" by (serverIp,application,methodName,serviceName,serverEnv,serverZone) ");
                    break;
                }
                case "thriftClientError": {
                    sb.append(" by (serverIp,application,methodName,serviceName,serverEnv,serverZone) ");
                    break;
                }
                case "apusServerError": {
                    sb.append(" by (serverIp,application,methodName,serviceName,serverEnv,serverZone) ");
                    break;
                }
                case "apusClientError": {
                    sb.append(" by (serverIp,application,methodName,serviceName,serverEnv,serverZone) ");
                    break;
                }
                case "oracleError": {
                    sb.append(" by (serverIp,application,dataSource,sqlMethod,sql,serverEnv,serverZone) ");
                    break;
                }
                case "elasticsearchClientError": {
                    sb.append(" by (serverIp,application,dataSource,sqlMethod,sql,serverEnv,serverZone) ");
                    break;
                }
                default: {
                    sb.append(" by (serverIp,application,methodName,serviceName,dataSource,sqlMethod,sql,serverEnv,serverZone,containerName,method,clientProjectId,clientProjectName,clientEnv) ");
                }
            }
        }
        return sb.toString();
    }

    private String countOverTimeFunc(String source) {
        StringBuilder sb = new StringBuilder();
        sb.append(" count_over_time(");
        sb.append(source);
        sb.append(") ");
        return sb.toString();
    }

    private String increaseFunc(String source) {
        StringBuilder sb = new StringBuilder();
        sb.append(" increase(");
        sb.append(source);
        sb.append(") ");
        return sb.toString();
    }

    public String completePromQL(String source, Map labels, String projectName, String metricSuffix, String op, double value, String duration, String offset) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.env) || "dev".equals(this.env)) {
            this.env = "staging";
        }
        projectName = projectName.replaceAll("-", UNDER_LINE);
        StringBuilder promQL = new StringBuilder(this.env).append(UNDER_LINE).append(this.metricsExtensionService.getMetricsPrefix()).append(UNDER_LINE).append(source).append(metricSuffix == null ? "" : metricSuffix);
        promQL.append("{");
        promQL.append("application='").append(projectName).append("',");
        if (!CollectionUtils.isEmpty((Map)labels)) {
            Set set = labels.entrySet();
            for (Map.Entry entry : set) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                promQL.append((String)entry.getKey());
                promQL.append("=");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue())) && ((String)entry.getValue()).indexOf("|") > 0) {
                    promQL.append("~");
                }
                promQL.append("'");
                promQL.append((String)entry.getValue());
                promQL.append("'");
                promQL.append(",");
            }
        }
        promQL.append("}");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)op)) {
            promQL.append(op).append(value);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)duration)) {
            promQL.append("[").append(duration).append("]");
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)offset)) {
            promQL.append(" offset ").append(offset);
        }
        return promQL.toString();
    }

    public String completeMetric(String source, Map includeLabels, Map exceptLabels, Integer projectId, String projectName, String metricSuffix, String duration, String offset) {
        String labelsV;
        Set set;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.env) || "dev".equals(this.env)) {
            this.env = "staging";
        }
        projectName = projectName.replaceAll("-", UNDER_LINE);
        String applicationSign = projectId + UNDER_LINE + projectName;
        StringBuilder promQL = new StringBuilder(this.env).append(UNDER_LINE).append(METRIC_HERA_SIGN).append(UNDER_LINE).append(source).append(metricSuffix == null ? "" : metricSuffix);
        promQL.append("{");
        promQL.append("application='").append(applicationSign).append("',");
        StringBuilder labels = new StringBuilder();
        if (!CollectionUtils.isEmpty((Map)includeLabels)) {
            set = includeLabels.entrySet();
            for (Map.Entry entry : set) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                labels.append((String)entry.getKey());
                labels.append("=~");
                labels.append("'");
                labels.append(".*").append((String)entry.getValue()).append(".*");
                labels.append("'");
                labels.append(",");
            }
        }
        if (!CollectionUtils.isEmpty((Map)exceptLabels)) {
            set = exceptLabels.entrySet();
            for (Map.Entry entry : set) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                labels.append((String)entry.getKey());
                labels.append("!=~");
                labels.append("'");
                labels.append(".*").append((String)entry.getValue()).append(".*");
                labels.append("'");
                labels.append(",");
            }
        }
        if ((labelsV = labels.toString()).endsWith(",")) {
            labelsV = labelsV.substring(0, labelsV.length() - 1);
        }
        promQL.append(labelsV);
        promQL.append("}");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)duration)) {
            promQL.append("[").append(duration).append("]");
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)offset)) {
            promQL.append(" offset ").append(offset);
        }
        return promQL.toString();
    }

    public String completeMetricForAlarm(String source, Map includeLabels, Map exceptLabels, Integer projectId, String projectName, String metricSuffix, String duration, String offset) {
        String labelsV;
        Set set;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.env) || "dev".equals(this.env)) {
            this.env = "staging";
        }
        projectName = projectName.replaceAll("-", UNDER_LINE);
        String applicationSign = projectId + UNDER_LINE + projectName;
        StringBuilder promQL = new StringBuilder(this.env).append(UNDER_LINE).append(this.metricsExtensionService.getMetricsPrefix()).append(UNDER_LINE).append(source).append(metricSuffix == null ? "" : metricSuffix);
        promQL.append("{");
        promQL.append("application='").append(applicationSign).append("',");
        StringBuilder labels = new StringBuilder();
        if (!CollectionUtils.isEmpty((Map)includeLabels)) {
            set = includeLabels.entrySet();
            for (Map.Entry entry : set) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                labels.append((String)entry.getKey());
                labels.append("=~");
                labels.append("'");
                labels.append((String)entry.getValue());
                labels.append("'");
                labels.append(",");
            }
        }
        if (!CollectionUtils.isEmpty((Map)exceptLabels)) {
            set = exceptLabels.entrySet();
            for (Map.Entry entry : set) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                labels.append((String)entry.getKey());
                labels.append("!~");
                labels.append("'");
                labels.append((String)entry.getValue());
                labels.append("'");
                labels.append(",");
            }
        }
        if ((labelsV = labels.toString()).endsWith(",")) {
            labelsV = labelsV.substring(0, labelsV.length() - 1);
        }
        promQL.append(labelsV);
        promQL.append("}");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)duration)) {
            promQL.append("[").append(duration).append("]");
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)offset)) {
            promQL.append(" offset ").append(offset);
        }
        return promQL.toString();
    }

    private String completeQueryUrl(String domain, String uri) {
        return new StringBuffer(domain).append(uri).toString();
    }

    public Result<PageData> getTeslaError(String department, String area) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("job", this.getTeslaJob(department, area));
        String metrics = "errCode";
        String projectName = "tesla";
        String metricSuffix = "total";
        Long startTime = (System.currentTimeMillis() - 21600000L) / 1000L;
        Long endTime = System.currentTimeMillis() / 1000L;
        Long step = (endTime - startTime) / 2L;
        String op = ">";
        double value = 0.0;
        return this.queryTeslaRange(metrics, labels, projectName, metricSuffix, startTime, endTime, step, op, value, department, area);
    }

    private String getTeslaJob(String department, String area) {
        switch (department) {
            case "china": {
                if ("dev".equals(this.env) || "staging".equals(this.env)) {
                    return "tesla-china-intranet";
                }
                if ("online".equals(this.env)) {
                    if ("in".equals(area)) {
                        return "tesla-china-intranet";
                    }
                    if ("out".equals(area)) {
                        return "tesla-china";
                    }
                    return "";
                }
                return "";
            }
            case "youpin": {
                return "tesla-youpin";
            }
            case "innovation": {
                if ("dev".equals(this.env) || "staging".equals(this.env)) {
                    return "tesla-innovation-intranet";
                }
                if ("online".equals(this.env)) {
                    if ("in".equals(area)) {
                        return "tesla-innovation-intranet";
                    }
                    if ("out".equals(area)) {
                        return "tesla-innovation";
                    }
                    return "";
                }
                return "";
            }
        }
        return "";
    }

    private String getTeslaEnv(String department, String area) {
        switch (department) {
            case "china": {
                if ("dev".equals(this.env) || "staging".equals(this.env)) {
                    return "mistaging";
                }
                if ("online".equals(this.env)) {
                    if ("in".equals(area)) {
                        return "miintranet";
                    }
                    if ("out".equals(area)) {
                        return "online";
                    }
                    return "";
                }
                return "";
            }
            case "youpin": {
                return "tesla-youpin";
            }
            case "innovation": {
                if ("dev".equals(this.env) || "staging".equals(this.env)) {
                    return "mistaging";
                }
                if ("online".equals(this.env)) {
                    if ("in".equals(area)) {
                        return "miintranet";
                    }
                    if ("out".equals(area)) {
                        return "online";
                    }
                    return "";
                }
                return "";
            }
        }
        return "";
    }

    public Result<PageData> queryTeslaRange(String metric_, Map labels, String projectName, String metricSuffix, Long startTime, Long endTime, Long step, String op, double value, String department, String area) {
        String env = this.getTeslaEnv(department, area);
        String job = this.getTeslaJob(department, area);
        log.info("PrometheusService.queryTeslaRange env : {}, job : {}, department: {} ,area: {}", new Object[]{env, job, department, area});
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)env) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)job)) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        String metric = "ceil(sum(increase(" + env + UNDER_LINE + projectName + UNDER_LINE + metric_ + UNDER_LINE + metricSuffix + "{job=\"" + job + "\"}[6h])) by (group,url,code))" + op + value;
        System.out.println("metrics is : " + metric);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, metric);
        map.put(P_START, startTime);
        map.put(P_TIME, endTime);
        map.put(P_END, endTime);
        map.put(P_STEP, step);
        map.put(P_DEDUP, true);
        map.put(P_PARTIAL_RESPONSE, true);
        String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_RANGE), map);
        TeslaMetricResponse metricResult = (TeslaMetricResponse)new Gson().fromJson(data, TeslaMetricResponse.class);
        if (metricResult == null || !"success".equals(metricResult.getStatus())) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        TeslaMetricData metricData = metricResult.getData();
        List<TeslaMetricDataSet> result = metricData.getResult();
        PageData<List<TeslaMetric>> pageData = new PageData<List<TeslaMetric>>();
        pageData.setTotal(CollectionUtils.isEmpty(result) ? 0L : (long)result.size());
        List<TeslaMetric> metrics = this.convertTeslaMetric(result);
        pageData.setList(metrics);
        return Result.success(pageData);
    }

    public Result<PageData> queryTeslaMetric(String metric_, Map labels, Long startTime, Long endTime, String op, double value, Long step, String duration) {
        String offset = null;
        Long offsetLong = System.currentTimeMillis() / 1000L - endTime;
        if (offsetLong > 0L) {
            offset = offsetLong + "s";
        }
        String metric = this.completePromQLForTesla(metric_, labels, op, value, duration, offset);
        log.info("PrometheusService.queryTeslaMetric metric : {} ", (Object)metric);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, metric);
        map.put(P_TIME, endTime);
        map.put(P_START, startTime);
        map.put(P_END, endTime);
        map.put(P_STEP, step);
        map.put(P_DEDUP, true);
        map.put(P_PARTIAL_RESPONSE, true);
        String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_MOMENT), map);
        log.info("PrometheusService.queryIncrease metric : {},startTime : {},endTime : {}, step : {}, result : {}", new Object[]{metric, startTime, endTime, step, data});
        MetricResponseVector metricResult = (MetricResponseVector)new Gson().fromJson(data, MetricResponseVector.class);
        if (metricResult == null || !"success".equals(metricResult.getStatus())) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        MetricDataVector metricData = metricResult.getData();
        List<MetricDataSetVector> result = metricData.getResult();
        PageData<List<Metric>> pageData = new PageData<List<Metric>>();
        List<Metric> metrics = this.convertValidMetric(result);
        pageData.setList(metrics);
        pageData.setTotal(CollectionUtils.isEmpty(metrics) ? 0L : (long)metrics.size());
        return Result.success(pageData);
    }

    private String getLabels(Map<String, String> labels) {
        StringBuilder builder = new StringBuilder();
        if (!CollectionUtils.isEmpty(labels)) {
            Set<Map.Entry<String, String>> set = labels.entrySet();
            for (Map.Entry<String, String> entry : set) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entry.getValue())) continue;
                builder.append(entry.getKey());
                builder.append("=~");
                builder.append("'");
                builder.append(".*").append(entry.getValue()).append(".*");
                builder.append("'");
                builder.append(",");
            }
        }
        String result = builder.toString();
        return result.toString();
    }

    public String completePromQLForTesla(String source, Map labels, String op, double value, String duration, String offset) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.env) || "dev".equals(this.env)) {
            this.env = "staging";
        }
        StringBuilder builder = new StringBuilder();
        switch (source) {
            case "china_intranet_tesla_p99_time_cost": {
                String metric = this.env.equals("staging") ? "mistaging_tesla_use_time_bucket" : "miintranet_tesla_use_time_bucket";
                builder.append("histogram_quantile(0.99,sum(rate(").append(metric).append("{");
                builder.append(this.getLabels(labels));
                builder.append("}");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)duration)) {
                    builder.append("[").append(duration).append("]");
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)offset)) {
                    builder.append("offset ").append(offset);
                }
                builder.append(")) by (le,system,ip,instance, group,url))").append(op).append(value);
            }
            case "tesla_intranet_availability": {
                String metric_err = this.env.equals("staging") ? "mistaging_tesla_errCode_total" : "mistaging_tesla_TotalCounter_total";
                String metric_total = this.env.equals("staging") ? "mistaging_tesla_errCode_total" : "miintranet_tesla_TotalCounter_total";
                builder.append("(1- (sum(increase(").append(metric_err).append("{");
                builder.append(this.getLabels(labels));
                builder.append("}");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)duration)) {
                    builder.append("[").append(duration).append("]");
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)offset)) {
                    builder.append("offset ").append(offset);
                }
                builder.append(")>0) ").append(" by (system,url,group,instance,ip) / sum(increase(").append(metric_total).append("{");
                builder.append(this.getLabels(labels));
                builder.append("}");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)duration)) {
                    builder.append("[").append(duration).append("]");
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)offset)) {
                    builder.append("offset ").append(offset);
                }
                builder.append(")>0) by (system,url,group,instance,ip))) * 100 ");
            }
        }
        return builder.toString();
    }

    public Result queryServiceQps(String serviceName, String type) {
        String prometheusEnv = "staging";
        if ("online".equals(this.env)) {
            prometheusEnv = "online";
        }
        Object avgMetric = "";
        Object totalMetric = "";
        switch (type) {
            case "http": {
                avgMetric = "clamp_min(sum(sum_over_time(" + prometheusEnv + "_jaeger_aopTotalMethodCount_total{application=\"" + serviceName + "\"}[30s])/30)  / count(count(sum_over_time(" + prometheusEnv + "_jaeger_aopTotalMethodCount_total{application=\"" + serviceName + "\"}[30s])/30) by(serverIp)),0)";
                totalMetric = "clamp_min(sum(sum(sum_over_time(" + prometheusEnv + "_jaeger_aopTotalMethodCount_total{application=\"" + serviceName + "\"}[30s])/30) by(serverIp)) by (application),0)";
                break;
            }
            case "dubbo": {
                avgMetric = "clamp_min(sum(sum_over_time(" + prometheusEnv + "_jaeger_dubboMethodCalledCount_total{application=\"" + serviceName + "\"}[30s])/30)  /  count(count(sum_over_time(" + prometheusEnv + "_jaeger_dubboMethodCalledCount_total{application=\"" + serviceName + "\"}[30s])/30) by(serverIp)),0)";
                totalMetric = "clamp_min(sum(sum(sum_over_time(" + prometheusEnv + "_jaeger_dubboMethodCalledCount_total{application=\"" + serviceName + "\"}[30s])/30) by(serverIp)) by (application),0)";
                break;
            }
            default: {
                return Result.fail((ErrorCode)ErrorCode.UNKNOWN_TYPE);
            }
        }
        log.info("PrometheusService.queryServiceQps avgmetric : {},totalmetric : {} ", avgMetric, totalMetric);
        String avgQps = this.queryQpsByPrometheus((String)avgMetric);
        String totalQps = this.queryQpsByPrometheus((String)totalMetric);
        ServiceQps serviceQps = new ServiceQps();
        serviceQps.setType(type);
        serviceQps.setAvgQps(avgQps);
        serviceQps.setTotalQps(totalQps);
        return Result.success((Object)serviceQps);
    }

    private String queryQpsByPrometheus(String metric) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, metric);
        map.put(P_TIME, System.currentTimeMillis() / 1000L);
        try {
            String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_MOMENT), map);
            System.out.println(data);
            MetricResponseVector metricResult = (MetricResponseVector)new Gson().fromJson(data, MetricResponseVector.class);
            if (metricResult == null || !"success".equals(metricResult.getStatus())) {
                return "0";
            }
            return metricResult.getData().getResult().get(0).getValue().get(1);
        }
        catch (Exception e) {
            log.error("PrometheusService.queryQpsByPrometheus err :{}", (Object)e.toString());
            return "0";
        }
    }

    public Result<PageData> getServiceQps(String serviceName, String type) {
        return this.queryServiceQps(serviceName, type);
    }

    public Result queryDubboServiceList(String serviceName, String type, String startTime, String endTime) {
        return this.prometheusServiceImpl.queryDubboServiceList(serviceName, type, startTime, endTime);
    }

    private Result queryDubboServiceListByPrometheus(String metric, String type, String startTime, String endTime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, metric);
        Long multi = (Long.parseLong(endTime) - Long.parseLong(startTime)) / 3600L;
        if (multi < 1L) {
            multi = 1L;
        }
        map.put(P_STEP, multi * 15L);
        map.put(P_START, startTime);
        map.put(P_END, endTime);
        log.info("queryDubboServiceListByPrometheus map :{},url :{},promql :{}", new Object[]{this.gson.toJson(map), this.prometheusUrl + URI_QUERY_RANGE, metric});
        try {
            String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_RANGE), map);
            MetricResponseVector metricResult = (MetricResponseVector)new Gson().fromJson(data, MetricResponseVector.class);
            if (metricResult == null || !"success".equals(metricResult.getStatus())) {
                return Result.fail((ErrorCode)ErrorCode.success);
            }
            List<MetricDataSetVector> resultData = metricResult.getData().getResult();
            if (!resultData.isEmpty()) {
                if ("http".equals(type)) {
                    return Result.success(resultData.stream().map(it -> it.getMetric().getMethodName()));
                }
                return Result.success(resultData.stream().map(it -> it.getMetric().getServiceName()));
            }
            return Result.fail((ErrorCode)ErrorCode.success);
        }
        catch (Exception e) {
            log.error("PrometheusService.queryQpsByPrometheus err :{}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.success);
        }
    }

    public Result oracle(String mode, String type) {
        log.info("PrometheusService.oracle mode : {},type : {}", (Object)mode, (Object)type);
        switch (type) {
            case "load": {
                return this.loadTypeOracle(mode);
            }
            case "qps": {
                return this.qpsTypeOracle(mode);
            }
        }
        return Result.fail((ErrorCode)ErrorCode.UNKNOWN_TYPE);
    }

    public MetricResponse queryRangePrometheusByPromQl(String promQl, Long startTime, Long endTime, Long step, String mode) {
        Long finalStep = step != null ? step : (endTime - startTime) / 2L;
        String requestMode = mode != null ? mode : RANGE_REQUEST_MODE;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(P_QUERY, promQl);
        map.put(P_START, startTime);
        map.put(P_END, endTime);
        map.put(P_STEP, finalStep);
        map.put(P_DEDUP, true);
        map.put(P_PARTIAL_RESPONSE, true);
        String uri = "";
        if (RANGE_REQUEST_MODE.equals(requestMode)) {
            map.put(P_START, startTime);
            map.put(P_END, endTime);
            uri = URI_QUERY_RANGE;
        } else if (MOMENT_REQUEST_MODE.equals(requestMode)) {
            map.put(P_TIME, endTime);
            uri = URI_QUERY_MOMENT;
        }
        String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, uri), map);
        MetricResponse metricResult = (MetricResponse)new Gson().fromJson(data, MetricResponse.class);
        if (metricResult == null || !"success".equals(metricResult.getStatus())) {
            return null;
        }
        return metricResult;
    }

    private Result loadTypeOracle(String mode) {
        log.info("PrometheusService.loadTypeOracle mode : {}", (Object)mode);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 50, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(100), r -> new Thread(r, "compute-execute-thread-v2"), new ThreadPoolExecutor.CallerRunsPolicy());
        AppCapacityAutoAdjust autoQuery = new AppCapacityAutoAdjust();
        autoQuery.setStatus(0);
        autoQuery.setAutoCapacity(1);
        try {
            List<AppCapacityAutoAdjust> result = this.appCapacityAutoAdjustDao.query(autoQuery, null, null);
            result.stream().forEach(res -> {
                String container = res.getContainer();
                int pipelineId = res.getPipelineId();
                String query = "sum(container_spec_cpu_quota{system=\"mione\",container=\"" + container + "\",image != \"\"}) by (container) / sum(container_spec_cpu_period{system=\"mione\",container=\"" + container + "\",image != \"\"}) by (container)";
                executor.execute(() -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(P_QUERY, query);
                    map.put(P_TIME, System.currentTimeMillis() / 1000L);
                    String data = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_MOMENT), map);
                    MetricResponseVector metricResult = (MetricResponseVector)new Gson().fromJson(data, MetricResponseVector.class);
                    if (metricResult == null || !"success".equals(metricResult.getStatus())) {
                        return;
                    }
                    List<MetricDataSetVector> metricSet = metricResult.getData().getResult();
                    int cpuCoreSize = Integer.parseInt(metricSet.get(0).getValue().get(1));
                    Object loadQuery = "";
                    switch (mode) {
                        case "normal": {
                            loadQuery = "avg(container_cpu_load_average_10s{system=\"mione\",image != \"\",container=\"" + container + "\"}) by (container,namespace) /1000";
                            break;
                        }
                        case "predict": {
                            loadQuery = "";
                            break;
                        }
                        default: {
                            loadQuery = "";
                        }
                    }
                    map.put(P_QUERY, loadQuery);
                    String loadData = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_MOMENT), map);
                    MetricResponseVector loadMetricResult = (MetricResponseVector)new Gson().fromJson(loadData, MetricResponseVector.class);
                    if (loadMetricResult == null || !"success".equals(loadMetricResult.getStatus())) {
                        return;
                    }
                    List<MetricDataSetVector> loadMetricSet = loadMetricResult.getData().getResult();
                    Double podRealLoad = Double.parseDouble(loadMetricSet.get(0).getValue().get(1));
                    if ((double)cpuCoreSize * 0.7 < podRealLoad) {
                        log.info("container : {} ,pipeline: {},\u9700\u8981\u6269\u5bb9\u4e86 podRealLoad : {} ", new Object[]{container, pipelineId, podRealLoad});
                        String instanceQuery = "count(container_cpu_load_average_10s{system=\"mione\",image !=\"\",container=\"" + container + "\"}) by (pod) ";
                        map.put(P_QUERY, instanceQuery);
                        String instanceData = this.restTemplateService.getHttpM(this.completeQueryUrl(this.prometheusUrl, URI_QUERY_MOMENT), map);
                        MetricResponseVector instanceMetricResult = (MetricResponseVector)new Gson().fromJson(instanceData, MetricResponseVector.class);
                        if (instanceMetricResult == null || !"success".equals(instanceMetricResult.getStatus())) {
                            return;
                        }
                        List<MetricDataSetVector> instanceMetricSet = instanceMetricResult.getData().getResult();
                        int instanceNum = Integer.parseInt(instanceMetricSet.get(0).getValue().get(1));
                        MoneSpec moneSpec = new MoneSpec();
                        moneSpec.init();
                        moneSpec.setEnvID(pipelineId);
                        moneSpec.setNamespace(loadMetricSet.get(0).getMetric().getNamespace());
                        moneSpec.setContainer(loadMetricSet.get(0).getMetric().getContainer());
                        moneSpec.setReplicas(instanceNum);
                        moneSpec.setSetReplicas(this.CountExpectedInstance(instanceNum, "normal", res.getMaxInstance()));
                        this.capacityAdjustMessageService.product(moneSpec);
                    } else {
                        log.info("container : {} ,pipeline: {},\u4e0d\u9700\u8981\u6269\u5bb9\u4e86 podRealLoad : {} ", new Object[]{container, pipelineId, podRealLoad});
                    }
                });
            });
        }
        catch (Exception e) {
            log.error("loadTypeOracle error : {}", (Object)e.toString());
        }
        return Result.success((Object)0);
    }

    private Result qpsTypeOracle(String mode) {
        return Result.success((Object)"\u6682\u4e0d\u652f\u6301!");
    }

    private int CountExpectedInstance(int curInstance, String type, int maxInstance) {
        switch (type) {
            case "normal": {
                if (curInstance <= 3) {
                    return Math.min(curInstance + 1, maxInstance);
                }
                return Math.min(curInstance + curInstance / 3, maxInstance);
            }
        }
        return Math.min(curInstance + 1, maxInstance);
    }
}

