/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.config;

import java.util.List;
import org.apache.polaris.core.config.ImmutableError;
import org.apache.polaris.core.config.ImmutableProductionReadinessCheck;
import org.apache.polaris.immutables.PolarisImmutable;
import org.immutables.value.Value;

@PolarisImmutable
public interface ProductionReadinessCheck {
    public static final ProductionReadinessCheck OK = ImmutableProductionReadinessCheck.builder().build();

    public static ProductionReadinessCheck of(Error ... errors) {
        return ImmutableProductionReadinessCheck.builder().addErrors(errors).build();
    }

    public static ProductionReadinessCheck of(Iterable<? extends Error> errors) {
        return ImmutableProductionReadinessCheck.builder().addAllErrors(errors).build();
    }

    default public boolean ready() {
        return this.getErrors().isEmpty();
    }

    @Value.Parameter(order=1)
    public List<Error> getErrors();

    @PolarisImmutable
    public static interface Error {
        public static Error of(String message, String offendingProperty) {
            return ImmutableError.of(message, offendingProperty, false);
        }

        public static Error ofSevere(String message, String offendingProperty) {
            return ImmutableError.of(message, offendingProperty, true);
        }

        @Value.Parameter(order=1)
        public String message();

        @Value.Parameter(order=2)
        public String offendingProperty();

        @Value.Parameter(order=3)
        public boolean severe();
    }
}

