/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.runtime;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.internal.CrcChecksumProvider;
import software.amazon.awssdk.checksums.internal.CrcCloneOnMarkChecksum;
import software.amazon.awssdk.checksums.internal.CrcCombineOnMarkChecksum;
import software.amazon.awssdk.checksums.internal.SdkCrc32CChecksum;
import software.amazon.awssdk.core.checksums.Crc32Checksum;
import software.amazon.awssdk.core.internal.checksums.factory.SdkCrc32;
import software.amazon.awssdk.crt.checksums.CRC64NVME;
import software.amazon.awssdk.http.auth.aws.crt.internal.signer.DefaultAwsCrtV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;

public class CrtSubstitutions {
    static final String SOFTWARE_AMAZON_AWSSDK_CRT_PACKAGE = "software.amazon.awssdk.crt";
    static final String SOFTWARE_AMAZON_AWSSDK_HTTP_AUTH_AWS_CRT_PACKAGE = "software.amazon.awssdk.http.auth.aws.crt";

    @TargetClass(value=AwsV4aHttpSigner.class, onlyWith={IsHttpAuthAwsCrtAbsent.class})
    public static interface Target_AwsV4aHttpSigner {
        @Substitute
        public static AwsV4aHttpSigner create() {
            throw new RuntimeException("You must add a dependency on the 'software.amazon.awssdk:http-auth-aws-crt' module to enable the CRT-V4a signing feature");
        }
    }

    @TargetClass(value=DefaultAwsCrtV4aHttpSigner.class, onlyWith={IsHttpAuthAwsCrtAbsent.class})
    @Delete
    static final class Delete_DefaultAwsCrtV4aHttpSigner {
        Delete_DefaultAwsCrtV4aHttpSigner() {
        }
    }

    @TargetClass(value=Crc32Checksum.class, onlyWith={IsCrtAbsent.class})
    static final class Target_Crc32Checksum {
        @Alias
        private Checksum crc32 = SdkCrc32.create();

        @Substitute
        public Target_Crc32Checksum() {
        }

        @Substitute
        private Checksum cloneChecksum(Checksum checksum) {
            return (Checksum)((SdkCrc32)checksum).clone();
        }
    }

    @TargetClass(value=CrcChecksumProvider.class)
    @Substitute
    static final class Target_CrcChecksumProvider {
        @Alias
        private static final String CRT_MODULE = null;
        @Alias
        private static final String CRT_CRC64NVME_PATH = null;

        Target_CrcChecksumProvider() {
        }

        @Substitute
        public static SdkChecksum crc32cImplementation() {
            return Target_CrcChecksumProvider.createJavaCrc32C();
        }

        @Substitute
        static SdkChecksum createJavaCrc32C() {
            return new CrcCombineOnMarkChecksum((Checksum)new CRC32C(), SdkCrc32CChecksum::combine);
        }

        @Delete
        static SdkChecksum createCrtCrc32C() {
            return null;
        }

        @Delete
        static SdkChecksum createSdkBasedCrc32C() {
            return null;
        }

        @Substitute
        @TargetElement(onlyWith={IsCrtAbsent.class})
        static SdkChecksum crc64NvmeCrtImplementation() {
            throw new RuntimeException("Could not load " + CRT_CRC64NVME_PATH + ". Add dependency on '" + CRT_MODULE + "' module to enable CRC64NVME feature.");
        }

        @Substitute
        @TargetElement(name="crc64NvmeCrtImplementation", onlyWith={IsCrtPresent.class})
        static SdkChecksum crc64NvmeCrtImplementationCrtPresent() {
            return new CrcCloneOnMarkChecksum((Checksum)new CRC64NVME());
        }
    }

    static final class IsHttpAuthAwsCrtAbsent
    implements BooleanSupplier {
        IsHttpAuthAwsCrtAbsent() {
        }

        @Override
        public boolean getAsBoolean() {
            return !Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(CrtSubstitutions.SOFTWARE_AMAZON_AWSSDK_HTTP_AUTH_AWS_CRT_PACKAGE));
        }
    }

    static final class IsCrtPresent
    implements BooleanSupplier {
        private static final IsCrtAbsent IS_CRT_ABSENT = new IsCrtAbsent();

        IsCrtPresent() {
        }

        @Override
        public boolean getAsBoolean() {
            return !IS_CRT_ABSENT.getAsBoolean();
        }
    }

    static final class IsCrtAbsent
    implements BooleanSupplier {
        IsCrtAbsent() {
        }

        @Override
        public boolean getAsBoolean() {
            return !Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(CrtSubstitutions.SOFTWARE_AMAZON_AWSSDK_CRT_PACKAGE));
        }
    }
}

