/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.prompt;

import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiFunction;
import org.springaicommunity.mcp.ErrorUtils;
import org.springaicommunity.mcp.method.prompt.AbstractMcpPromptMethodCallback;
import reactor.core.publisher.Mono;

public final class AsyncStatelessMcpPromptMethodCallback
extends AbstractMcpPromptMethodCallback
implements BiFunction<McpTransportContext, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> {
    private AsyncStatelessMcpPromptMethodCallback(Builder builder) {
        super(builder.method, builder.bean, builder.prompt);
    }

    @Override
    protected void validateParamType(Class<?> paramType) {
        if (McpSyncServerExchange.class.isAssignableFrom(paramType) || McpAsyncServerExchange.class.isAssignableFrom(paramType)) {
            throw new IllegalArgumentException("Stateless Streamable-Http prompt method must not declare parameter of type: " + paramType.getName() + ". Use McpTransportContext instead. Method: " + this.method.getName() + " in " + this.method.getDeclaringClass().getName());
        }
    }

    @Override
    protected Object assignExchangeType(Class<?> paramType, Object exchange) {
        if (McpTransportContext.class.isAssignableFrom(paramType)) {
            if (exchange instanceof McpTransportContext) {
                McpTransportContext transportContext = (McpTransportContext)exchange;
                return transportContext;
            }
            if (exchange instanceof McpSyncServerExchange) {
                McpSyncServerExchange syncServerExchange = (McpSyncServerExchange)exchange;
                throw new IllegalArgumentException("Unsupported Sync exchange type: " + syncServerExchange.getClass().getName() + " for Sync method: " + this.method.getName() + " in " + this.method.getDeclaringClass().getName());
            }
            if (exchange instanceof McpAsyncServerExchange) {
                McpAsyncServerExchange asyncServerExchange = (McpAsyncServerExchange)exchange;
                return asyncServerExchange.transportContext();
            }
        }
        throw new IllegalArgumentException("Unsupported exchange type: " + (exchange != null ? exchange.getClass().getName() : "null") + " for method: " + this.method.getName() + " in " + this.method.getDeclaringClass().getName());
    }

    @Override
    public Mono<McpSchema.GetPromptResult> apply(McpTransportContext context, McpSchema.GetPromptRequest request) {
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Request must not be null"));
        }
        return Mono.defer(() -> {
            try {
                Object[] args = this.buildArgs(this.method, context, request);
                this.method.setAccessible(true);
                Object result = this.method.invoke(this.bean, args);
                if (result instanceof Mono) {
                    return ((Mono)result).map(r -> this.convertToGetPromptResult(r));
                }
                return Mono.just((Object)this.convertToGetPromptResult(result));
            }
            catch (Exception e) {
                McpError mcpError;
                if (e instanceof McpError && (mcpError = (McpError)e).getJsonRpcError() != null) {
                    return Mono.error((Throwable)mcpError);
                }
                return Mono.error((Throwable)McpError.builder((int)-32602).message("Error invoking prompt method: " + this.method.getName() + " in " + this.bean.getClass().getName() + ". /nCause: " + ErrorUtils.findCauseUsingPlainJava(e).getMessage()).data((Object)ErrorUtils.findCauseUsingPlainJava(e).getMessage()).build());
            }
        });
    }

    @Override
    protected boolean isSupportedExchangeOrContextType(Class<?> paramType) {
        return McpTransportContext.class.isAssignableFrom(paramType);
    }

    @Override
    protected void validateReturnType(Method method) {
        boolean validReturnType;
        Class<?> returnType = method.getReturnType();
        boolean bl = validReturnType = McpSchema.GetPromptResult.class.isAssignableFrom(returnType) || List.class.isAssignableFrom(returnType) || McpSchema.PromptMessage.class.isAssignableFrom(returnType) || String.class.isAssignableFrom(returnType) || Mono.class.isAssignableFrom(returnType);
        if (!validReturnType) {
            throw new IllegalArgumentException("Method must return either GetPromptResult, List<PromptMessage>, List<String>, PromptMessage, String, or Mono<T>: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpPromptMethodCallback.AbstractBuilder<Builder, AsyncStatelessMcpPromptMethodCallback> {
        @Override
        public AsyncStatelessMcpPromptMethodCallback build() {
            this.validate();
            return new AsyncStatelessMcpPromptMethodCallback(this);
        }
    }
}

