/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.Configuration;
import dm.jdbc.desc.DmProperties;
import dm.jdbc.desc.EPGroup;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.FileUtil;
import dm.jdbc.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DmSvcConf {
    public static DmSvcConf GLOBAL = null;
    public int dbAliveCheckFreq = 0;
    public int dbAliveCheckTimeout = 10000;
    public String markConf;
    public Locale locale = Locale.getDefault();
    public int logLevel = 0;
    public String logDir = DriverUtil.formatDir(System.getProperty("user.dir"));
    public int logFlushFreq = 30;
    public int logBufferSize = 32768;
    public boolean statEnable = false;
    public String statDir = DriverUtil.formatDir(System.getProperty("user.dir"));
    public int statFileType = Configuration.STAT_FILE_TYPE_CSV;
    public int statFlushFreq = 30;
    public int statSlowSqlCount = 100;
    public int statHighFreqSqlCount = 100;
    public int statSqlMaxCount = 100000;
    public int statSqlRemoveMode = Configuration.STAT_SQL_REMOVE_LATEST;
    public ConcurrentHashMap serverGroupMap = new ConcurrentHashMap();
    public DmProperties props = new DmProperties();
    public String filePath = "";
    private long lastModified;

    static {
        String string = null;
        if (System.getProperty("os.name").startsWith("Win")) {
            String string2 = System.getProperty("java.version");
            string = !string2.contains("1.4") ? System.getenv("SystemRoot") : "C:\\WINDOWS";
            string = String.valueOf(string) + "\\system32\\dm_svc.conf";
        } else {
            string = "/etc/dm_svc.conf";
        }
        GLOBAL = DmSvcConf.load(string);
        if (GLOBAL == null) {
            GLOBAL = new DmSvcConf(string);
        }
    }

    public DmSvcConf(String string) {
        this.filePath = string;
        this.lastModified = FileUtil.lastModified(string);
    }

    public void setAttributes(DmProperties dmProperties) {
        if (dmProperties == null || dmProperties.size() == 0) {
            return;
        }
        this.locale = Configuration.parseLanguage(dmProperties);
        this.dbAliveCheckFreq = dmProperties.getMilliSecond(Configuration.dbAliveCheckFreq);
        this.dbAliveCheckTimeout = dmProperties.getMilliSecond(Configuration.dbAliveCheckTimeout);
        this.markConf = dmProperties.getTrimString(Configuration.markConf);
        this.logLevel = Configuration.parseLogLevel(dmProperties);
        this.logDir = DriverUtil.formatDir(dmProperties.getTrimString(Configuration.logDir));
        this.logBufferSize = dmProperties.getInt(Configuration.logBufferSize);
        this.logFlushFreq = dmProperties.getSecond(Configuration.logFlushFreq);
        this.statEnable = dmProperties.getBoolean(Configuration.statEnable);
        this.statDir = DriverUtil.formatDir(dmProperties.getTrimString(Configuration.statDir));
        this.statFileType = Configuration.parseStatFileType(dmProperties);
        this.statFlushFreq = dmProperties.getSecond(Configuration.statFlushFreq);
        this.statHighFreqSqlCount = dmProperties.getInt(Configuration.statHighFreqSqlCount);
        this.statSlowSqlCount = dmProperties.getInt(Configuration.statSlowSqlCount);
        this.statSqlMaxCount = dmProperties.getInt(Configuration.statSqlMaxCount);
        this.statSqlRemoveMode = Configuration.parseStatSqlRemoveMode(dmProperties);
    }

    public int getLanguage() {
        return StringUtil.equals(this.locale.getLanguage(), "zh") ? 0 : 1;
    }

    public EPGroup getDBGroup(String string) {
        if (StringUtil.isNotEmpty(string) && this.serverGroupMap.containsKey(string.toLowerCase())) {
            return (EPGroup)this.serverGroupMap.get(string.toLowerCase());
        }
        return null;
    }

    public boolean compatibleOracle() {
        return Configuration.parseCompatibleMode(DmSvcConf.GLOBAL.props) == 1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DmSvcConf load(String string) {
        Object object;
        block25: {
            if (StringUtil.isEmpty(string)) {
                return null;
            }
            BufferedReader bufferedReader = null;
            try {
                object = new File(string);
                if (((File)object).isDirectory()) {
                    string = String.valueOf(((File)object).getAbsolutePath()) + File.separator + "dm_svc.conf";
                }
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (Throwable throwable) {}
            if (bufferedReader == null) {
                return null;
            }
            object = new DmSvcConf(string);
            DmProperties dmProperties = null;
            try {
                try {
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        Object object2;
                        void var4_8;
                        String string3;
                        void var4_6;
                        int n2 = -1;
                        n2 = string2.indexOf("#");
                        if (n2 != -1) {
                            String string4 = string2.substring(0, n2);
                        }
                        if ((n2 = var4_6.indexOf("//")) != -1) {
                            String string5 = var4_6.substring(0, n2);
                        }
                        if (StringUtil.isEmpty(string3 = StringUtil.trimToEmpty((String)var4_8))) continue;
                        if (string3.startsWith("[") && string3.endsWith("]")) {
                            object2 = StringUtil.trimToEmpty(string3.substring(1, string3.length() - 1)).toLowerCase();
                            if (StringUtil.isEmpty((String)object2) || !((DmSvcConf)object).serverGroupMap.containsKey(object2) || (dmProperties = ((EPGroup)((DmSvcConf)object).serverGroupMap.get((Object)object2)).props) != null) continue;
                            ((EPGroup)((DmSvcConf)object).serverGroupMap.get((Object)object2)).props = dmProperties = new DmProperties(((DmSvcConf)object).props);
                            continue;
                        }
                        try {
                            EPGroup ePGroup;
                            object2 = string3.split("=");
                            if (((String[])object2).length < 2) continue;
                            String string6 = StringUtil.trimToEmpty(object2[0]);
                            String string7 = StringUtil.trimToEmpty(object2[1]);
                            if (string7.startsWith("(") && string7.endsWith(")")) {
                                string7 = StringUtil.trimToEmpty(string7.substring(1, string7.length() - 1));
                            }
                            if (StringUtil.isEmpty(string6) || StringUtil.isEmpty(string7) || super.setServerGroupProperties(dmProperties == null ? ((DmSvcConf)object).props : dmProperties, string6, string7) || (ePGroup = Configuration.parseEpGroup(string6, string7)) == null) continue;
                            ((DmSvcConf)object).serverGroupMap.put(string6.toLowerCase(), ePGroup);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException iOException) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {}
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        for (Map.Entry entry : ((DmSvcConf)object).serverGroupMap.entrySet()) {
            if (((EPGroup)entry.getValue()).props == null) {
                ((EPGroup)entry.getValue()).props = new DmProperties(((DmSvcConf)object).props);
            }
            ((EPGroup)entry.getValue()).setAttributes(((EPGroup)entry.getValue()).props);
        }
        return object;
    }

    private boolean setServerGroupProperties(DmProperties dmProperties, String string, String string2) {
        Configuration configuration = Configuration.valueOf(string);
        if (configuration == null) {
            return false;
        }
        if (configuration == Configuration.addressRemap || configuration == Configuration.userRemap) {
            String string3 = dmProperties.getProperty(configuration.getName());
            string2 = StringUtil.isNotEmpty(string3) ? String.valueOf(string3) + "&(" + string2 + ")" : "(" + string2 + ")";
        }
        dmProperties.setProperty(configuration.getName(), string2);
        return true;
    }

    public synchronized void reload() {
        long l2 = FileUtil.lastModified(this.filePath);
        if (this.lastModified > 0L && this.lastModified >= l2) {
            return;
        }
        this.lastModified = l2;
        DmSvcConf dmSvcConf = DmSvcConf.load(this.filePath);
        if (dmSvcConf == null) {
            return;
        }
        this.props = dmSvcConf.props;
        this.setAttributes(this.props);
        for (Map.Entry entry : dmSvcConf.serverGroupMap.entrySet()) {
            if (!this.serverGroupMap.containsKey(entry.getKey())) {
                this.serverGroupMap.put((String)entry.getKey(), (EPGroup)entry.getValue());
                continue;
            }
            EPGroup ePGroup = (EPGroup)entry.getValue();
            EPGroup ePGroup2 = (EPGroup)this.serverGroupMap.get(entry.getKey());
            ePGroup2.epList = ePGroup.epList;
            ePGroup2.props = ePGroup.props;
            ePGroup2.setAttributes(ePGroup.props);
        }
    }

    public static void main(String[] stringArray) {
        DmSvcConf dmSvcConf = DmSvcConf.load("d:\\Users\\dameng\\Desktop\\dm_svc.conf");
        System.out.println(dmSvcConf);
    }
}

