/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.resolver;

import java.util.Arrays;
import org.apache.fory.collection.LongLongByteMap;
import org.apache.fory.collection.LongMap;
import org.apache.fory.collection.ObjectMap;
import org.apache.fory.memory.LittleEndian;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.meta.Encoders;
import org.apache.fory.meta.MetaString;
import org.apache.fory.resolver.MetaStringBytes;
import org.apache.fory.util.MurmurHash3;

public final class MetaStringResolver {
    private static final int initialCapacity = 8;
    private static final float foryMapLoadFactor = 0.25f;
    private static final int SMALL_STRING_THRESHOLD = 16;
    private final ObjectMap<MetaStringBytes, String> metaStringBytes2StringMap = new ObjectMap(8, 0.25f);
    private final LongMap<MetaStringBytes> hash2MetaStringBytesMap = new LongMap(8, 0.25f);
    private final LongLongByteMap<MetaStringBytes> longLongByteMap = new LongLongByteMap(8, 0.25f);
    private final ObjectMap<MetaString, MetaStringBytes> metaString2BytesMap = new ObjectMap(8, 0.25f);
    private MetaStringBytes[] dynamicWrittenString = new MetaStringBytes[32];
    private MetaStringBytes[] dynamicReadStringIds = new MetaStringBytes[32];
    private short dynamicWriteStringId = 0;
    private short dynamicReadStringId = 0;

    public MetaStringBytes getOrCreateMetaStringBytes(MetaString str) {
        MetaStringBytes metaStringBytes = (MetaStringBytes)this.metaString2BytesMap.get(str);
        if (metaStringBytes == null) {
            metaStringBytes = MetaStringBytes.of(str);
            this.metaString2BytesMap.put(str, metaStringBytes);
        }
        return metaStringBytes;
    }

    public void writeMetaStringBytesWithFlag(MemoryBuffer buffer, MetaStringBytes byteString) {
        short id = byteString.dynamicWriteStringId;
        if (id == -1) {
            short s = this.dynamicWriteStringId;
            this.dynamicWriteStringId = (short)(s + 1);
            byteString.dynamicWriteStringId = id = s;
            MetaStringBytes[] dynamicWrittenMetaString = this.dynamicWrittenString;
            if (dynamicWrittenMetaString.length <= id) {
                dynamicWrittenMetaString = this.growWrite(id);
            }
            dynamicWrittenMetaString[id] = byteString;
            int length = byteString.bytes.length;
            buffer.writeVarUint32Small7(length << 2 | 1);
            if (length > 16) {
                buffer.writeInt64(byteString.hashCode);
            } else {
                buffer.writeByte(byteString.encoding.getValue());
            }
            buffer.writeBytes(byteString.bytes);
        } else {
            buffer.writeVarUint32Small7(id + 1 << 2 | 3);
        }
    }

    public void writeMetaStringBytes(MemoryBuffer buffer, MetaStringBytes byteString) {
        short id = byteString.dynamicWriteStringId;
        if (id == -1) {
            short s = this.dynamicWriteStringId;
            this.dynamicWriteStringId = (short)(s + 1);
            byteString.dynamicWriteStringId = id = s;
            MetaStringBytes[] dynamicWrittenMetaString = this.dynamicWrittenString;
            if (dynamicWrittenMetaString.length <= id) {
                dynamicWrittenMetaString = this.growWrite(id);
            }
            dynamicWrittenMetaString[id] = byteString;
            int length = byteString.bytes.length;
            buffer.writeVarUint32Small7(length << 1);
            if (length > 16) {
                buffer.writeInt64(byteString.hashCode);
            } else {
                buffer.writeByte(byteString.encoding.getValue());
            }
            buffer.writeBytes(byteString.bytes);
        } else {
            buffer.writeVarUint32Small7(id + 1 << 1 | 1);
        }
    }

    private MetaStringBytes[] growWrite(int id) {
        MetaStringBytes[] tmp = new MetaStringBytes[id * 2];
        System.arraycopy(this.dynamicWrittenString, 0, tmp, 0, this.dynamicWrittenString.length);
        this.dynamicWrittenString = tmp;
        return tmp;
    }

    public String readMetaString(MemoryBuffer buffer) {
        MetaStringBytes byteString = this.readMetaStringBytes(buffer);
        String str = (String)this.metaStringBytes2StringMap.get(byteString);
        if (str == null) {
            str = byteString.decode(Encoders.GENERIC_DECODER);
            this.metaStringBytes2StringMap.put(byteString, str);
        }
        return str;
    }

    public MetaStringBytes readMetaStringBytesWithFlag(MemoryBuffer buffer, int header) {
        int len = header >>> 2;
        if ((header & 2) == 0) {
            MetaStringBytes byteString = len <= 16 ? this.readSmallMetaStringBytes(buffer, len) : this.readBigMetaStringBytes(buffer, len, buffer.readInt64());
            this.updateDynamicString(byteString);
            return byteString;
        }
        return this.dynamicReadStringIds[len - 1];
    }

    public MetaStringBytes readMetaStringBytesWithFlag(MemoryBuffer buffer, MetaStringBytes cache, int header) {
        int len = header >>> 2;
        if ((header & 2) == 0) {
            MetaStringBytes byteString = len <= 16 ? this.readSmallMetaStringBytes(buffer, cache, len) : this.readBigMetaStringBytes(buffer, cache, len);
            this.updateDynamicString(byteString);
            return byteString;
        }
        return this.dynamicReadStringIds[len - 1];
    }

    public MetaStringBytes readMetaStringBytes(MemoryBuffer buffer) {
        int header = buffer.readVarUint32Small7();
        int len = header >>> 1;
        if ((header & 1) == 0) {
            MetaStringBytes byteString = len > 16 ? this.readBigMetaStringBytes(buffer, len, buffer.readInt64()) : this.readSmallMetaStringBytes(buffer, len);
            this.updateDynamicString(byteString);
            return byteString;
        }
        return this.dynamicReadStringIds[len - 1];
    }

    MetaStringBytes readMetaStringBytes(MemoryBuffer buffer, MetaStringBytes cache) {
        int header = buffer.readVarUint32Small7();
        int len = header >>> 1;
        if ((header & 1) == 0) {
            MetaStringBytes byteString = len <= 16 ? this.readSmallMetaStringBytes(buffer, cache, len) : this.readBigMetaStringBytes(buffer, cache, len);
            this.updateDynamicString(byteString);
            return byteString;
        }
        return this.dynamicReadStringIds[len - 1];
    }

    private MetaStringBytes readBigMetaStringBytes(MemoryBuffer buffer, MetaStringBytes cache, int len) {
        long hashCode = buffer.readInt64();
        if (cache.hashCode == hashCode) {
            buffer.increaseReaderIndex(len);
            return cache;
        }
        return this.readBigMetaStringBytes(buffer, len, hashCode);
    }

    private MetaStringBytes readBigMetaStringBytes(MemoryBuffer buffer, int len, long hashCode) {
        MetaStringBytes byteString = this.hash2MetaStringBytesMap.get(hashCode);
        if (byteString == null) {
            byteString = new MetaStringBytes(buffer.readBytes(len), hashCode);
            this.hash2MetaStringBytesMap.put(hashCode, byteString);
        } else {
            buffer.increaseReaderIndex(len);
        }
        return byteString;
    }

    private MetaStringBytes readSmallMetaStringBytes(MemoryBuffer buffer, int len) {
        long v1;
        byte encoding = buffer.readByte();
        if (len == 0) {
            assert (encoding == MetaString.Encoding.UTF_8.getValue());
            return MetaStringBytes.EMPTY;
        }
        long v2 = 0L;
        if (len <= 8) {
            v1 = buffer.readBytesAsInt64(len);
        } else {
            v1 = buffer.readInt64();
            v2 = buffer.readBytesAsInt64(len - 8);
        }
        MetaStringBytes byteString = this.longLongByteMap.get(v1, v2, encoding);
        if (byteString == null) {
            byteString = this.createSmallMetaStringBytes(len, encoding, v1, v2);
        }
        return byteString;
    }

    private MetaStringBytes readSmallMetaStringBytes(MemoryBuffer buffer, MetaStringBytes cache, int len) {
        long v1;
        byte encoding = buffer.readByte();
        if (len == 0) {
            assert (encoding == MetaString.Encoding.UTF_8.getValue());
            return MetaStringBytes.EMPTY;
        }
        long v2 = 0L;
        if (len <= 8) {
            v1 = buffer.readBytesAsInt64(len);
        } else {
            v1 = buffer.readInt64();
            v2 = buffer.readBytesAsInt64(len - 8);
        }
        if (cache.first8Bytes == v1 && cache.second8Bytes == v2) {
            return cache;
        }
        MetaStringBytes byteString = this.longLongByteMap.get(v1, v2, encoding);
        if (byteString == null) {
            byteString = this.createSmallMetaStringBytes(len, encoding, v1, v2);
        }
        return byteString;
    }

    private MetaStringBytes createSmallMetaStringBytes(int len, byte encoding, long v1, long v2) {
        byte[] data = new byte[16];
        LittleEndian.putInt64(data, 0, v1);
        LittleEndian.putInt64(data, 8, v2);
        long hashCode = MurmurHash3.murmurhash3_x64_128(data, 0, len, 47)[0];
        hashCode = Math.abs(hashCode);
        hashCode = hashCode & 0xFFFFFFFFFFFFFF00L | (long)encoding;
        MetaStringBytes metaStringBytes = new MetaStringBytes(Arrays.copyOf(data, len), hashCode);
        this.longLongByteMap.put(v1, v2, encoding, metaStringBytes);
        return metaStringBytes;
    }

    private void updateDynamicString(MetaStringBytes byteString) {
        short s = this.dynamicReadStringId;
        this.dynamicReadStringId = (short)(s + 1);
        MetaStringBytes[] dynamicReadStringIds = this.dynamicReadStringIds;
        short currentDynamicReadId = s;
        if (dynamicReadStringIds.length <= currentDynamicReadId) {
            dynamicReadStringIds = this.growRead(currentDynamicReadId);
        }
        dynamicReadStringIds[currentDynamicReadId] = byteString;
    }

    private MetaStringBytes[] growRead(int id) {
        MetaStringBytes[] tmp = new MetaStringBytes[id * 2];
        System.arraycopy(this.dynamicReadStringIds, 0, tmp, 0, this.dynamicReadStringIds.length);
        this.dynamicReadStringIds = tmp;
        return tmp;
    }

    public void reset() {
        this.resetRead();
        this.resetWrite();
    }

    public void resetRead() {
        int dynamicReadId = this.dynamicReadStringId;
        if (dynamicReadId != 0) {
            for (int i = 0; i < dynamicReadId; ++i) {
                this.dynamicReadStringIds[i] = null;
            }
            this.dynamicReadStringId = 0;
        }
    }

    public void resetWrite() {
        int dynamicWriteStringId = this.dynamicWriteStringId;
        if (dynamicWriteStringId != 0) {
            for (int i = 0; i < dynamicWriteStringId; ++i) {
                this.dynamicWrittenString[i].dynamicWriteStringId = (short)-1;
                this.dynamicWrittenString[i] = null;
            }
            this.dynamicWriteStringId = 0;
        }
    }
}

