/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.util.Collection;
import java.util.Map;
import org.apache.fory.Fory;
import org.apache.fory.annotation.Internal;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.collection.CollectionSerializer;
import org.apache.fory.serializer.collection.MapSerializer;

@Internal
public class SerializationUtils {
    public static TypeResolver getTypeResolver(Fory fory) {
        return fory.isCrossLanguage() ? fory.getXtypeResolver() : fory.getClassResolver();
    }

    public static ClassInfo getClassInfo(Fory fory, Class<?> cls) {
        return SerializationUtils.getTypeResolver(fory).getClassInfo(cls);
    }

    public static void validateSerializer(Class<?> type, Class<? extends Serializer> serializerClass, Class<?> parentType, Class<?> requiredSerializerBase) {
        if (!parentType.isAssignableFrom(type)) {
            return;
        }
        boolean valid = requiredSerializerBase.isAssignableFrom(serializerClass);
        if (!valid) {
            throw new IllegalArgumentException("Serializer for type " + type.getName() + " must extend " + requiredSerializerBase.getSimpleName() + ", but got " + serializerClass.getName());
        }
    }

    public static void validate(Class<?> type, Class<? extends Serializer> serializerClass) {
        SerializationUtils.validateSerializer(type, serializerClass, Collection.class, CollectionSerializer.class);
        SerializationUtils.validateSerializer(type, serializerClass, Map.class, MapSerializer.class);
    }
}

