/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.type;

import org.apache.fory.Fory;
import org.apache.fory.type.GenericType;

public class Generics {
    private final Fory fory;
    private int genericTypesSize;
    private GenericType[] genericTypes = new GenericType[16];
    private int[] depths = new int[16];

    public Generics(Fory fory) {
        this.fory = fory;
    }

    public void pushGenericType(GenericType fieldType) {
        int size;
        GenericType[] genericTypes = this.genericTypes;
        if ((size = this.genericTypesSize++) == genericTypes.length) {
            genericTypes = this.allocateGenericTypes(genericTypes, size);
        }
        genericTypes[size] = fieldType;
        this.depths[size] = this.fory.getDepth();
    }

    private GenericType[] allocateGenericTypes(GenericType[] genericTypes, int size) {
        genericTypes = new GenericType[genericTypes.length << 1];
        System.arraycopy(this.genericTypes, 0, genericTypes, 0, size);
        this.genericTypes = genericTypes;
        int[] depthsNew = new int[this.depths.length << 1];
        System.arraycopy(this.depths, 0, depthsNew, 0, size);
        this.depths = depthsNew;
        return genericTypes;
    }

    public void popGenericType() {
        int size = this.genericTypesSize;
        if (size == 0) {
            return;
        }
        if (this.depths[--size] < this.fory.getDepth()) {
            return;
        }
        this.genericTypes[size] = null;
        this.genericTypesSize = size;
    }

    public GenericType nextGenericType() {
        int index = this.genericTypesSize;
        if (index > 0) {
            GenericType genericType = this.genericTypes[--index];
            if (this.depths[index] == this.fory.getDepth() - 1) {
                return genericType;
            }
        }
        return null;
    }
}

