/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.task;

import com.alipay.sofa.registry.client.api.Register;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.log.LoggerFactory;
import com.alipay.sofa.registry.client.provider.AbstractInternalRegister;
import com.alipay.sofa.registry.client.provider.RegisterCache;
import com.alipay.sofa.registry.client.remoting.Client;
import com.alipay.sofa.registry.client.task.AbstractWorkerThread;
import com.alipay.sofa.registry.client.task.TaskEvent;
import com.alipay.sofa.registry.client.task.TaskQueue;
import com.alipay.sofa.registry.core.model.RegisterResponse;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class WorkerThread
extends AbstractWorkerThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerThread.class);
    protected final TaskQueue requestQueue = new TaskQueue();
    private RegistryClientConfig config;
    private RegisterCache registerCache;
    private AtomicBoolean inited = new AtomicBoolean(false);

    public WorkerThread(Client client, RegistryClientConfig config, RegisterCache registerCache) {
        super(client);
        this.config = config;
        this.registerCache = registerCache;
        this.setName("RegistryWorkerThread");
        this.setDaemon(true);
    }

    @Override
    public void schedule(TaskEvent event) {
        if (this.inited.compareAndSet(false, true)) {
            this.start();
        }
        this.requestQueue.put(event);
        this.signal();
    }

    @Override
    public void schedule(List<TaskEvent> events) {
        if (this.inited.compareAndSet(false, true)) {
            this.start();
        }
        this.requestQueue.putAll(events);
    }

    @Override
    public void handle() {
        while (true) {
            try {
                while (true) {
                    this.client.ensureConnected();
                    if (this.requestQueue.isEmpty()) {
                        this.await(this.config.getRecheckInterval());
                        continue;
                    }
                    Iterator<TaskEvent> lt = this.requestQueue.iterator();
                    while (lt.hasNext()) {
                        this.client.ensureConnected();
                        TaskEvent ev = lt.next();
                        lt.remove();
                        int sendCount = ev.incSendCount();
                        if (sendCount != 0 && ev.delayTime() > 0L) continue;
                        this.handleTask(ev);
                    }
                    this.requestQueue.cleanCompletedTasks();
                }
            }
            catch (Throwable e) {
                LOGGER.error("[send] handle data error!", e);
                continue;
            }
            break;
        }
    }

    private void handleTask(TaskEvent event) {
        if (null == event) {
            return;
        }
        try {
            event.setTriggerTime(System.currentTimeMillis());
            Register register = event.getSource();
            if (!(register instanceof AbstractInternalRegister)) {
                LOGGER.warn("[register] register type unknown, {}", (Object)register);
                return;
            }
            AbstractInternalRegister abstractInternalRegister = (AbstractInternalRegister)register;
            AbstractInternalRegister.SyncTask syncTask = abstractInternalRegister.assemblySyncTask();
            String requestId = syncTask.getRequestId();
            if (syncTask.isDone()) {
                LOGGER.info("[register] register already sync succeeded, {}", (Object)register);
                return;
            }
            Object request = syncTask.getRequest();
            Object result = this.client.invokeSync(request);
            if (!(result instanceof RegisterResponse)) {
                LOGGER.warn("[register] result type is wrong, {}", result);
                return;
            }
            RegisterResponse response = (RegisterResponse)result;
            if (!response.isSuccess()) {
                LOGGER.info("[register] register to server failed, {}, {}", request, (Object)response);
                return;
            }
            boolean syncOK = abstractInternalRegister.syncOK(requestId, response.getVersion(), response.isRefused());
            if (!syncOK) {
                LOGGER.info("[register] requestId has expired, ignore this response, {}, {}, {}", new Object[]{requestId, request, response});
                return;
            }
            if (!register.isEnabled()) {
                this.registerCache.remove(register.getRegistId());
            }
            if (response.isRefused()) {
                LOGGER.info("[register] register refused by server, {}, {}, {}", new Object[]{requestId, request, response});
            } else {
                LOGGER.info("[register] register to server success, {}, {}, {}", new Object[]{requestId, request, response});
            }
        }
        catch (Exception e) {
            LOGGER.error("[send] handle request failed, {}", (Object)event, (Object)e);
        }
    }
}

