/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.sync;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.seata.common.exception.SeataRuntimeException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.core.compressor.CompressorFactory;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.core.serializer.SerializerType;
import org.apache.seata.server.cluster.raft.sync.RaftSyncMessageSerializer;
import org.apache.seata.server.cluster.raft.sync.msg.RaftSyncMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftSyncMessageSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftSyncMessageSerializer.class);
    private static final List<String> PERMITS = new ArrayList();

    public static byte[] encode(RaftSyncMessage raftSyncMessage) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                Serializer serializer = (Serializer)EnhancedServiceLoader.load(Serializer.class, (String)SerializerType.getByCode((int)raftSyncMessage.getCodec()).name());
                Optional.ofNullable(raftSyncMessage.getBody()).ifPresent(value -> raftSyncMessage.setBody((Object)CompressorFactory.getCompressor((byte)raftSyncMessage.getCompressor()).compress(serializer.serialize(value))));
                oos.writeObject(raftSyncMessage);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    public static byte[] encode(io.seata.server.cluster.raft.sync.msg.RaftSyncMessage raftSyncMessage) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                Serializer serializer = (Serializer)EnhancedServiceLoader.load(Serializer.class, (String)SerializerType.getByCode((int)raftSyncMessage.getCodec()).name());
                Optional.ofNullable(raftSyncMessage.getBody()).ifPresent(value -> raftSyncMessage.setBody((Object)CompressorFactory.getCompressor((byte)raftSyncMessage.getCompressor()).compress(serializer.serialize(value))));
                oos.writeObject(raftSyncMessage);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static RaftSyncMessage decode(byte[] raftSyncMsgByte) {
        try (ByteArrayInputStream bin = new ByteArrayInputStream(raftSyncMsgByte);){
            RaftSyncMessage raftSyncMessage;
            try (1 ois = new /* Unavailable Anonymous Inner Class!! */;){
                RaftSyncMessage raftSyncMessage2;
                Object object = ois.readObject();
                if (object instanceof io.seata.server.cluster.raft.sync.msg.RaftSyncMessage) {
                    io.seata.server.cluster.raft.sync.msg.RaftSyncMessage oldRaftSyncMessage = (io.seata.server.cluster.raft.sync.msg.RaftSyncMessage)object;
                    raftSyncMessage2 = new RaftSyncMessage();
                    raftSyncMessage2.setCodec(oldRaftSyncMessage.getCodec());
                    raftSyncMessage2.setCompressor(oldRaftSyncMessage.getCompressor());
                    raftSyncMessage2.setVersion(oldRaftSyncMessage.getVersion());
                    raftSyncMessage2.setBody(oldRaftSyncMessage.getBody());
                } else {
                    raftSyncMessage2 = (RaftSyncMessage)object;
                }
                Serializer serializer = (Serializer)EnhancedServiceLoader.load(Serializer.class, (String)SerializerType.getByCode((int)raftSyncMessage2.getCodec()).name());
                Optional.ofNullable(raftSyncMessage2.getBody()).ifPresent(value -> raftSyncMessage2.setBody(serializer.deserialize(CompressorFactory.getCompressor((byte)raftSyncMessage2.getCompressor()).decompress((byte[])raftSyncMessage2.getBody()))));
                raftSyncMessage = raftSyncMessage2;
            }
            return raftSyncMessage;
        }
        catch (Exception e) {
            LOGGER.error("Failed to read raft synchronization log: {}", (Object)e.getMessage(), (Object)e);
            if (e instanceof RuntimeException) {
                Throwable jsonCause;
                Throwable cause = e.getCause();
                if (cause instanceof JsonMappingException && (jsonCause = cause.getCause()) instanceof SeataRuntimeException) {
                    throw (SeataRuntimeException)jsonCause;
                }
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ List access$000() {
        return PERMITS;
    }

    static {
        PERMITS.add(RaftSyncMessage.class.getName());
        PERMITS.add(io.seata.server.cluster.raft.sync.msg.RaftSyncMessage.class.getName());
        PERMITS.add("[B");
    }
}

