/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.loadbalance;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.discovery.loadbalance.LoadBalance;

@LoadLevel(name="ConsistentHashLoadBalance")
public class ConsistentHashLoadBalance
implements LoadBalance {
    public static final String LOAD_BALANCE_CONSISTENT_HASH_VIRTUAL_NODES = "client.loadBalance.virtualNodes";
    private static final int VIRTUAL_NODES_NUM = ConfigurationFactory.getInstance().getInt("client.loadBalance.virtualNodes", 10);
    private volatile ConsistentHashSelectorWrapper selectorWrapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T select(List<T> invokers, String xid) {
        if (this.selectorWrapper == null) {
            ConsistentHashLoadBalance consistentHashLoadBalance = this;
            synchronized (consistentHashLoadBalance) {
                if (this.selectorWrapper == null) {
                    this.selectorWrapper = new ConsistentHashSelectorWrapper(new ConsistentHashSelector<T>(invokers, VIRTUAL_NODES_NUM), invokers);
                }
            }
        }
        return this.selectorWrapper.getSelector(invokers).select(xid);
    }

    private static final class ConsistentHashSelectorWrapper {
        private volatile ConsistentHashSelector selector;
        private volatile Set invokers;

        public ConsistentHashSelectorWrapper(ConsistentHashSelector selector, List invokers) {
            this.selector = selector;
            this.invokers = new HashSet(invokers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConsistentHashSelector getSelector(List invokers) {
            if (!this.equals(invokers)) {
                ConsistentHashSelectorWrapper consistentHashSelectorWrapper = this;
                synchronized (consistentHashSelectorWrapper) {
                    if (!this.equals(invokers)) {
                        this.selector = new ConsistentHashSelector(invokers, VIRTUAL_NODES_NUM);
                        this.invokers = new HashSet(invokers);
                    }
                }
            }
            return this.selector;
        }

        private boolean equals(List invokers) {
            if (invokers.size() != this.invokers.size()) {
                return false;
            }
            for (Object invoker : invokers) {
                if (this.invokers.contains(invoker)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class ConsistentHashSelector<T> {
        private final SortedMap<Long, T> virtualInvokers = new TreeMap<Long, T>();
        private final HashFunction hashFunction = new SHA256Hash();

        ConsistentHashSelector(List<T> invokers, int virtualNodes) {
            for (T invoker : invokers) {
                for (int i = 0; i < virtualNodes; ++i) {
                    this.virtualInvokers.put(this.hashFunction.hash(invoker.toString() + i), invoker);
                }
            }
        }

        public T select(String objectKey) {
            SortedMap<Long, T> tailMap = this.virtualInvokers.tailMap(this.hashFunction.hash(objectKey));
            Long nodeHashVal = tailMap.isEmpty() ? this.virtualInvokers.firstKey() : tailMap.firstKey();
            return (T)this.virtualInvokers.get(nodeHashVal);
        }
    }

    public static interface HashFunction {
        public long hash(String var1);
    }

    private static class SHA256Hash
    implements HashFunction {
        MessageDigest instance;

        public SHA256Hash() {
            try {
                this.instance = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public long hash(String key) {
            this.instance.reset();
            this.instance.update(key.getBytes());
            byte[] digest = this.instance.digest(key.getBytes(StandardCharsets.UTF_8));
            long hash = 0L;
            for (int i = 0; i < 8 && i < digest.length; ++i) {
                hash <<= 8;
                hash |= (long)(digest[i] & 0xFF);
            }
            return hash;
        }
    }
}

