/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAddTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAddUserStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAlterTableSetChangeLogs;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsCountStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsExstoreStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsRemoveUserStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSetLabelStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsUnloadStatement;
import com.alibaba.druid.sql.dialect.odps.visitor.OdpsASTVisitor;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.stat.TableStat;
import java.util.List;

public class OdpsSchemaStatVisitor
extends HiveSchemaStatVisitor
implements OdpsASTVisitor {
    public OdpsSchemaStatVisitor() {
        super(DbType.odps);
    }

    public OdpsSchemaStatVisitor(SchemaRepository repository) {
        super(repository);
    }

    @Override
    public boolean visit(OdpsSetLabelStatement x) {
        if (x.getTable() != null) {
            x.getTable().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OdpsAddUserStatement x) {
        return false;
    }

    @Override
    public boolean visit(OdpsRemoveUserStatement x) {
        return false;
    }

    @Override
    public boolean visit(OdpsAlterTableSetChangeLogs x) {
        return false;
    }

    @Override
    public boolean visit(OdpsAddTableStatement x) {
        SQLExprTableSource table = x.getTable();
        TableStat stat = this.getTableStatWithUnwrap(table.getExpr());
        if (stat != null) {
            stat.incrementAddCount();
        }
        this.resolvePartitions(table, x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(OdpsUnloadStatement x) {
        SQLExprTableSource table = (SQLExprTableSource)x.getFrom();
        TableStat stat = this.getTableStatWithUnwrap(table.getExpr());
        if (stat != null) {
            stat.incrementSelectCount();
        }
        this.resolvePartitions(table, x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(OdpsCountStatement x) {
        SQLExprTableSource table = x.getTable();
        TableStat stat = this.getTableStatWithUnwrap(table.getExpr());
        if (stat != null) {
            stat.incrementSelectCount();
        }
        this.resolvePartitions(table, x.getPartitions());
        return false;
    }

    @Override
    public boolean visit(OdpsExstoreStatement x) {
        SQLExprTableSource table = x.getTable();
        TableStat stat = this.getTableStatWithUnwrap(table.getExpr());
        if (stat != null) {
            stat.incrementSelectCount();
        }
        this.resolvePartitions(table, x.getPartitions());
        return false;
    }

    private void resolvePartitions(SQLExprTableSource table, List<SQLAssignItem> parttions) {
        for (SQLAssignItem partition : parttions) {
            SQLExpr target = partition.getTarget();
            if (!(target instanceof SQLIdentifierExpr)) continue;
            SQLIdentifierExpr columnName = (SQLIdentifierExpr)target;
            columnName.setResolvedTableSource(table);
            columnName.accept(this);
        }
    }

    @Override
    public boolean visit(OdpsSelectQueryBlock x) {
        return this.visit((SQLSelectQueryBlock)x);
    }
}

