/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.teradata.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLTop;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.teradata.ast.TDNormalize;
import com.alibaba.druid.sql.dialect.teradata.ast.TDSelectQueryBlock;
import com.alibaba.druid.sql.dialect.teradata.parser.TDExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;

public class TDSelectParser
extends SQLSelectParser {
    public TDSelectParser(Lexer lexer) {
        super(lexer);
    }

    public TDSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser, selectListCache);
        this.dbType = DbType.teradata;
    }

    protected TDExprParser createExprParser() {
        return new TDExprParser(this.lexer);
    }

    @Override
    protected SQLSelectQueryBlock createSelectQueryBlock() {
        return new TDSelectQueryBlock(this.dbType);
    }

    @Override
    protected void querySelectListBefore(SQLSelectQueryBlock x) {
        if (x instanceof TDSelectQueryBlock) {
            if (this.lexer.nextIf(Token.WITH)) {
                this.acceptIdentifier("DELETED");
                this.acceptIdentifier("ROWS");
                ((TDSelectQueryBlock)x).setWithDeletedRows(true);
            }
            if (this.lexer.nextIf(Token.AS)) {
                this.acceptIdentifier("JSON");
                ((TDSelectQueryBlock)x).setAsJson(true);
            }
        }
    }

    @Override
    protected void parseBeforeSelectList(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.DISTINCT) {
            queryBlock.setDistionOption(2);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.UNIQUE) {
            queryBlock.setDistionOption(3);
            this.lexer.nextToken();
        } else if (this.lexer.nextIfIdentifier("NORMALIZE") && queryBlock instanceof TDSelectQueryBlock) {
            TDNormalize tdNormalize = new TDNormalize();
            if (this.lexer.nextIf(Token.ON)) {
                if (this.lexer.nextIfIdentifier("MEETS")) {
                    tdNormalize.setMeets(true);
                    tdNormalize.setMeetsFirst(true);
                } else if (this.lexer.nextIfIdentifier("OVERLAPS")) {
                    tdNormalize.setOverlaps(true);
                    tdNormalize.setMeetsFirst(false);
                } else {
                    this.setErrorEndPos(this.lexer.pos());
                    this.printError(this.lexer.token());
                }
                if (this.lexer.nextIf(Token.OR)) {
                    if (this.lexer.nextIfIdentifier("MEETS")) {
                        tdNormalize.setMeets(true);
                    } else if (this.lexer.nextIfIdentifier("OVERLAPS")) {
                        tdNormalize.setOverlaps(true);
                    } else {
                        this.setErrorEndPos(this.lexer.pos());
                        this.printError(this.lexer.token());
                    }
                }
            }
            ((TDSelectQueryBlock)queryBlock).setNormalize(tdNormalize);
        }
    }

    @Override
    protected void parseTop(SQLSelectQueryBlock x) {
        if (x instanceof TDSelectQueryBlock) {
            SQLTop top = this.exprParser.parseTop();
            ((TDSelectQueryBlock)x).setTop(top);
        }
    }
}

