/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication.ott;

import java.time.Duration;
import org.springframework.security.authentication.ott.GenerateOneTimeTokenRequest;
import org.springframework.security.web.server.authentication.ott.ServerGenerateOneTimeTokenRequestResolver;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class DefaultServerGenerateOneTimeTokenRequestResolver
implements ServerGenerateOneTimeTokenRequestResolver {
    private static final String USERNAME = "username";
    private static final Duration DEFAULT_EXPIRES_IN = Duration.ofMinutes(5L);
    private Duration expiresIn = DEFAULT_EXPIRES_IN;

    @Override
    public Mono<GenerateOneTimeTokenRequest> resolve(ServerWebExchange exchange) {
        return exchange.getFormData().mapNotNull(data -> (String)data.getFirst((Object)USERNAME)).switchIfEmpty(Mono.empty()).map(username -> new GenerateOneTimeTokenRequest(username, this.expiresIn));
    }

    public void setExpiresIn(Duration expiresIn) {
        Assert.notNull((Object)expiresIn, (String)"expiresIn cannot be null");
        this.expiresIn = expiresIn;
    }
}

