/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AggregateConfiguration;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

public class ReadProcessedDetails
extends HistoryReadDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=650");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=652");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=651");
    private final DateTime startTime;
    private final DateTime endTime;
    private final Double processingInterval;
    private final NodeId[] aggregateType;
    private final AggregateConfiguration aggregateConfiguration;

    public ReadProcessedDetails(DateTime startTime, DateTime endTime, Double processingInterval, NodeId[] aggregateType, AggregateConfiguration aggregateConfiguration) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.processingInterval = processingInterval;
        this.aggregateType = aggregateType;
        this.aggregateConfiguration = aggregateConfiguration;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public Double getProcessingInterval() {
        return this.processingInterval;
    }

    public NodeId[] getAggregateType() {
        return this.aggregateType;
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return this.aggregateConfiguration;
    }

    protected ReadProcessedDetails(ReadProcessedDetailsBuilder<?, ?> b) {
        super((HistoryReadDetails.HistoryReadDetailsBuilder<?, ?>)b);
        this.startTime = ((ReadProcessedDetailsBuilder)b).startTime;
        this.endTime = ((ReadProcessedDetailsBuilder)b).endTime;
        this.processingInterval = ((ReadProcessedDetailsBuilder)b).processingInterval;
        this.aggregateType = ((ReadProcessedDetailsBuilder)b).aggregateType;
        this.aggregateConfiguration = ((ReadProcessedDetailsBuilder)b).aggregateConfiguration;
    }

    public static ReadProcessedDetailsBuilder<?, ?> builder() {
        return new ReadProcessedDetailsBuilderImpl();
    }

    public ReadProcessedDetailsBuilder<?, ?> toBuilder() {
        return new ReadProcessedDetailsBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadProcessedDetails)) {
            return false;
        }
        ReadProcessedDetails other = (ReadProcessedDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$processingInterval = this.getProcessingInterval();
        Double other$processingInterval = other.getProcessingInterval();
        if (this$processingInterval == null ? other$processingInterval != null : !((Object)this$processingInterval).equals(other$processingInterval)) {
            return false;
        }
        DateTime this$startTime = this.getStartTime();
        DateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        DateTime this$endTime = this.getEndTime();
        DateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAggregateType(), other.getAggregateType())) {
            return false;
        }
        AggregateConfiguration this$aggregateConfiguration = this.getAggregateConfiguration();
        AggregateConfiguration other$aggregateConfiguration = other.getAggregateConfiguration();
        return !(this$aggregateConfiguration == null ? other$aggregateConfiguration != null : !((Object)this$aggregateConfiguration).equals(other$aggregateConfiguration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReadProcessedDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $processingInterval = this.getProcessingInterval();
        result = result * 59 + ($processingInterval == null ? 43 : ((Object)$processingInterval).hashCode());
        DateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        DateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAggregateType());
        AggregateConfiguration $aggregateConfiguration = this.getAggregateConfiguration();
        result = result * 59 + ($aggregateConfiguration == null ? 43 : ((Object)$aggregateConfiguration).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReadProcessedDetails(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", processingInterval=" + this.getProcessingInterval() + ", aggregateType=" + Arrays.deepToString(this.getAggregateType()) + ", aggregateConfiguration=" + this.getAggregateConfiguration() + ")";
    }

    private static final class ReadProcessedDetailsBuilderImpl
    extends ReadProcessedDetailsBuilder<ReadProcessedDetails, ReadProcessedDetailsBuilderImpl> {
        private ReadProcessedDetailsBuilderImpl() {
        }

        @Override
        protected ReadProcessedDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public ReadProcessedDetails build() {
            return new ReadProcessedDetails(this);
        }
    }

    public static abstract class ReadProcessedDetailsBuilder<C extends ReadProcessedDetails, B extends ReadProcessedDetailsBuilder<C, B>>
    extends HistoryReadDetails.HistoryReadDetailsBuilder<C, B> {
        private DateTime startTime;
        private DateTime endTime;
        private Double processingInterval;
        private NodeId[] aggregateType;
        private AggregateConfiguration aggregateConfiguration;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReadProcessedDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ReadProcessedDetails instance, ReadProcessedDetailsBuilder<?, ?> b) {
            b.startTime(instance.startTime);
            b.endTime(instance.endTime);
            b.processingInterval(instance.processingInterval);
            b.aggregateType(instance.aggregateType);
            b.aggregateConfiguration(instance.aggregateConfiguration);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B startTime(DateTime startTime) {
            this.startTime = startTime;
            return (B)this.self();
        }

        public B endTime(DateTime endTime) {
            this.endTime = endTime;
            return (B)this.self();
        }

        public B processingInterval(Double processingInterval) {
            this.processingInterval = processingInterval;
            return (B)this.self();
        }

        public B aggregateType(NodeId[] aggregateType) {
            this.aggregateType = aggregateType;
            return (B)this.self();
        }

        public B aggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
            this.aggregateConfiguration = aggregateConfiguration;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ReadProcessedDetails.ReadProcessedDetailsBuilder(super=" + super.toString() + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", processingInterval=" + this.processingInterval + ", aggregateType=" + Arrays.deepToString(this.aggregateType) + ", aggregateConfiguration=" + this.aggregateConfiguration + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ReadProcessedDetails> {
        @Override
        public Class<ReadProcessedDetails> getType() {
            return ReadProcessedDetails.class;
        }

        @Override
        public ReadProcessedDetails decode(SerializationContext context, UaDecoder decoder) {
            DateTime startTime = decoder.readDateTime("StartTime");
            DateTime endTime = decoder.readDateTime("EndTime");
            Double processingInterval = decoder.readDouble("ProcessingInterval");
            NodeId[] aggregateType = decoder.readNodeIdArray("AggregateType");
            AggregateConfiguration aggregateConfiguration = (AggregateConfiguration)decoder.readStruct("AggregateConfiguration", AggregateConfiguration.TYPE_ID);
            return new ReadProcessedDetails(startTime, endTime, processingInterval, aggregateType, aggregateConfiguration);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ReadProcessedDetails value) {
            encoder.writeDateTime("StartTime", value.getStartTime());
            encoder.writeDateTime("EndTime", value.getEndTime());
            encoder.writeDouble("ProcessingInterval", value.getProcessingInterval());
            encoder.writeNodeIdArray("AggregateType", value.getAggregateType());
            encoder.writeStruct("AggregateConfiguration", (Object)value.getAggregateConfiguration(), AggregateConfiguration.TYPE_ID);
        }
    }
}

