/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractSortOperator;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.iotdb.db.utils.sort.DiskSpiller;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public abstract class SortOperator
extends AbstractSortOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SortOperator.class);

    SortOperator(OperatorContext operatorContext, Operator inputOperator, List<TSDataType> dataTypes, DiskSpiller diskSpiller, Comparator<SortKey> comparator) {
        super(operatorContext, inputOperator, dataTypes, diskSpiller, comparator);
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.inputOperator.hasNextWithTimer()) {
            this.buildResult();
            TsBlock res = this.buildFinalResult(this.tsBlockBuilder);
            this.tsBlockBuilder.reset();
            return res;
        }
        long startTime = System.nanoTime();
        try {
            TsBlock tsBlock = this.inputOperator.nextWithTimer();
            if (tsBlock == null) {
                TsBlock tsBlock2 = null;
                return tsBlock2;
            }
            this.dataSize += tsBlock.getSizeInBytes();
            this.cacheTsBlock(tsBlock);
        }
        catch (IoTDBException e) {
            this.clear();
            throw e;
        }
        finally {
            this.prepareUntilReadyCost += System.nanoTime() - startTime;
        }
        return null;
    }

    protected abstract TsBlock buildFinalResult(TsBlockBuilder var1);

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.inputOperator) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.noMoreData) + this.tsBlockBuilder.getRetainedSizeInBytes();
    }
}

