/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.payload;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionIncompatibleHandlerException;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.session.subscription.payload.SubscriptionMessageHandler;
import org.apache.iotdb.session.subscription.payload.SubscriptionMessageType;
import org.apache.iotdb.session.subscription.payload.SubscriptionSessionDataSetsHandler;
import org.apache.iotdb.session.subscription.payload.SubscriptionTsFileHandler;
import org.apache.thrift.annotation.Nullable;
import org.apache.tsfile.write.record.Tablet;

public class SubscriptionMessage
implements Comparable<SubscriptionMessage> {
    private final SubscriptionCommitContext commitContext;
    private final short messageType;
    private final SubscriptionMessageHandler handler;

    public SubscriptionMessage(SubscriptionCommitContext commitContext, Map<String, List<Tablet>> tablets) {
        this.commitContext = commitContext;
        this.messageType = SubscriptionMessageType.SESSION_DATA_SETS_HANDLER.getType();
        this.handler = new SubscriptionSessionDataSetsHandler(tablets);
    }

    public SubscriptionMessage(SubscriptionCommitContext commitContext, String absolutePath, @Nullable String databaseName) {
        this.commitContext = commitContext;
        this.messageType = SubscriptionMessageType.TS_FILE_HANDLER.getType();
        this.handler = new SubscriptionTsFileHandler(absolutePath, databaseName);
    }

    public SubscriptionCommitContext getCommitContext() {
        return this.commitContext;
    }

    public short getMessageType() {
        return this.messageType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionMessage that = (SubscriptionMessage)obj;
        return Objects.equals(this.commitContext, that.commitContext) && Objects.equals(this.messageType, that.messageType) && Objects.equals(this.handler, that.handler);
    }

    public int hashCode() {
        return Objects.hash(this.commitContext, this.messageType, this.handler);
    }

    @Override
    public int compareTo(SubscriptionMessage that) {
        return this.commitContext.compareTo(that.commitContext);
    }

    public String toString() {
        return "SubscriptionMessage{commitContext=" + this.commitContext + ", messageType=" + SubscriptionMessageType.valueOf(this.messageType).toString() + "}";
    }

    public SubscriptionSessionDataSetsHandler getSessionDataSetsHandler() {
        if (this.handler instanceof SubscriptionSessionDataSetsHandler) {
            return (SubscriptionSessionDataSetsHandler)this.handler;
        }
        throw new SubscriptionIncompatibleHandlerException(String.format("%s do not support getSessionDataSetsHandler().", this.handler.getClass().getSimpleName()));
    }

    public SubscriptionTsFileHandler getTsFileHandler() {
        if (this.handler instanceof SubscriptionTsFileHandler) {
            return (SubscriptionTsFileHandler)this.handler;
        }
        throw new SubscriptionIncompatibleHandlerException(String.format("%s do not support getTsFileHandler().", this.handler.getClass().getSimpleName()));
    }
}

