/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.TrimColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Binary;

public class RTrimColumnTransformer
extends UnaryColumnTransformer {
    private final byte[] character;

    public RTrimColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, String characterStr) {
        super(returnType, childColumnTransformer);
        this.character = characterStr.getBytes();
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                byte[] currentValue = column.getBinary(i).getValues();
                columnBuilder.writeBinary(new Binary(RTrimColumnTransformer.rtrim(currentValue, this.character)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                byte[] currentValue = column.getBinary(i).getValues();
                columnBuilder.writeBinary(new Binary(RTrimColumnTransformer.rtrim(currentValue, this.character)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    public static byte[] rtrim(byte[] source, byte[] character) {
        int end;
        if (source.length == 0 || character.length == 0) {
            return source;
        }
        for (end = source.length - 1; end >= 0 && TrimColumnTransformer.isContain(character, source[end]); --end) {
        }
        if (end < 0) {
            return new byte[0];
        }
        byte[] result = new byte[end + 1];
        System.arraycopy(source, 0, result, 0, end + 1);
        return result;
    }
}

