/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.type.ExitType;
import org.apache.iotdb.cli.utils.CliContext;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.cli.utils.JlineUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.tool.common.OptionsUtil;
import org.apache.iotdb.tool.data.AbstractDataTool;
import org.apache.iotdb.tool.data.AbstractExportData;
import org.apache.iotdb.tool.data.ExportDataTable;
import org.apache.iotdb.tool.data.ExportDataTree;
import org.apache.thrift.TException;
import org.jline.reader.LineReader;

public class ExportData
extends AbstractDataTool {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);

    public static void main(String[] args) {
        int ftIndex;
        OptionsUtil.setIsImport(false);
        Options helpOptions = OptionsUtil.createHelpOptions();
        Options tsFileOptions = OptionsUtil.createExportTsFileOptions();
        Options csvOptions = OptionsUtil.createExportCsvOptions();
        Options sqlOptions = OptionsUtil.createExportSqlOptions();
        HelpFormatter hf = new HelpFormatter();
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        if (args == null || args.length == 0) {
            ExportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./export_data.sh -help tsfile\n./export_data.sh -help sql\n./export_data.sh -help csv", "Export Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(helpOptions, args, true);
        }
        catch (ParseException e) {
            ExportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./export_data.sh -help tsfile\n./export_data.sh -help sql\n./export_data.sh -help csv", "Export Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
            System.exit(1);
        }
        List<String> argList = Arrays.asList(args);
        int helpIndex = argList.indexOf("-help");
        int sql_dialect = argList.indexOf("-sql_dialect");
        if (sql_dialect >= 0 && !"tree".equalsIgnoreCase(argList.get(sql_dialect + 1))) {
            String sqlDialectValue = argList.get(sql_dialect + 1);
            if ("table".equalsIgnoreCase(sqlDialectValue)) {
                sqlDialectTree = false;
                csvOptions = OptionsUtil.createTableExportCsvOptions();
                tsFileOptions = OptionsUtil.createTableExportTsFileOptions();
                sqlOptions = OptionsUtil.createTableExportSqlOptions();
            } else {
                ioTPrinter.println(String.format("sql_dialect %s is not support", sqlDialectValue));
                ExportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./import_data.sh -help tsfile\n./import_data.sh -help sql\n./import_data.sh -help csv", "Import Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
                System.exit(1);
            }
        }
        if ((ftIndex = argList.indexOf("-ft")) < 0) {
            ftIndex = argList.indexOf("-file_type");
        }
        if (helpIndex >= 0) {
            fileType = argList.get(helpIndex + 1);
            if (StringUtils.isNotBlank((CharSequence)fileType)) {
                if ("tsfile".equalsIgnoreCase(fileType)) {
                    ExportData.printHelpOptions(null, "Export Data", hf, tsFileOptions, null, null, false);
                } else if ("csv".equalsIgnoreCase(fileType)) {
                    ExportData.printHelpOptions(null, "Export Data", hf, null, csvOptions, null, false);
                } else if ("sql".equalsIgnoreCase(fileType)) {
                    ExportData.printHelpOptions(null, "Export Data", hf, null, null, sqlOptions, false);
                } else {
                    ioTPrinter.println(String.format("File type %s is not support", fileType));
                    ExportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./export_data.sh -help tsfile\n./export_data.sh -help sql\n./export_data.sh -help csv", "Export Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
                }
            } else {
                ExportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./export_data.sh -help tsfile\n./export_data.sh -help sql\n./export_data.sh -help csv", "Export Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
            }
            System.exit(1);
        } else if (ftIndex >= 0) {
            fileType = argList.get(ftIndex + 1);
            if (StringUtils.isNotBlank((CharSequence)fileType)) {
                if ("tsfile".equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(tsFileOptions, args, true);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ExportData.printHelpOptions(null, "Export Data", hf, tsFileOptions, null, null, false);
                        System.exit(1);
                    }
                } else if ("csv".equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(csvOptions, args, true);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ExportData.printHelpOptions(null, "Export Data", hf, null, csvOptions, null, false);
                        System.exit(1);
                    }
                } else if ("sql".equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(sqlOptions, args, true);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ExportData.printHelpOptions(null, "Export Data", hf, null, null, sqlOptions, false);
                        System.exit(1);
                    }
                } else {
                    ioTPrinter.println(String.format("File type %s is not support", fileType));
                    ExportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./export_data.sh -help tsfile\n./export_data.sh -help sql\n./export_data.sh -help csv", "Export Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
                    System.exit(1);
                }
            } else {
                ExportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./export_data.sh -help tsfile\n./export_data.sh -help sql\n./export_data.sh -help csv", "Export Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
                System.exit(1);
            }
        } else {
            ioTPrinter.println(String.format("Invalid args: Required values for option '%s' not provided", "file_type"));
            System.exit(1);
        }
        int exitCode = 0;
        try {
            ExportData.parseBasicParams(commandLine);
            ExportData.parseSpecialParams(commandLine);
            if (!ExportData.checkTimeFormat()) {
                System.exit(1);
            }
            AbstractExportData exportData = new ExportDataTree();
            exportData.init();
            if (!sqlDialectTree) {
                exportData = new ExportDataTable();
                exportData.init();
            }
            if (sqlDialectTree && queryCommand == null) {
                LineReader lineReader = JlineUtils.getLineReader(new CliContext(System.in, System.out, System.err, ExitType.EXCEPTION), username, host, port);
                String sql = lineReader.readLine("Export Data> please input query: ");
                ioTPrinter.println(sql);
                String[] values = sql.trim().split(";");
                for (int i = 0; i < values.length; ++i) {
                    exportData.exportBySql(values[i], i);
                }
            } else {
                exportData.exportBySql(queryCommand, 0);
            }
        }
        catch (IOException e) {
            ioTPrinter.println("Failed to operate on file, because " + e.getMessage());
            exitCode = 1;
        }
        catch (ArgsErrorException e) {
            ioTPrinter.println("Invalid args: " + e.getMessage());
            exitCode = 1;
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            ioTPrinter.println("Connect failed because " + e.getMessage());
            exitCode = 1;
        }
        catch (TException e) {
            ioTPrinter.println("Can not get the timestamp precision from server because " + e.getMessage());
            exitCode = 1;
        }
        System.exit(exitCode);
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        File file;
        targetDirectory = ExportData.checkRequiredArg("t", "target", commandLine, null);
        targetFile = commandLine.getOptionValue("pfn");
        needDataTypePrinted = Boolean.valueOf(commandLine.getOptionValue("dt"));
        queryCommand = commandLine.getOptionValue("q");
        exportType = commandLine.getOptionValue("ft");
        String timeoutString = commandLine.getOptionValue("timeout");
        if (timeoutString != null) {
            timeout = Long.parseLong(timeoutString);
        }
        if (needDataTypePrinted == null) {
            needDataTypePrinted = true;
        }
        if (targetFile == null) {
            targetFile = "dump";
        }
        if ((timeFormat = commandLine.getOptionValue("tf")) == null) {
            timeFormat = "default";
        }
        timeZoneID = commandLine.getOptionValue("tz");
        if (!targetDirectory.endsWith("/") && !targetDirectory.endsWith("\\")) {
            targetDirectory = targetDirectory + File.separator;
        }
        if (!(file = new File(targetDirectory)).isDirectory() && !file.mkdirs()) {
            ioTPrinter.println(String.format("Failed to create directories %s", targetDirectory));
            System.exit(1);
        }
        if (commandLine.getOptionValue("lpf") != null) {
            linesPerFile = Integer.parseInt(commandLine.getOptionValue("lpf"));
        }
        if (commandLine.getOptionValue("aligned") != null) {
            aligned = Boolean.valueOf(commandLine.getOptionValue("aligned"));
        }
        if (commandLine.getOptionValue("db") != null && ObjectUtils.isNotEmpty((Object)(database = commandLine.getOptionValue("db").toLowerCase())) && "information_schema".equalsIgnoreCase(database)) {
            ioTPrinter.println(String.format("Does not support exporting system databases %s", database));
            System.exit(1);
        }
        if (commandLine.getOptionValue("table") != null) {
            table = commandLine.getOptionValue("table").toLowerCase();
        }
        if (commandLine.getOptionValue("start_time") != null) {
            startTime = commandLine.getOptionValue("start_time");
        }
        if (commandLine.getOptionValue("end_time") != null) {
            endTime = commandLine.getOptionValue("end_time");
        }
    }
}

