/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem.spliterator;

import java.util.Spliterator;
import java.util.function.Consumer;

public class SparseArraySubSpliterator<E>
implements Spliterator<E> {
    private final E[] entries;
    private final int fromIndex;
    private final Runnable checkForConcurrentModification;
    private int pos;

    public SparseArraySubSpliterator(E[] entries, int fromIndex, int toIndex, Runnable checkForConcurrentModification) {
        this.entries = entries;
        this.fromIndex = fromIndex;
        this.pos = toIndex;
        this.checkForConcurrentModification = checkForConcurrentModification;
    }

    public SparseArraySubSpliterator(E[] entries, Runnable checkForConcurrentModification) {
        this(entries, 0, entries.length, checkForConcurrentModification);
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        this.checkForConcurrentModification.run();
        while (this.fromIndex <= --this.pos) {
            if (null == this.entries[this.pos]) continue;
            action.accept(this.entries[this.pos]);
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        --this.pos;
        while (this.fromIndex <= this.pos) {
            if (null != this.entries[this.pos]) {
                action.accept(this.entries[this.pos]);
            }
            --this.pos;
        }
        this.checkForConcurrentModification.run();
    }

    @Override
    public Spliterator<E> trySplit() {
        int entriesCount = this.pos - this.fromIndex;
        if (entriesCount < 2) {
            return null;
        }
        int toIndexOfSubIterator = this.pos;
        this.pos = this.fromIndex + (entriesCount >>> 1);
        return new SparseArraySubSpliterator<E>(this.entries, this.pos, toIndexOfSubIterator, this.checkForConcurrentModification);
    }

    @Override
    public long estimateSize() {
        return this.pos - this.fromIndex;
    }

    @Override
    public int characteristics() {
        return 1281;
    }
}

