/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.WKTLiteralFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.FmtUtils;

public class ConvertLatLon {
    public static final Literal toLiteral(double lat, double lon) {
        ConvertLatLon.checkBounds(lat, lon);
        return WKTLiteralFactory.createPoint(lat, lon, "http://www.opengis.net/def/crs/EPSG/0/4326");
    }

    public static final String toWKT(double lat, double lon) {
        Literal wktPoint = ConvertLatLon.toLiteral(lat, lon);
        return wktPoint.getLexicalForm();
    }

    public static final NodeValue toNodeValue(NodeValue latNodeValue, NodeValue lonNodeValue) {
        double lat = ConvertLatLon.extractDouble(latNodeValue);
        double lon = ConvertLatLon.extractDouble(lonNodeValue);
        Literal wktPoint = ConvertLatLon.toLiteral(lat, lon);
        return NodeValue.makeNode(wktPoint.asNode());
    }

    public static double extractDouble(NodeValue nodeValue) {
        if (nodeValue.isNumber()) {
            return nodeValue.getDouble();
        }
        if (nodeValue.isString()) {
            try {
                return Double.parseDouble(nodeValue.getString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new DatatypeFormatException("Not a number: " + FmtUtils.stringForNode(nodeValue.asNode()));
    }

    public static final Node toNode(Node latNode, Node lonNode) {
        NodeValue result = ConvertLatLon.toNodeValue(NodeValue.makeNode(latNode), NodeValue.makeNode(lonNode));
        return result.asNode();
    }

    public static final GeometryWrapper toGeometryWrapper(Node latNode, Node lonNode) {
        double lat = ConvertLatLon.extractDouble(NodeValue.makeNode(latNode));
        double lon = ConvertLatLon.extractDouble(NodeValue.makeNode(lonNode));
        ConvertLatLon.checkBounds(lat, lon);
        return GeometryWrapper.fromPoint(lat, lon, "http://www.opengis.net/def/crs/EPSG/0/4326");
    }

    public static final void checkBounds(double latitude, double longitude) throws DatatypeFormatException {
        if (latitude < -90.0 || latitude > 90.0) {
            throw new DatatypeFormatException("Lat/Lon out of bounds: " + latitude + ", " + longitude);
        }
        if (longitude < -180.0 || longitude > 180.0) {
            throw new DatatypeFormatException("Lat/Lon out of bounds: " + latitude + ", " + longitude);
        }
    }
}

