/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.property_functions.nearby;

import java.util.List;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.spatial.SearchEnvelope;
import org.apache.jena.geosparql.spatial.filter_functions.NearbyFF;
import org.apache.jena.geosparql.spatial.property_functions.GenericSpatialPropertyFunction;
import org.apache.jena.geosparql.spatial.property_functions.SpatialArguments;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.FmtUtils;

public class NearbyGeomPF
extends GenericSpatialPropertyFunction {
    private static final int GEOM_POS = 0;
    private static final int RADIUS_POS = 1;
    private static final int UNITS_POS = 2;
    private static final int LIMIT_POS = 3;
    protected double radius;
    protected String unitsURI;

    @Override
    protected SpatialArguments extractObjectArguments(Node predicate, PropFuncArg object, SRSInfo indexSRSInfo) {
        try {
            int limit;
            List<Node> objectArgs = object.getArgList();
            if (objectArgs.size() < 2) {
                throw new ExprEvalException(FmtUtils.stringForNode(predicate) + ": Minimum of 2 arguments.");
            }
            if (objectArgs.size() > 4) {
                throw new ExprEvalException(FmtUtils.stringForNode(predicate) + ": Maximum of 4 arguments.");
            }
            Node geomLit = object.getArg(0);
            NodeValue radiusNode = NodeValue.makeNode(objectArgs.get(1));
            if (!radiusNode.isDouble()) {
                throw new ExprEvalException("Not a xsd:double: " + FmtUtils.stringForNode(radiusNode.asNode()));
            }
            this.radius = radiusNode.getDouble();
            if (objectArgs.size() > 2) {
                Node unitsNode = objectArgs.get(2);
                if (!unitsNode.isURI()) {
                    throw new ExprEvalException("Not a URI: " + FmtUtils.stringForNode(unitsNode));
                }
                this.unitsURI = unitsNode.getURI();
            } else {
                this.unitsURI = "http://www.opengis.net/def/uom/OGC/1.0/kilometre";
            }
            if (objectArgs.size() > 3) {
                NodeValue limitNode = NodeValue.makeNode(objectArgs.get(3));
                if (!limitNode.isInteger()) {
                    throw new ExprEvalException("Not an integer: " + FmtUtils.stringForNode(limitNode.asNode()));
                }
                limit = limitNode.getInteger().intValue();
            } else {
                limit = -1;
            }
            GeometryWrapper geometryWrapper = GeometryWrapper.extract(geomLit);
            SearchEnvelope searchEnvelope = SearchEnvelope.build(geometryWrapper, indexSRSInfo, this.radius, this.unitsURI);
            return new SpatialArguments(limit, geometryWrapper, searchEnvelope);
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }

    @Override
    protected boolean requireSecondFilter() {
        return true;
    }

    @Override
    protected boolean checkSecondFilter(SpatialArguments spatialArguments, GeometryWrapper targetGeometryWrapper) {
        GeometryWrapper geometryWrapper = spatialArguments.getGeometryWrapper();
        return NearbyFF.relate(geometryWrapper, targetGeometryWrapper, this.radius, this.unitsURI);
    }
}

