/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.value;

import org.apache.jena.atlas.lib.BitsLong;

public class IntegerNode {
    public static final int LEN = 56;
    public static final int LBITS = 64;
    public static final long MAX = 0x7FFFFFFFFFFFFFL;
    public static final long MIN = -36028797018963968L;

    public static long pack(long v) {
        if (v >= -36028797018963968L && v <= 0x7FFFFFFFFFFFFFL) {
            v = BitsLong.clear(v, 56, 64);
            return v;
        }
        return -1L;
    }

    public static long unpack(long v) {
        long val = BitsLong.clear(v, 56, 64);
        if (BitsLong.isSet(val, 55)) {
            val = BitsLong.set(v, 56, 64);
        }
        return val;
    }

    public static long pack56(long v) {
        if (v >= -36028797018963968L && v <= 0x7FFFFFFFFFFFFFL) {
            v = BitsLong.clear(v, 56, 64);
            return v;
        }
        return -1L;
    }

    public static long unpack56(long v) {
        long val = BitsLong.clear(v, 56, 64);
        if (BitsLong.isSet(val, 55)) {
            val = BitsLong.set(v, 56, 64);
        }
        return val;
    }
}

