/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.search.DocIdStream;

final class RangeDocIdStream
extends DocIdStream {
    private int upTo;
    private final int max;

    RangeDocIdStream(int min2, int max2) {
        if (min2 >= max2) {
            throw new IllegalArgumentException("min = " + min2 + " >= max = " + max2);
        }
        this.upTo = min2;
        this.max = max2;
    }

    @Override
    public boolean mayHaveRemaining() {
        return this.upTo < this.max;
    }

    @Override
    public void forEach(int upTo, CheckedIntConsumer<IOException> consumer) throws IOException {
        if (upTo > this.upTo) {
            upTo = Math.min(upTo, this.max);
            for (int doc = this.upTo; doc < upTo; ++doc) {
                consumer.accept(doc);
            }
            this.upTo = upTo;
        }
    }

    @Override
    public int count(int upTo) throws IOException {
        if (upTo > this.upTo) {
            upTo = Math.min(upTo, this.max);
            int count = upTo - this.upTo;
            this.upTo = upTo;
            return count;
        }
        return 0;
    }
}

