/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.sys;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.jena.atlas.lib.Trie;

public abstract class AbstractRegistryWithPrefix<X, T> {
    private final Map<String, T> exactMap = new ConcurrentHashMap<String, T>();
    private final Trie<T> trie = new Trie();
    private final Function<X, String> generateKey;

    protected AbstractRegistryWithPrefix(Function<X, String> genKey) {
        this.generateKey = genKey;
    }

    public void add(X service, T value) {
        String key = this.generateKey.apply(service);
        this.exactMap.put(key, value);
    }

    public void addPrefix(X service, T value) {
        String key = this.generateKey.apply(service);
        if (!key.endsWith("/")) {
            throw new IllegalArgumentException("Prefix must end in \"/\"");
        }
        this.trie.add(key, value);
        this.exactMap.put(key, value);
    }

    public T find(X findRef) {
        String findKey = this.generateKey.apply(findRef);
        T item = this.exactMap.get(findKey);
        if (item == null) {
            item = this.trie.longestMatch(findKey);
        }
        return item;
    }

    private T findPrefix(X findRef) {
        String findKey = this.generateKey.apply(findRef);
        if (this.trie.isEmpty()) {
            return null;
        }
        T hc = this.trie.longestMatch(findKey);
        return hc;
    }

    public void remove(X findRef) {
        String key = this.generateKey.apply(findRef);
        this.exactMap.remove(key);
        this.trie.remove(key);
    }

    public void clear() {
        this.exactMap.clear();
        this.trie.clear();
    }
}

