/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.WriterSSE;
import org.apache.jena.sparql.util.PrintSerializable;

public class QueryOutputUtils {
    public static String toString(PrintSerializable item, PrefixMapping pmap) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        SerializationContext sCxt = new SerializationContext(pmap);
        item.output(buff, sCxt);
        return buff.toString();
    }

    public static String toString(PrintSerializable item) {
        return QueryOutputUtils.toString(item, null);
    }

    public static void printPlan(Query query2, QueryExecution qe) {
        QueryEngineFactory f = QueryEngineRegistry.findFactory(query2, qe.getDataset().asDatasetGraph(), ARQ.getContext());
        if (f == null) {
            Log.error(QueryOutputUtils.class, "printPlan: Unknown engine type: " + Lib.className(qe));
        }
        Plan plan = f.create(query2, qe.getDataset().asDatasetGraph(), BindingRoot.create(), ARQ.getContext());
        SerializationContext sCxt = new SerializationContext(query2);
        IndentedWriter out = IndentedWriter.stdout;
        plan.output(out, sCxt);
        out.flush();
    }

    public static void printQuery(Query query2) {
        IndentedWriter out = IndentedWriter.stdout;
        QueryOutputUtils.printQuery(out, query2);
    }

    public static void printQuery(IndentedWriter out, Query query2) {
        QueryOutputUtils.printQuery(out, query2, Syntax.defaultQuerySyntax);
    }

    public static void printQuery(IndentedWriter out, Query query2, Syntax syntax) {
        query2.serialize(out, syntax);
        out.flush();
    }

    public static void printOp(Query query2, boolean optimize) {
        IndentedWriter out = IndentedWriter.stdout;
        QueryOutputUtils.printOp(out, query2, optimize);
    }

    public static void printOp(IndentedWriter out, Query query2, boolean printOptimized) {
        Op op = Algebra.compile(query2);
        if (printOptimized) {
            op = Algebra.optimize(op);
        }
        WriterSSE.out(out, op, (Prologue)query2);
        out.flush();
    }

    public static void printQuad(Query query2, boolean printOptimized) {
        IndentedWriter out = IndentedWriter.stdout;
        QueryOutputUtils.printQuad(out, query2, printOptimized);
    }

    public static void printQuad(IndentedWriter out, Query query2, boolean printOptimized) {
        Op op = Algebra.compile(query2);
        if (printOptimized) {
            op = Algebra.optimize(op);
        }
        op = Algebra.toQuadForm(op);
        WriterSSE.out(out, op, (Prologue)query2);
        out.flush();
    }
}

