/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.iterators;

import java.io.IOException;
import org.apache.lucene.sandbox.facet.iterators.ComparableSupplier;
import org.apache.lucene.sandbox.facet.iterators.OrdinalIterator;
import org.apache.lucene.util.PriorityQueue;

public final class TopnOrdinalIterator<T extends Comparable<T>>
implements OrdinalIterator {
    private final ComparableSupplier<T> comparableSupplier;
    private final OrdinalIterator sourceOrds;
    private final int topN;
    private int[] result;
    private int currentIndex;

    public TopnOrdinalIterator(OrdinalIterator sourceOrds, ComparableSupplier<T> comparableSupplier, int topN) {
        if (topN <= 0) {
            throw new IllegalArgumentException("topN must be > 0 (got: " + topN + ")");
        }
        this.sourceOrds = sourceOrds;
        this.comparableSupplier = comparableSupplier;
        this.topN = topN;
    }

    private void getTopN() throws IOException {
        assert (this.result == null);
        TopComparableQueue<OrdComparablePair<T>> queue = new TopComparableQueue<OrdComparablePair<T>>(this.topN);
        OrdComparablePair<T> reuse = null;
        int ord = this.sourceOrds.nextOrd();
        while (ord != -1) {
            if (reuse == null) {
                reuse = new OrdComparablePair<T>(ord, this.comparableSupplier.createComparable(ord));
            } else {
                reuse.ordinal = ord;
                this.comparableSupplier.reuseComparable(ord, reuse.comparable);
            }
            reuse = queue.insertWithOverflow(reuse);
            ord = this.sourceOrds.nextOrd();
        }
        this.result = new int[queue.size()];
        for (int i = this.result.length - 1; i >= 0; --i) {
            this.result[i] = ((OrdComparablePair)queue.pop()).ordinal;
        }
        this.currentIndex = 0;
    }

    @Override
    public int nextOrd() throws IOException {
        if (this.result == null) {
            this.getTopN();
        }
        assert (this.result != null);
        if (this.currentIndex >= this.result.length) {
            return -1;
        }
        return this.result[this.currentIndex++];
    }

    private static class TopComparableQueue<T extends Comparable<T>>
    extends PriorityQueue<OrdComparablePair<T>> {
        public TopComparableQueue(int topN) {
            super(topN);
        }

        @Override
        protected boolean lessThan(OrdComparablePair<T> a, OrdComparablePair<T> b) {
            return a.lessThan(b);
        }
    }

    private static class OrdComparablePair<T extends Comparable<T>> {
        int ordinal;
        T comparable;

        private OrdComparablePair(int ordinal, T comparable) {
            this.ordinal = ordinal;
            this.comparable = comparable;
        }

        boolean lessThan(OrdComparablePair<T> other) {
            return this.comparable.compareTo(other.comparable) < 0;
        }
    }
}

