/*
 * Decompiled with CFR 0.152.
 */
package rdfpatch;

import arq.cmdline.ModContext;
import arq.cmdline.ModTime;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdMain;
import org.apache.jena.sys.JenaSystem;

public abstract class CmdRDFPatch
extends CmdMain {
    protected ModTime modTime = new ModTime();
    protected ModContext modContext = new ModContext();
    protected ArgDecl strictDecl = new ArgDecl(false, "strict");

    protected CmdRDFPatch(String[] argv) {
        super(argv);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " FILE...";
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
    }

    @Override
    protected void exec() {
        this.execStart();
        try {
            if (this.getPositional().isEmpty()) {
                this.execOne("Stdin", System.in);
            } else {
                this.getPositional().forEach(fn -> {
                    try (InputStream in = IO.openFile(fn);){
                        this.execOne((String)fn, in);
                    }
                    catch (IOException ex) {
                        IO.exception(ex);
                        return;
                    }
                });
            }
        }
        finally {
            this.execFinish();
        }
    }

    protected abstract void execStart();

    protected abstract void execOne(String var1, InputStream var2);

    protected abstract void execFinish();

    static {
        LogCtl.setLogging();
        JenaSystem.init();
    }
}

