/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ExtendedBeanPropertyMeta;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.html.HtmlMetaProvider;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;

public class HtmlBeanPropertyMeta
extends ExtendedBeanPropertyMeta {
    public static final HtmlBeanPropertyMeta DEFAULT = new HtmlBeanPropertyMeta();
    private final boolean noTables;
    private final boolean noTableHeaders;
    private final HtmlFormat format;
    private final HtmlRender render;
    private final String link;
    private final String anchorText;
    private final String style;

    public HtmlBeanPropertyMeta(BeanPropertyMeta bpm, AnnotationProvider ap, HtmlMetaProvider mp) {
        super(bpm);
        Builder b = new Builder();
        if (Utils.nn((Object)bpm.getInnerField())) {
            ap.find(Html.class, bpm.getInnerField(), new AnnotationTraversal[0]).forEach(x -> b.findHtmlInfo((Html)x.inner()));
        }
        if (Utils.nn((Object)bpm.getGetter())) {
            ap.find(Html.class, bpm.getGetter(), new AnnotationTraversal[0]).forEach(x -> b.findHtmlInfo((Html)x.inner()));
        }
        if (Utils.nn((Object)bpm.getSetter())) {
            ap.find(Html.class, bpm.getSetter(), new AnnotationTraversal[0]).forEach(x -> b.findHtmlInfo((Html)x.inner()));
        }
        this.format = b.format;
        this.noTables = b.noTables;
        this.noTableHeaders = b.noTableHeaders;
        this.render = b.render.orElse(null);
        this.link = b.link;
        this.anchorText = b.anchorText;
        this.style = b.style;
    }

    private HtmlBeanPropertyMeta() {
        super(null);
        this.format = HtmlFormat.HTML;
        this.noTables = false;
        this.noTableHeaders = false;
        this.render = null;
        this.link = null;
        this.anchorText = null;
        this.style = null;
    }

    public String getAnchorText() {
        return this.anchorText;
    }

    public String getLink() {
        return this.link;
    }

    public HtmlRender getRender() {
        return this.render;
    }

    public String getStyle() {
        return this.style;
    }

    public boolean isNoTableHeaders() {
        return this.noTableHeaders;
    }

    protected HtmlFormat getFormat() {
        return this.format;
    }

    protected boolean isHtml() {
        return this.format == HtmlFormat.HTML;
    }

    protected boolean isHtmlCdc() {
        return this.format == HtmlFormat.HTML_CDC;
    }

    protected boolean isHtmlSdc() {
        return this.format == HtmlFormat.HTML_SDC;
    }

    protected boolean isNoTables() {
        return this.noTables;
    }

    protected boolean isPlainText() {
        return this.format == HtmlFormat.PLAIN_TEXT;
    }

    protected boolean isXml() {
        return this.format == HtmlFormat.XML;
    }

    static class Builder {
        boolean noTables;
        boolean noTableHeaders;
        HtmlFormat format = HtmlFormat.HTML;
        BeanCreator<HtmlRender> render = BeanCreator.of(HtmlRender.class);
        String link;
        String anchorText;
        String style;

        Builder() {
        }

        void findHtmlInfo(Html html) {
            if (html == null) {
                return;
            }
            this.format = html.format();
            if (html.noTables()) {
                this.noTables = html.noTables();
            }
            if (html.noTableHeaders()) {
                this.noTableHeaders = html.noTableHeaders();
            }
            if (html.render() != HtmlRender.class) {
                this.render.type(html.render());
            }
            if (!html.link().isEmpty()) {
                this.link = html.link();
            }
            if (!html.anchorText().isEmpty()) {
                this.anchorText = html.anchorText();
            }
            if (!html.style().isEmpty()) {
                this.style = html.style();
            }
        }
    }
}

