/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import org.apache.juneau.commons.annotation.AnnotationObject;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.http.annotation.HasFormData;

public class HasFormDataAnnotation {
    public static final HasFormData DEFAULT = HasFormDataAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    extends AnnotationObject.Builder {
        private String[] description = new String[0];
        private String name = "";
        private String value = "";

        protected Builder() {
            super(HasFormData.class);
        }

        public HasFormData build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }
    }

    private static class Object
    extends AnnotationObject
    implements HasFormData {
        private final String[] description;
        private final String name;
        private final String value;

        Object(Builder b) {
            super((AnnotationObject.Builder)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.name = b.name;
            this.value = b.value;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }
}

