/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;

public class BeanRegistry {
    private final Map<String, ClassMeta<?>> map;
    private final Map<Class<?>, String> reverseMap;
    private final BeanContext bc;
    private final AnnotationProvider ap;
    private final boolean isEmpty;

    BeanRegistry(BeanContext bc, BeanRegistry parent, List<ClassInfo> classes) {
        AssertionUtils.assertArgNotNull("bc", bc);
        AssertionUtils.assertArgNotNull("classes", classes);
        this.bc = bc;
        this.ap = bc.getAnnotationProvider();
        this.map = new ConcurrentHashMap();
        this.reverseMap = new ConcurrentHashMap();
        bc.getBeanDictionary().forEach(this::addClass);
        if (Utils.nn(parent)) {
            parent.map.forEach(this::addToMap);
        }
        classes.forEach(this::addClass);
        this.isEmpty = this.map.isEmpty();
    }

    public ClassMeta<?> getClassMeta(String typeName) {
        if (this.isEmpty || typeName == null) {
            return null;
        }
        ClassMeta<?> cm = this.map.get(typeName);
        if (Utils.nn(cm)) {
            return cm;
        }
        if (typeName.charAt(typeName.length() - 1) == '^') {
            cm = this.getClassMeta(typeName.substring(0, typeName.length() - 1));
            if (Utils.nn(cm)) {
                cm = this.bc.getClassMeta(Array.newInstance(cm.inner(), 1).getClass());
                this.map.put(typeName, cm);
            }
            return cm;
        }
        return null;
    }

    public String getTypeName(ClassMeta<?> c) {
        return this.isEmpty ? null : this.reverseMap.get(c.inner());
    }

    public boolean hasName(String typeName) {
        return Utils.nn(this.getClassMeta(typeName));
    }

    protected FluentMap<String, Object> properties() {
        FluentMap<String, Object> m = CollectionUtils.filteredBeanPropertyMap();
        this.map.forEach((k, v) -> m.a((String)k, v.toString(true)));
        return m;
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    private void addClass(ClassInfo ci) {
        try {
            if (Utils.nn(ci) && Utils.nn(ci.inner())) {
                if (ci.isChildOf(Collection.class)) {
                    Collection cc = BeanCreator.of(Collection.class).type(ci).run();
                    cc.forEach(x -> {
                        if (!(x instanceof Class)) {
                            throw ThrowableUtils.bex("Collection class ''{0}'' passed to BeanRegistry does not contain Class objects.", ci.getName());
                        }
                        Class x2 = (Class)x;
                        this.addClass(ReflectionUtils.info(x2));
                    });
                } else if (ci.isChildOf(Map.class)) {
                    Map m = BeanCreator.of(Map.class).type(ci).run();
                    m.forEach((k, v) -> {
                        String typeName = Utils.s(k);
                        ClassMeta<Object> val = null;
                        if (v instanceof Type) {
                            Type v2 = (Type)v;
                            val = this.bc.getClassMeta(v2, new Type[0]);
                        } else if (Utils.isArray(v)) {
                            val = this.getTypedClassMeta(v);
                        } else {
                            throw ThrowableUtils.bex("Class ''{0}'' was passed to BeanRegistry but value of type ''{1}'' found in map is not a Type object.", ci.getName(), Utils.cn(v));
                        }
                        this.addToMap(typeName, val);
                    });
                } else {
                    String typeName = this.ap.find(Bean.class, ci, new AnnotationTraversal[0]).stream().map(x -> ((Bean)x.inner()).typeName()).filter(Utils::ne).findFirst().orElseThrow(() -> ThrowableUtils.bex("Class ''{0}'' was passed to BeanRegistry but it doesn't have a @Bean(typeName) annotation defined.", ci.getName()));
                    this.addToMap(typeName, this.bc.getClassMeta(ci.inner()));
                }
            }
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ThrowableUtils.bex(e);
        }
    }

    private void addToMap(String typeName, ClassMeta<?> cm) {
        this.map.put(typeName, cm);
        this.reverseMap.put(cm.inner(), typeName);
    }

    private ClassMeta<?> getTypedClassMeta(Object array) {
        int len = Array.getLength(array);
        if (len == 0) {
            throw ThrowableUtils.bex("Map entry had an empty array value.", new Object[0]);
        }
        Type type = (Type)Array.get(array, 0);
        Type[] args = new Type[len - 1];
        for (int i = 1; i < len; ++i) {
            args[i - 1] = (Type)Array.get(array, i);
        }
        return this.bc.getClassMeta(type, args);
    }
}

