/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.swagger.SwaggerElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.marshaller.Json5;

public class SecurityScheme
extends SwaggerElement {
    private static final String[] VALID_TYPES = new String[]{"basic", "apiKey", "oauth2"};
    private String type;
    private String description;
    private String name;
    private String in;
    private String flow;
    private String authorizationUrl;
    private String tokenUrl;
    private Map<String, String> scopes = CollectionUtils.map();

    public SecurityScheme() {
    }

    public SecurityScheme(SecurityScheme copyFrom) {
        super(copyFrom);
        this.authorizationUrl = copyFrom.authorizationUrl;
        this.description = copyFrom.description;
        this.flow = copyFrom.flow;
        this.in = copyFrom.in;
        this.name = copyFrom.name;
        if (Utils.nn(copyFrom.scopes)) {
            this.scopes.putAll(copyFrom.scopes);
        }
        this.tokenUrl = copyFrom.tokenUrl;
        this.type = copyFrom.type;
    }

    public SecurityScheme addScope(String key, String value) {
        AssertionUtils.assertArgNotNull("key", key);
        AssertionUtils.assertArgNotNull("value", value);
        this.scopes.put(key, value);
        return this;
    }

    public SecurityScheme copy() {
        return new SecurityScheme(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "authorizationUrl" -> ConverterUtils.toType(this.getAuthorizationUrl(), type);
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "flow" -> ConverterUtils.toType(this.getFlow(), type);
            case "in" -> ConverterUtils.toType(this.getIn(), type);
            case "name" -> ConverterUtils.toType(this.getName(), type);
            case "scopes" -> ConverterUtils.toType(this.getScopes(), type);
            case "tokenUrl" -> ConverterUtils.toType(this.getTokenUrl(), type);
            case "type" -> ConverterUtils.toType(this.getType(), type);
            default -> super.get(property, type);
        };
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFlow() {
        return this.flow;
    }

    public String getIn() {
        return this.in;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getScopes() {
        return Utils.nullIfEmpty(this.scopes);
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.authorizationUrl), "authorizationUrl").addIf(Utils.nn(this.description), "description").addIf(Utils.nn(this.flow), "flow").addIf(Utils.nn(this.in), "in").addIf(Utils.nn(this.name), "name").addIf(Utils.ne(this.scopes), "scopes").addIf(Utils.nn(this.tokenUrl), "tokenUrl").addIf(Utils.nn(this.type), "type").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public SecurityScheme set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "authorizationUrl" -> this.setAuthorizationUrl(Utils.s(value));
            case "description" -> this.setDescription(Utils.s(value));
            case "flow" -> this.setFlow(Utils.s(value));
            case "in" -> this.setIn(Utils.s(value));
            case "name" -> this.setName(Utils.s(value));
            case "scopes" -> this.setScopes(ConverterUtils.toMapBuilder(value, String.class, String.class).sparse().build());
            case "tokenUrl" -> this.setTokenUrl(Utils.s(value));
            case "type" -> this.setType(Utils.s(value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public SecurityScheme setAuthorizationUrl(String value) {
        this.authorizationUrl = value;
        return this;
    }

    public SecurityScheme setDescription(String value) {
        this.description = value;
        return this;
    }

    public SecurityScheme setFlow(String value) {
        this.flow = value;
        return this;
    }

    public SecurityScheme setIn(String value) {
        this.in = value;
        return this;
    }

    public SecurityScheme setName(String value) {
        this.name = value;
        return this;
    }

    public SecurityScheme setScopes(Map<String, String> value) {
        this.scopes.clear();
        if (Utils.nn(value)) {
            this.scopes.putAll(value);
        }
        return this;
    }

    public SecurityScheme setTokenUrl(String value) {
        this.tokenUrl = value;
        return this;
    }

    public SecurityScheme setType(String value) {
        if (this.isStrict() && !CollectionUtils.contains(value, VALID_TYPES)) {
            throw ThrowableUtils.rex("Invalid value passed in to setType(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_TYPES));
        }
        this.type = value;
        return this;
    }

    @Override
    public SecurityScheme strict() {
        super.strict();
        return this;
    }

    @Override
    public SecurityScheme strict(Object value) {
        super.strict(value);
        return this;
    }
}

