/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.commons.annotation.AnnotationObject;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;

public class AppliedAnnotationObject
extends AnnotationObject {
    private final String[] on;

    public AppliedAnnotationObject(Builder b) {
        super(b);
        this.on = CollectionUtils.copyOf(b.on);
    }

    public String[] on() {
        return this.on;
    }

    public static class Builder
    extends AnnotationObject.Builder {
        String[] on = new String[0];

        public Builder(Class<? extends Annotation> annotationType) {
            super(annotationType);
        }

        public Builder on(String ... values) {
            AssertionUtils.assertArgNoNulls("values", values);
            for (String v : values) {
                this.on = CollectionUtils.addAll(this.on, v);
            }
            return this;
        }
    }

    public static class BuilderTMFC
    extends BuilderTMF {
        public BuilderTMFC(Class<? extends Annotation> annotationType) {
            super(annotationType);
        }

        public BuilderTMFC on(Constructor<?> ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (Constructor<?> v : value) {
                this.on(ReflectionUtils.info(v).getFullName());
            }
            return this;
        }

        public BuilderTMFC on(ConstructorInfo ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (ConstructorInfo v : value) {
                this.on(v.getFullName());
            }
            return this;
        }
    }

    public static class BuilderTMF
    extends BuilderT {
        public BuilderTMF(Class<? extends Annotation> annotationType) {
            super(annotationType);
        }

        public BuilderTMF on(Field ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (Field v : value) {
                this.on(ReflectionUtils.info(v).getFullName());
            }
            return this;
        }

        public BuilderTMF on(FieldInfo ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (FieldInfo v : value) {
                this.on(v.getFullName());
            }
            return this;
        }

        public BuilderTMF on(Method ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (Method v : value) {
                this.on(ReflectionUtils.info(v).getFullName());
            }
            return this;
        }

        public BuilderTMF on(MethodInfo ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (MethodInfo v : value) {
                this.on(v.getFullName());
            }
            return this;
        }
    }

    public static class BuilderTM
    extends BuilderT {
        public BuilderTM(Class<? extends Annotation> annotationType) {
            super(annotationType);
        }

        public BuilderTM on(Method ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (Method v : value) {
                this.on(ReflectionUtils.info(v).getFullName());
            }
            return this;
        }

        public BuilderTM on(MethodInfo ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (MethodInfo v : value) {
                this.on(v.getFullName());
            }
            return this;
        }

        @Override
        public BuilderTM on(String ... value) {
            super.on(value);
            return this;
        }

        @Override
        public BuilderTM onClass(Class<?> ... value) {
            super.onClass(value);
            return this;
        }
    }

    public static class BuilderT
    extends Builder {
        Class<?>[] onClass = new Class[0];

        public BuilderT(Class<? extends Annotation> annotationType) {
            super(annotationType);
        }

        public BuilderT on(Class<?> ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (Class<?> v : value) {
                this.on = CollectionUtils.addAll(this.on, v.getName());
            }
            return this;
        }

        public BuilderT on(ClassInfo ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (ClassInfo v : value) {
                this.on = CollectionUtils.addAll(this.on, Utils.cn(v));
            }
            return this;
        }

        public BuilderT onClass(Class<?> ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (Class<?> v : value) {
                this.onClass = CollectionUtils.addAll(this.onClass, v);
            }
            return this;
        }

        public BuilderT onClass(ClassInfo ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (ClassInfo v : value) {
                this.onClass = CollectionUtils.addAll(this.onClass, v.inner());
            }
            return this;
        }
    }

    public static class BuilderMF
    extends Builder {
        public BuilderMF(Class<? extends Annotation> annotationType) {
            super(annotationType);
        }

        public BuilderMF on(Field ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (Field v : value) {
                this.on(ReflectionUtils.info(v).getFullName());
            }
            return this;
        }

        public BuilderMF on(FieldInfo ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (FieldInfo v : value) {
                this.on(v.getFullName());
            }
            return this;
        }

        public BuilderMF on(Method ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (Method v : value) {
                this.on(ReflectionUtils.info(v).getFullName());
            }
            return this;
        }

        public BuilderMF on(MethodInfo ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (MethodInfo v : value) {
                this.on(v.getFullName());
            }
            return this;
        }
    }

    public static class BuilderM
    extends Builder {
        public BuilderM(Class<? extends Annotation> annotationType) {
            super(annotationType);
        }

        public BuilderM on(Method ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (Method v : value) {
                this.on(ReflectionUtils.info(v).getFullName());
            }
            return this;
        }

        public BuilderM on(MethodInfo ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (MethodInfo v : value) {
                this.on(v.getFullName());
            }
            return this;
        }
    }

    public static class BuilderC
    extends Builder {
        public BuilderC(Class<? extends Annotation> annotationType) {
            super(annotationType);
        }

        public BuilderC on(Constructor<?> ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (Constructor<?> v : value) {
                this.on(ReflectionUtils.info(v).getFullName());
            }
            return this;
        }

        public BuilderC on(ConstructorInfo ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (ConstructorInfo v : value) {
                this.on(v.getFullName());
            }
            return this;
        }
    }
}

