/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.io;

import java.io.BufferedReader;
import java.io.StringReader;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class CharSequenceReader
extends BufferedReader {
    private final CharSequence cs;
    private String s;
    private StringBuffer sb;
    private StringBuilder sb2;
    private int length;
    private int next;

    public CharSequenceReader(CharSequence cs) {
        super(new StringReader(""), 1);
        if (cs == null) {
            cs = "";
        }
        this.cs = cs;
        if (cs instanceof String) {
            String s2;
            this.s = s2 = (String)cs;
        } else if (cs instanceof StringBuffer) {
            StringBuffer sb3;
            this.sb = sb3 = (StringBuffer)cs;
        } else if (cs instanceof StringBuilder) {
            StringBuilder sb4;
            this.sb2 = sb4 = (StringBuilder)cs;
        }
        this.length = cs.length();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() {
        if (this.next >= this.length) {
            return -1;
        }
        return this.cs.charAt(this.next++);
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        AssertionUtils.assertArgNotNull("cbuf", cbuf);
        if (this.next >= this.length) {
            return -1;
        }
        int n = Math.min(this.length - this.next, len);
        if (Utils.nn(this.s)) {
            this.s.getChars(this.next, this.next + n, cbuf, off);
        } else if (Utils.nn(this.sb)) {
            this.sb.getChars(this.next, this.next + n, cbuf, off);
        } else if (Utils.nn(this.sb2)) {
            this.sb2.getChars(this.next, this.next + n, cbuf, off);
        } else {
            for (int i = 0; i < n; ++i) {
                cbuf[off + i] = this.cs.charAt(this.next + i);
            }
        }
        this.next += n;
        return n;
    }

    @Override
    public long skip(long ns) {
        if (this.next >= this.length) {
            return 0L;
        }
        long n = Math.min((long)(this.length - this.next), ns);
        n = Math.max((long)(-this.next), n);
        this.next = (int)((long)this.next + n);
        return n;
    }

    public String toString() {
        return this.cs.toString();
    }
}

