/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;

@BeanIgnore
public class BasicHttpEntity
implements HttpEntity {
    public static final BasicHttpEntity EMPTY = new BasicHttpEntity().setUnmodifiable();
    private boolean cached;
    private boolean chunked;
    private boolean unmodifiable;
    private Object content;
    private Supplier<?> contentSupplier;
    private ContentType contentType;
    private ContentEncoding contentEncoding;
    private Charset charset;
    private long contentLength = -1L;
    private int maxLength = -1;

    public BasicHttpEntity() {
    }

    public BasicHttpEntity(BasicHttpEntity copyFrom) {
        this.cached = copyFrom.cached;
        this.chunked = copyFrom.chunked;
        this.content = copyFrom.content;
        this.contentSupplier = copyFrom.contentSupplier;
        this.contentType = copyFrom.contentType;
        this.contentEncoding = copyFrom.contentEncoding;
        this.contentLength = copyFrom.contentLength;
        this.charset = copyFrom.charset;
        this.maxLength = copyFrom.maxLength;
        this.unmodifiable = false;
    }

    public BasicHttpEntity(ContentType contentType, Object content) {
        this.contentType = contentType;
        this.content = content;
    }

    public byte[] asBytes() throws IOException {
        return IoUtils.readBytes((InputStream)this.getContent());
    }

    public FluentByteArrayAssertion<BasicHttpEntity> assertBytes() throws IOException {
        return new FluentByteArrayAssertion(this.asBytes(), (Object)this);
    }

    public FluentStringAssertion<BasicHttpEntity> assertString() throws IOException {
        return new FluentStringAssertion(this.asString(), (Object)this);
    }

    public String asString() throws IOException {
        return IoUtils.read((InputStream)this.getContent());
    }

    public void consumeContent() throws IOException {
    }

    public BasicHttpEntity copy() {
        return new BasicHttpEntity(this);
    }

    public Charset getCharset() {
        return this.charset == null ? IoUtils.UTF8 : this.charset;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return IoUtils.EMPTY_INPUT_STREAM;
    }

    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Header getContentType() {
        return this.contentType;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    public BasicHttpEntity setCached() throws IOException {
        this.assertModifiable();
        this.cached = true;
        return this;
    }

    public BasicHttpEntity setCharset(Charset value) {
        this.assertModifiable();
        this.charset = value;
        return this;
    }

    public BasicHttpEntity setChunked() {
        return this.setChunked(true);
    }

    public BasicHttpEntity setChunked(boolean value) {
        this.assertModifiable();
        this.chunked = value;
        return this;
    }

    public BasicHttpEntity setContent(Object value) {
        this.assertModifiable();
        this.content = value;
        return this;
    }

    public BasicHttpEntity setContent(Supplier<?> value) {
        this.assertModifiable();
        this.contentSupplier = value == null ? () -> null : value;
        return this;
    }

    public BasicHttpEntity setContentEncoding(ContentEncoding value) {
        this.assertModifiable();
        this.contentEncoding = value;
        return this;
    }

    public BasicHttpEntity setContentEncoding(String value) {
        return this.setContentEncoding(ContentEncoding.of(value));
    }

    public BasicHttpEntity setContentLength(long value) {
        this.assertModifiable();
        this.contentLength = value;
        return this;
    }

    public BasicHttpEntity setContentType(ContentType value) {
        this.assertModifiable();
        this.contentType = value;
        return this;
    }

    public BasicHttpEntity setContentType(String value) {
        return this.setContentType(ContentType.of(value));
    }

    public BasicHttpEntity setMaxLength(int value) {
        this.assertModifiable();
        this.maxLength = value;
        return this;
    }

    public BasicHttpEntity setUnmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    public void writeTo(OutputStream outStream) throws IOException {
    }

    protected byte[] asSafeBytes() {
        try {
            return this.asBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected final void assertModifiable() {
        if (this.unmodifiable) {
            throw ThrowableUtils.unsupportedOp((String)"Bean is read-only", (Object[])new Object[0]);
        }
    }

    protected <T> T contentOrElse(T def) {
        Object o = this.content;
        if (o == null && Utils.nn(this.contentSupplier)) {
            o = this.contentSupplier.get();
        }
        return (T)(o == null ? def : o);
    }

    protected boolean isSupplied() {
        return Utils.nn(this.contentSupplier);
    }
}

