/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Context;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.html.annotation.HtmlLink;
import org.apache.juneau.svl.VarResolverSession;

public class HtmlLinkAnnotation {
    public static final HtmlLink DEFAULT = HtmlLinkAnnotation.create().build();

    public static HtmlLink copy(HtmlLink a, VarResolverSession r) {
        return HtmlLinkAnnotation.create().nameProperty(r.resolve(a.nameProperty())).on(r.resolve(a.on())).onClass((Class[])a.onClass()).uriProperty(r.resolve(a.uriProperty())).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return HtmlLinkAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return HtmlLinkAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderT {
        private String[] description = new String[0];
        private String nameProperty = "";
        private String uriProperty = "";

        protected Builder() {
            super(HtmlLink.class);
        }

        public HtmlLink build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder nameProperty(String value) {
            this.nameProperty = value;
            return this;
        }

        public Builder uriProperty(String value) {
            this.uriProperty = value;
            return this;
        }

        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements HtmlLink {
        private final String[] description;
        private final String nameProperty;
        private final String uriProperty;

        Object(Builder b) {
            super((AppliedAnnotationObject.BuilderT)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.nameProperty = b.nameProperty;
            this.uriProperty = b.uriProperty;
        }

        @Override
        public String nameProperty() {
            return this.nameProperty;
        }

        @Override
        public String uriProperty() {
            return this.uriProperty;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public HtmlLink[] value();
    }

    public static class Apply
    extends AnnotationApplier<HtmlLink, Context.Builder> {
        public Apply(VarResolverSession vr) {
            super(HtmlLink.class, Context.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<HtmlLink> ai, Context.Builder b) {
            HtmlLink a = (HtmlLink)ai.inner();
            if (CollectionUtils.isEmptyArray((java.lang.Object[])a.on()) && CollectionUtils.isEmptyArray((java.lang.Object[])a.onClass())) {
                return;
            }
            b.annotations(HtmlLinkAnnotation.copy(a, this.vr()));
        }
    }
}

