/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Optional;
import java.util.OptionalLong;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.ControlRecord;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.LogHistory;
import org.apache.kafka.raft.internals.RecordsIterator;
import org.apache.kafka.raft.internals.TreeMapLogHistory;
import org.apache.kafka.raft.internals.VoterSetHistory;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.slf4j.Logger;

public final class KRaftControlRecordStateMachine {
    private static final long STARTING_NEXT_OFFSET = -1L;
    private static final long SMALLEST_LOG_OFFSET = 0L;
    private final ReplicatedLog log;
    private final RecordSerde<?> serde;
    private final BufferSupplier bufferSupplier;
    private final Logger logger;
    private final int maxBatchSizeBytes;
    private final VoterSetHistory voterSetHistory;
    private final LogHistory<KRaftVersion> kraftVersionHistory = new TreeMapLogHistory<KRaftVersion>();
    private volatile long nextOffset = -1L;

    public KRaftControlRecordStateMachine(VoterSet staticVoterSet, ReplicatedLog log, RecordSerde<?> serde, BufferSupplier bufferSupplier, int maxBatchSizeBytes, LogContext logContext) {
        this.log = log;
        this.voterSetHistory = new VoterSetHistory(staticVoterSet, logContext);
        this.serde = serde;
        this.bufferSupplier = bufferSupplier;
        this.maxBatchSizeBytes = maxBatchSizeBytes;
        this.logger = logContext.logger(this.getClass());
    }

    public void updateState() {
        this.maybeLoadSnapshot();
        this.maybeLoadLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateNewEntries(long endOffset) {
        Object object = this.voterSetHistory;
        synchronized (object) {
            this.voterSetHistory.truncateNewEntries(endOffset);
        }
        object = this.kraftVersionHistory;
        synchronized (object) {
            this.kraftVersionHistory.truncateNewEntries(endOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateOldEntries(long startOffset) {
        Object object = this.voterSetHistory;
        synchronized (object) {
            this.voterSetHistory.truncateOldEntries(startOffset);
        }
        object = this.kraftVersionHistory;
        synchronized (object) {
            this.kraftVersionHistory.truncateOldEntries(startOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoterSet lastVoterSet() {
        VoterSetHistory voterSetHistory = this.voterSetHistory;
        synchronized (voterSetHistory) {
            return this.voterSetHistory.lastValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<LogHistory.Entry<VoterSet>> lastVoterSetEntry() {
        VoterSetHistory voterSetHistory = this.voterSetHistory;
        synchronized (voterSetHistory) {
            return this.voterSetHistory.lastEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionalLong lastVoterSetOffset() {
        VoterSetHistory voterSetHistory = this.voterSetHistory;
        synchronized (voterSetHistory) {
            return this.voterSetHistory.lastVoterSetOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KRaftVersion lastKraftVersion() {
        LogHistory<KRaftVersion> logHistory = this.kraftVersionHistory;
        synchronized (logHistory) {
            return this.kraftVersionHistory.lastEntry().map(LogHistory.Entry::value).orElse(KRaftVersion.KRAFT_VERSION_0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<VoterSet> voterSetAtOffset(long offset) {
        this.checkOffsetIsValid(offset);
        VoterSetHistory voterSetHistory = this.voterSetHistory;
        synchronized (voterSetHistory) {
            return this.voterSetHistory.valueAtOrBefore(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KRaftVersion kraftVersionAtOffset(long offset) {
        this.checkOffsetIsValid(offset);
        LogHistory<KRaftVersion> logHistory = this.kraftVersionHistory;
        synchronized (logHistory) {
            return this.kraftVersionHistory.valueAtOrBefore(offset).orElse(KRaftVersion.KRAFT_VERSION_0);
        }
    }

    private void checkOffsetIsValid(long offset) {
        long fixedNextOffset = this.nextOffset;
        if (offset >= fixedNextOffset) {
            throw new IllegalArgumentException(String.format("Attempting the read a value at an offset (%d) which is greater than or equal to the largest known offset (%d)", offset, fixedNextOffset - 1L));
        }
    }

    private void maybeLoadLog() {
        while (this.log.endOffset().offset() > this.nextOffset) {
            LogFetchInfo info = this.log.read(this.nextOffset, Isolation.UNCOMMITTED);
            RecordsIterator iterator = new RecordsIterator(info.records, this.serde, this.bufferSupplier, this.maxBatchSizeBytes, true);
            Throwable throwable = null;
            try {
                while (iterator.hasNext()) {
                    Object batch = iterator.next();
                    this.handleBatch((Batch<?>)batch, OptionalLong.empty());
                    this.nextOffset = ((Batch)batch).lastOffset() + 1L;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (iterator == null) continue;
                if (throwable != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                iterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLoadSnapshot() {
        if ((this.nextOffset == -1L || this.nextOffset < this.log.startOffset()) && this.log.latestSnapshot().isPresent()) {
            RawSnapshotReader rawSnapshot = this.log.latestSnapshot().get();
            Object object = this.kraftVersionHistory;
            synchronized (object) {
                this.kraftVersionHistory.clear();
            }
            object = this.voterSetHistory;
            synchronized (object) {
                this.voterSetHistory.clear();
            }
            try (RecordsSnapshotReader<?> reader = RecordsSnapshotReader.of(rawSnapshot, this.serde, this.bufferSupplier, this.maxBatchSizeBytes, true);){
                this.logger.info("Loading snapshot ({}) since log start offset ({}) is greater than the internal listener's next offset ({})", new Object[]{reader.snapshotId(), this.log.startOffset(), this.nextOffset});
                OptionalLong currentOffset = OptionalLong.of(reader.lastContainedLogOffset());
                while (reader.hasNext()) {
                    Batch batch = (Batch)reader.next();
                    this.handleBatch(batch, currentOffset);
                }
                this.nextOffset = reader.lastContainedLogOffset() + 1L;
            }
        }
        if (this.nextOffset == -1L) {
            this.nextOffset = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBatch(Batch<?> batch, OptionalLong overrideOffset) {
        int offsetDelta = 0;
        for (ControlRecord record : batch.controlRecords()) {
            long currentOffset = overrideOffset.orElse(batch.baseOffset() + (long)offsetDelta);
            switch (record.type()) {
                case KRAFT_VOTERS: {
                    VoterSet voters = VoterSet.fromVotersRecord((VotersRecord)record.message());
                    this.logger.info("Latest set of voters is {} at offset {}", (Object)voters, (Object)currentOffset);
                    VoterSetHistory voterSetHistory = this.voterSetHistory;
                    synchronized (voterSetHistory) {
                        this.voterSetHistory.addAt(currentOffset, voters);
                        break;
                    }
                }
                case KRAFT_VERSION: {
                    KRaftVersion kraftVersion = KRaftVersion.fromFeatureLevel((short)((KRaftVersionRecord)record.message()).kRaftVersion());
                    this.logger.info("Latest {} is {} at offset {}", new Object[]{"kraft.version", kraftVersion, currentOffset});
                    LogHistory<KRaftVersion> logHistory = this.kraftVersionHistory;
                    synchronized (logHistory) {
                        this.kraftVersionHistory.addAt(currentOffset, kraftVersion);
                        break;
                    }
                }
            }
            ++offsetDelta;
        }
    }
}

