/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001B\u000e\u001d\u0001\u0005B\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tg\u0001\u0011\t\u0011)A\u0005a!AA\u0007\u0001BC\u0002\u0013\u0005Q\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u00037\u0011!i\u0004A!b\u0001\n\u0003q\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\f\u0001B\u0001B\u0003%1\u000bC\u0003`\u0001\u0011\u0005\u0001\rC\u0004j\u0001\t\u0007I\u0011\u00026\t\rI\u0004\u0001\u0015!\u0003l\u0011\u001d\u0019\bA1A\u0005\u0002QDq!a\u0001\u0001A\u0003%Q\u000fC\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003\u0002\b!A\u0011q\u0004\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0001\u0002$!A\u00111\b\u0001!\u0002\u0013\t)\u0003C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!9\u00111\u000b\u0001\u0005\u0002\u0005Us!CA,9\u0005\u0005\t\u0012AA-\r!YB$!A\t\u0002\u0005m\u0003BB0\u0019\t\u0003\ti\u0006C\u0005\u0002`a\t\n\u0011\"\u0001\u0002b\t92*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7feB{w\u000e\u001c\u0006\u0003;y\taa]3sm\u0016\u0014(\"A\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tIC&D\u0001+\u0015\tYc$A\u0003vi&d7/\u0003\u0002.U\t9Aj\\4hS:<\u0017\u0001\u00032s_.,'/\u00133\u0016\u0003A\u0002\"aI\u0019\n\u0005I\"#aA%oi\u0006I!M]8lKJLE\rI\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d\u001f\u0003\u001dqW\r^<pe.L!a\u000f\u001d\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\u0006y!/Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u0003ba&\u001cX#A \u0011\u0005\u0001\u000bU\"\u0001\u000f\n\u0005\tc\"!E!qSJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe\u0006)\u0011\r]5tA\u0005!A/[7f!\t1u*D\u0001H\u0015\tY\u0003J\u0003\u0002J\u0015\u000611m\\7n_:T!aH&\u000b\u00051k\u0015AB1qC\u000eDWMC\u0001O\u0003\ry'oZ\u0005\u0003!\u001e\u0013A\u0001V5nK\u0006Qa.^7UQJ,\u0017\rZ:\u0002?I,\u0017/^3ti\"\u000bg\u000e\u001a7fe\u00063x-\u00133mK6+GO]5d\u001d\u0006lW\r\u0005\u0002U7:\u0011Q+\u0017\t\u0003-\u0012j\u0011a\u0016\u0006\u00031\u0002\na\u0001\u0010:p_Rt\u0014B\u0001.%\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i#\u0013\u0001\u00038pI\u0016t\u0015-\\3\u0002\rqJg.\u001b;?)!\t'm\u00193fM\u001eD\u0007C\u0001!\u0001\u0011\u0015q3\u00021\u00011\u0011\u0015!4\u00021\u00017\u0011\u0015i4\u00021\u0001@\u0011\u0015!5\u00021\u0001F\u0011\u0015\t6\u00021\u00011\u0011\u0015\u00116\u00021\u0001T\u0011\u001dq6\u0002%AA\u0002M\u000bA\"\\3ue&\u001c7o\u0012:pkB,\u0012a\u001b\t\u0003YBl\u0011!\u001c\u0006\u0003]>\fq!\\3ue&\u001c7O\u0003\u0002\u001e\u0015&\u0011\u0011/\u001c\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018!D7fiJL7m]$s_V\u0004\b%\u0001\buQJ,\u0017\r\u001a)p_2\u001c\u0016N_3\u0016\u0003U\u0004\"A^@\u000e\u0003]T!\u0001_=\u0002\r\u0005$x.\\5d\u0015\tQ80\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001`?\u0002\tU$\u0018\u000e\u001c\u0006\u0002}\u0006!!.\u0019<b\u0013\r\t\ta\u001e\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002\u001fQD'/Z1e!>|GnU5{K\u0002\n!#Y4he\u0016<\u0017\r^3JI2,W*\u001a;feV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\tY\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0011\u0019wN]3\u000b\u00079\f\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011AB=b[6,'O\u0003\u0002\u0002\u001a\u0005\u00191m\\7\n\t\u0005u\u0011Q\u0002\u0002\u0006\u001b\u0016$XM]\u0001\u0014C\u001e<'/Z4bi\u0016LE\r\\3NKR,'\u000fI\u0001\neVtg.\u00192mKN,\"!!\n\u0011\r\u0005\u001d\u0012\u0011GA\u001b\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003_!\u0013AC2pY2,7\r^5p]&!\u00111GA\u0015\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007\u0001\u000b9$C\u0002\u0002:q\u00111cS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\f!B];o]\u0006\u0014G.Z:!\u00035\u0019'/Z1uK\"\u000bg\u000e\u001a7feR!\u0011\u0011IA$!\r\u0019\u00131I\u0005\u0004\u0003\u000b\"#\u0001B+oSRDa!!\u0013\u0015\u0001\u0004\u0001\u0014AA5e\u0003A\u0011Xm]5{KRC'/Z1e!>|G\u000e\u0006\u0003\u0002B\u0005=\u0003BBA)+\u0001\u0007\u0001'A\u0004oK^\u001c\u0016N_3\u0002\u0011MDW\u000f\u001e3po:$\"!!\u0011\u0002/-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:Q_>d\u0007C\u0001!\u0019'\tA\"\u0005\u0006\u0002\u0002Z\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"!a\u0019+\u0007M\u000b)g\u000b\u0002\u0002hA!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014!C;oG\",7m[3e\u0015\r\t\t\bJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA;\u0003W\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class KafkaRequestHandlerPool
implements Logging {
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final String nodeName;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicInteger threadPoolSize;
    private final Meter aggregateIdleMeter;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$7() {
        return "broker";
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ApiRequestHandler apis() {
        return this.apis;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), this.apis(), this.time, this.nodeName));
        Runnable daemon_runnable = (Runnable)this.runnables().apply(id);
        String daemon_name = "data-plane-kafka-request-handler-" + id;
        Object var2_3 = null;
        Object var3_2 = null;
        new KafkaThread(daemon_name, daemon_runnable, true).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Resizing request handler thread pool size from " + currentSize + " to " + newSize);
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ((KafkaRequestHandler)this.runnables().remove(currentSize - i)).stop());
        }
        this.threadPoolSize().set(newSize);
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> "shut down completely");
    }

    public KafkaRequestHandlerPool(int brokerId, RequestChannel requestChannel, ApiRequestHandler apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String nodeName) {
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.nodeName = nodeName;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.threadPoolSize = new AtomicInteger(numThreads);
        this.aggregateIdleMeter = this.metricsGroup().newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS);
        this.logIdent_$eq("[data-plane Kafka Request Handler on " + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(nodeName)) + " " + brokerId + "] ");
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
    }
}

