/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTopologyValue;

public class StreamsGroupTopologyValueJsonConverter {
    public static StreamsGroupTopologyValue read(JsonNode _node, short _version) {
        StreamsGroupTopologyValue _object = new StreamsGroupTopologyValue();
        JsonNode _epochNode = _node.get("epoch");
        if (_epochNode == null) {
            throw new RuntimeException("StreamsGroupTopologyValue: unable to locate field 'epoch', which is mandatory in version " + _version);
        }
        _object.epoch = MessageUtil.jsonNodeToInt((JsonNode)_epochNode, (String)"StreamsGroupTopologyValue");
        JsonNode _subtopologiesNode = _node.get("subtopologies");
        if (_subtopologiesNode == null) {
            throw new RuntimeException("StreamsGroupTopologyValue: unable to locate field 'subtopologies', which is mandatory in version " + _version);
        }
        if (!_subtopologiesNode.isArray()) {
            throw new RuntimeException("StreamsGroupTopologyValue expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<StreamsGroupTopologyValue.Subtopology> _collection = new ArrayList<StreamsGroupTopologyValue.Subtopology>(_subtopologiesNode.size());
        _object.subtopologies = _collection;
        for (JsonNode _element : _subtopologiesNode) {
            _collection.add(SubtopologyJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(StreamsGroupTopologyValue _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("epoch", (JsonNode)new IntNode(_object.epoch));
        ArrayNode _subtopologiesArray = new ArrayNode(JsonNodeFactory.instance);
        for (StreamsGroupTopologyValue.Subtopology _element : _object.subtopologies) {
            _subtopologiesArray.add(SubtopologyJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("subtopologies", (JsonNode)_subtopologiesArray);
        return _node;
    }

    public static JsonNode write(StreamsGroupTopologyValue _object, short _version) {
        return StreamsGroupTopologyValueJsonConverter.write(_object, _version, true);
    }

    public static class SubtopologyJsonConverter {
        public static StreamsGroupTopologyValue.Subtopology read(JsonNode _node, short _version) {
            StreamsGroupTopologyValue.Subtopology _object = new StreamsGroupTopologyValue.Subtopology();
            JsonNode _subtopologyIdNode = _node.get("subtopologyId");
            if (_subtopologyIdNode == null) {
                throw new RuntimeException("Subtopology: unable to locate field 'subtopologyId', which is mandatory in version " + _version);
            }
            if (!_subtopologyIdNode.isTextual()) {
                throw new RuntimeException("Subtopology expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.subtopologyId = _subtopologyIdNode.asText();
            JsonNode _sourceTopicsNode = _node.get("sourceTopics");
            if (_sourceTopicsNode == null) {
                throw new RuntimeException("Subtopology: unable to locate field 'sourceTopics', which is mandatory in version " + _version);
            }
            if (!_sourceTopicsNode.isArray()) {
                throw new RuntimeException("Subtopology expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<String> _collection = new ArrayList<String>(_sourceTopicsNode.size());
            _object.sourceTopics = _collection;
            for (Object _element : _sourceTopicsNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("Subtopology element expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _collection.add(_element.asText());
            }
            JsonNode _sourceTopicRegexNode = _node.get("sourceTopicRegex");
            if (_sourceTopicRegexNode == null) {
                throw new RuntimeException("Subtopology: unable to locate field 'sourceTopicRegex', which is mandatory in version " + _version);
            }
            if (!_sourceTopicRegexNode.isArray()) {
                throw new RuntimeException("Subtopology expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<String> _collection2 = new ArrayList<String>(_sourceTopicRegexNode.size());
            _object.sourceTopicRegex = _collection2;
            for (Object _element : _sourceTopicRegexNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("Subtopology element expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _collection2.add(_element.asText());
            }
            JsonNode _stateChangelogTopicsNode = _node.get("stateChangelogTopics");
            if (_stateChangelogTopicsNode == null) {
                throw new RuntimeException("Subtopology: unable to locate field 'stateChangelogTopics', which is mandatory in version " + _version);
            }
            if (!_stateChangelogTopicsNode.isArray()) {
                throw new RuntimeException("Subtopology expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<StreamsGroupTopologyValue.TopicInfo> _collection3 = new ArrayList<StreamsGroupTopologyValue.TopicInfo>(_stateChangelogTopicsNode.size());
            _object.stateChangelogTopics = _collection3;
            for (Object _element : _stateChangelogTopicsNode) {
                _collection3.add(TopicInfoJsonConverter.read((JsonNode)_element, _version));
            }
            JsonNode _repartitionSinkTopicsNode = _node.get("repartitionSinkTopics");
            if (_repartitionSinkTopicsNode == null) {
                throw new RuntimeException("Subtopology: unable to locate field 'repartitionSinkTopics', which is mandatory in version " + _version);
            }
            if (!_repartitionSinkTopicsNode.isArray()) {
                throw new RuntimeException("Subtopology expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<String> _collection4 = new ArrayList<String>(_repartitionSinkTopicsNode.size());
            _object.repartitionSinkTopics = _collection4;
            for (Object _element : _repartitionSinkTopicsNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("Subtopology element expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _collection4.add(_element.asText());
            }
            JsonNode _repartitionSourceTopicsNode = _node.get("repartitionSourceTopics");
            if (_repartitionSourceTopicsNode == null) {
                throw new RuntimeException("Subtopology: unable to locate field 'repartitionSourceTopics', which is mandatory in version " + _version);
            }
            if (!_repartitionSourceTopicsNode.isArray()) {
                throw new RuntimeException("Subtopology expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<StreamsGroupTopologyValue.TopicInfo> _collection5 = new ArrayList<StreamsGroupTopologyValue.TopicInfo>(_repartitionSourceTopicsNode.size());
            _object.repartitionSourceTopics = _collection5;
            for (JsonNode _element : _repartitionSourceTopicsNode) {
                _collection5.add(TopicInfoJsonConverter.read(_element, _version));
            }
            JsonNode _copartitionGroupsNode = _node.get("copartitionGroups");
            if (_copartitionGroupsNode == null) {
                throw new RuntimeException("Subtopology: unable to locate field 'copartitionGroups', which is mandatory in version " + _version);
            }
            if (!_copartitionGroupsNode.isArray()) {
                throw new RuntimeException("Subtopology expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<StreamsGroupTopologyValue.CopartitionGroup> _collection6 = new ArrayList<StreamsGroupTopologyValue.CopartitionGroup>(_copartitionGroupsNode.size());
            _object.copartitionGroups = _collection6;
            for (JsonNode _element : _copartitionGroupsNode) {
                _collection6.add(CopartitionGroupJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(StreamsGroupTopologyValue.Subtopology _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("subtopologyId", (JsonNode)new TextNode(_object.subtopologyId));
            ArrayNode _sourceTopicsArray = new ArrayNode(JsonNodeFactory.instance);
            for (String string : _object.sourceTopics) {
                _sourceTopicsArray.add((JsonNode)new TextNode(string));
            }
            _node.set("sourceTopics", (JsonNode)_sourceTopicsArray);
            ArrayNode _sourceTopicRegexArray = new ArrayNode(JsonNodeFactory.instance);
            for (String string : _object.sourceTopicRegex) {
                _sourceTopicRegexArray.add((JsonNode)new TextNode(string));
            }
            _node.set("sourceTopicRegex", (JsonNode)_sourceTopicRegexArray);
            ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
            for (StreamsGroupTopologyValue.TopicInfo topicInfo : _object.stateChangelogTopics) {
                arrayNode.add(TopicInfoJsonConverter.write(topicInfo, _version, _serializeRecords));
            }
            _node.set("stateChangelogTopics", (JsonNode)arrayNode);
            ArrayNode arrayNode2 = new ArrayNode(JsonNodeFactory.instance);
            for (String string : _object.repartitionSinkTopics) {
                arrayNode2.add((JsonNode)new TextNode(string));
            }
            _node.set("repartitionSinkTopics", (JsonNode)arrayNode2);
            ArrayNode arrayNode3 = new ArrayNode(JsonNodeFactory.instance);
            for (StreamsGroupTopologyValue.TopicInfo _element : _object.repartitionSourceTopics) {
                arrayNode3.add(TopicInfoJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("repartitionSourceTopics", (JsonNode)arrayNode3);
            ArrayNode arrayNode4 = new ArrayNode(JsonNodeFactory.instance);
            for (StreamsGroupTopologyValue.CopartitionGroup _element : _object.copartitionGroups) {
                arrayNode4.add(CopartitionGroupJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("copartitionGroups", (JsonNode)arrayNode4);
            return _node;
        }

        public static JsonNode write(StreamsGroupTopologyValue.Subtopology _object, short _version) {
            return SubtopologyJsonConverter.write(_object, _version, true);
        }
    }

    public static class TopicInfoJsonConverter {
        public static StreamsGroupTopologyValue.TopicInfo read(JsonNode _node, short _version) {
            StreamsGroupTopologyValue.TopicInfo _object = new StreamsGroupTopologyValue.TopicInfo();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("TopicInfo: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("TopicInfo expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.name = _nameNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicInfo: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            _object.partitions = MessageUtil.jsonNodeToInt((JsonNode)_partitionsNode, (String)"TopicInfo");
            JsonNode _replicationFactorNode = _node.get("replicationFactor");
            if (_replicationFactorNode == null) {
                throw new RuntimeException("TopicInfo: unable to locate field 'replicationFactor', which is mandatory in version " + _version);
            }
            _object.replicationFactor = MessageUtil.jsonNodeToShort((JsonNode)_replicationFactorNode, (String)"TopicInfo");
            JsonNode _topicConfigsNode = _node.get("topicConfigs");
            if (_topicConfigsNode == null) {
                throw new RuntimeException("TopicInfo: unable to locate field 'topicConfigs', which is mandatory in version " + _version);
            }
            if (!_topicConfigsNode.isArray()) {
                throw new RuntimeException("TopicInfo expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<StreamsGroupTopologyValue.TopicConfig> _collection = new ArrayList<StreamsGroupTopologyValue.TopicConfig>(_topicConfigsNode.size());
            _object.topicConfigs = _collection;
            for (JsonNode _element : _topicConfigsNode) {
                _collection.add(TopicConfigJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(StreamsGroupTopologyValue.TopicInfo _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            _node.set("partitions", (JsonNode)new IntNode(_object.partitions));
            _node.set("replicationFactor", (JsonNode)new ShortNode(_object.replicationFactor));
            ArrayNode _topicConfigsArray = new ArrayNode(JsonNodeFactory.instance);
            for (StreamsGroupTopologyValue.TopicConfig _element : _object.topicConfigs) {
                _topicConfigsArray.add(TopicConfigJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("topicConfigs", (JsonNode)_topicConfigsArray);
            return _node;
        }

        public static JsonNode write(StreamsGroupTopologyValue.TopicInfo _object, short _version) {
            return TopicInfoJsonConverter.write(_object, _version, true);
        }
    }

    public static class TopicConfigJsonConverter {
        public static StreamsGroupTopologyValue.TopicConfig read(JsonNode _node, short _version) {
            StreamsGroupTopologyValue.TopicConfig _object = new StreamsGroupTopologyValue.TopicConfig();
            JsonNode _keyNode = _node.get("key");
            if (_keyNode == null) {
                throw new RuntimeException("TopicConfig: unable to locate field 'key', which is mandatory in version " + _version);
            }
            if (!_keyNode.isTextual()) {
                throw new RuntimeException("TopicConfig expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.key = _keyNode.asText();
            JsonNode _valueNode = _node.get("value");
            if (_valueNode == null) {
                throw new RuntimeException("TopicConfig: unable to locate field 'value', which is mandatory in version " + _version);
            }
            if (!_valueNode.isTextual()) {
                throw new RuntimeException("TopicConfig expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.value = _valueNode.asText();
            return _object;
        }

        public static JsonNode write(StreamsGroupTopologyValue.TopicConfig _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("key", (JsonNode)new TextNode(_object.key));
            _node.set("value", (JsonNode)new TextNode(_object.value));
            return _node;
        }

        public static JsonNode write(StreamsGroupTopologyValue.TopicConfig _object, short _version) {
            return TopicConfigJsonConverter.write(_object, _version, true);
        }
    }

    public static class CopartitionGroupJsonConverter {
        public static StreamsGroupTopologyValue.CopartitionGroup read(JsonNode _node, short _version) {
            StreamsGroupTopologyValue.CopartitionGroup _object = new StreamsGroupTopologyValue.CopartitionGroup();
            JsonNode _sourceTopicsNode = _node.get("sourceTopics");
            if (_sourceTopicsNode == null) {
                throw new RuntimeException("CopartitionGroup: unable to locate field 'sourceTopics', which is mandatory in version " + _version);
            }
            if (!_sourceTopicsNode.isArray()) {
                throw new RuntimeException("CopartitionGroup expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Short> _collection = new ArrayList<Short>(_sourceTopicsNode.size());
            _object.sourceTopics = _collection;
            for (Object _element : _sourceTopicsNode) {
                _collection.add(MessageUtil.jsonNodeToShort((JsonNode)_element, (String)"CopartitionGroup element"));
            }
            JsonNode _sourceTopicRegexNode = _node.get("sourceTopicRegex");
            if (_sourceTopicRegexNode == null) {
                throw new RuntimeException("CopartitionGroup: unable to locate field 'sourceTopicRegex', which is mandatory in version " + _version);
            }
            if (!_sourceTopicRegexNode.isArray()) {
                throw new RuntimeException("CopartitionGroup expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Short> _collection2 = new ArrayList<Short>(_sourceTopicRegexNode.size());
            _object.sourceTopicRegex = _collection2;
            for (JsonNode _element : _sourceTopicRegexNode) {
                _collection2.add(MessageUtil.jsonNodeToShort((JsonNode)_element, (String)"CopartitionGroup element"));
            }
            JsonNode _repartitionSourceTopicsNode = _node.get("repartitionSourceTopics");
            if (_repartitionSourceTopicsNode == null) {
                throw new RuntimeException("CopartitionGroup: unable to locate field 'repartitionSourceTopics', which is mandatory in version " + _version);
            }
            if (!_repartitionSourceTopicsNode.isArray()) {
                throw new RuntimeException("CopartitionGroup expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Short> _collection3 = new ArrayList<Short>(_repartitionSourceTopicsNode.size());
            _object.repartitionSourceTopics = _collection3;
            for (JsonNode _element : _repartitionSourceTopicsNode) {
                _collection3.add(MessageUtil.jsonNodeToShort((JsonNode)_element, (String)"CopartitionGroup element"));
            }
            return _object;
        }

        public static JsonNode write(StreamsGroupTopologyValue.CopartitionGroup _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            ArrayNode _sourceTopicsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Short s : _object.sourceTopics) {
                _sourceTopicsArray.add((JsonNode)new ShortNode(s.shortValue()));
            }
            _node.set("sourceTopics", (JsonNode)_sourceTopicsArray);
            ArrayNode _sourceTopicRegexArray = new ArrayNode(JsonNodeFactory.instance);
            for (Short _element : _object.sourceTopicRegex) {
                _sourceTopicRegexArray.add((JsonNode)new ShortNode(_element.shortValue()));
            }
            _node.set("sourceTopicRegex", (JsonNode)_sourceTopicRegexArray);
            ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
            for (Short _element : _object.repartitionSourceTopics) {
                arrayNode.add((JsonNode)new ShortNode(_element.shortValue()));
            }
            _node.set("repartitionSourceTopics", (JsonNode)arrayNode);
            return _node;
        }

        public static JsonNode write(StreamsGroupTopologyValue.CopartitionGroup _object, short _version) {
            return CopartitionGroupJsonConverter.write(_object, _version, true);
        }
    }
}

