/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ctl.cmd.create;

import java.io.Serializable;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.ctl.cmd.Command;
import org.apache.kyuubi.ctl.opt.CliConfig;
import org.apache.kyuubi.ctl.opt.ControlObject$;
import org.apache.kyuubi.ctl.util.CtlUtils$;
import org.apache.kyuubi.ctl.util.Render$;
import org.apache.kyuubi.ctl.util.Validator$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u001d3AAB\u0004\u0001)!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003B\u0001\u0011\u0005#\tC\u0003D\u0001\u0011\u0005CIA\nDe\u0016\fG/Z*feZ,'oQ8n[\u0006tGM\u0003\u0002\t\u0013\u000511M]3bi\u0016T!AC\u0006\u0002\u0007\rlGM\u0003\u0002\r\u001b\u0005\u00191\r\u001e7\u000b\u00059y\u0011AB6zkV\u0014\u0017N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u00012AF\f\u001a\u001b\u0005I\u0011B\u0001\r\n\u0005\u001d\u0019u.\\7b]\u0012\u00042A\u0007\u0013(\u001d\tY\u0012E\u0004\u0002\u001d?5\tQD\u0003\u0002\u001f'\u00051AH]8pizJ\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E\r\nq\u0001]1dW\u0006<WMC\u0001!\u0013\t)cE\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\t\u00113\u0005\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u000511\r\\5f]RT!\u0001L\u0007\u0002\u0005!\f\u0017B\u0001\u0018*\u0005=\u0019VM\u001d<jG\u0016tu\u000eZ3J]\u001a|\u0017!C2mS\u000e{gNZ5h!\t\tD'D\u00013\u0015\t\u00194\"A\u0002paRL!!\u000e\u001a\u0003\u0013\rc\u0017nQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u00029uA\u0011\u0011\bA\u0007\u0002\u000f!)qF\u0001a\u0001a\u0005Aa/\u00197jI\u0006$X\rF\u0001>!\tqt(D\u0001$\u0013\t\u00015E\u0001\u0003V]&$\u0018!\u00023p%VtG#A\r\u0002\rI,g\u000eZ3s)\tiT\tC\u0003G\u000b\u0001\u0007\u0011$A\u0003o_\u0012,7\u000f")
public class CreateServerCommand
extends Command<Iterable<ServiceNodeInfo>> {
    @Override
    public void validate() {
        Enumeration.Value value = this.normalizedCliConfig().resource();
        Enumeration.Value value2 = ControlObject$.MODULE$.SERVER();
        if (value == null ? value2 != null : !value.equals(value2)) {
            this.fail("Only support expose Kyuubi server instance to another domain");
        }
        Validator$.MODULE$.validateZkArguments(this.normalizedCliConfig());
        String defaultNamespace = (String)this.conf().getOption(HighAvailabilityConf$.MODULE$.HA_NAMESPACE().key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> HighAvailabilityConf$.MODULE$.HA_NAMESPACE().defaultValStr());
        if (defaultNamespace.equals(this.normalizedCliConfig().zkOpts().namespace())) {
            this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(168).append("\n           |Only support expose Kyuubi server instance to another domain, a different namespace\n           |than the default namespace [").append(defaultNamespace).append("] should be specified.\n        ").toString())).stripMargin());
            return;
        }
    }

    @Override
    public Iterable<ServiceNodeInfo> doRun() {
        KyuubiConf kyuubiConf = this.conf();
        kyuubiConf.setIfMissing(HighAvailabilityConf$.MODULE$.HA_ADDRESSES(), (Object)this.normalizedCliConfig().zkOpts().zkQuorum());
        return (Iterable)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(kyuubiConf, (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            Object object;
            String fromNamespace = DiscoveryPaths$.MODULE$.makePath(null, (String)kyuubiConf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            String toNamespace = CtlUtils$.MODULE$.getZkServerNamespace(kyuubiConf, this.normalizedCliConfig());
            Seq currentServerNodes = discoveryClient.getServiceNodesInfo(fromNamespace, discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3());
            ListBuffer exposedServiceNodes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (currentServerNodes.nonEmpty()) {
                Object object2 = kyuubiConf.get(HighAvailabilityConf$.MODULE$.HA_ADDRESSES());
                String string = this.normalizedCliConfig().zkOpts().zkQuorum();
                if (!(object2 != null ? !object2.equals(string) : string != null)) {
                    this.doCreate$1((DiscoveryClient)discoveryClient, currentServerNodes, fromNamespace, toNamespace, kyuubiConf, exposedServiceNodes);
                    object = BoxedUnit.UNIT;
                } else {
                    kyuubiConf.set(HighAvailabilityConf$.MODULE$.HA_ADDRESSES(), (Object)this.normalizedCliConfig().zkOpts().zkQuorum());
                    object = DiscoveryClientProvider$.MODULE$.withDiscoveryClient(kyuubiConf, (Function1 & Serializable & scala.Serializable)zc -> {
                        this.doCreate$1(zc, currentServerNodes, fromNamespace, toNamespace, kyuubiConf, exposedServiceNodes);
                        return BoxedUnit.UNIT;
                    });
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            return exposedServiceNodes;
        });
    }

    @Override
    public void render(Iterable<ServiceNodeInfo> nodes) {
        String title = "Created zookeeper service nodes";
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> Render$.MODULE$.renderServiceNodesInfo(title, nodes));
    }

    private final void doCreate$1(DiscoveryClient zc, Seq currentServerNodes$1, String fromNamespace$1, String toNamespace$1, KyuubiConf kyuubiConf$1, ListBuffer exposedServiceNodes$1) {
        currentServerNodes$1.foreach((Function1 & Serializable & scala.Serializable)sn -> {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Exposing server instance:").append(sn.instance()).append(" with version:").append(sn.version()).append(" from ").append(fromNamespace$1).append(" to ").append(toNamespace$1).toString());
            String newNodePath = zc.createAndGetServiceNode(kyuubiConf$1, this.normalizedCliConfig().zkOpts().namespace(), sn.instance(), sn.version(), true);
            return exposedServiceNodes$1.$plus$eq((Object)sn.copy(toNamespace$1, (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newNodePath.split("/"))).last(), sn.copy$default$3(), sn.copy$default$4(), sn.copy$default$5(), sn.copy$default$6(), sn.copy$default$7()));
        });
    }

    public CreateServerCommand(CliConfig cliConfig) {
        super(cliConfig);
    }
}

