/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.metrics;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

public class CustomResourceMetricValue {
    private final Map<String, Long> values = Maps.newHashMap();

    public void increase(Resource res) {
        this.update(res, Long::sum);
    }

    public void increaseWithMultiplier(Resource res, long multiplier) {
        this.update(res, (v1, v2) -> v1 + v2 * multiplier);
    }

    public void decrease(Resource res) {
        this.update(res, (v1, v2) -> v1 - v2);
    }

    public void decreaseWithMultiplier(Resource res, int containers) {
        this.update(res, (v1, v2) -> v1 - v2 * (long)containers);
    }

    public void set(Resource res) {
        this.update(res, (v1, v2) -> v2);
    }

    private void update(Resource res, BiFunction<Long, Long, Long> operation) {
        if (ResourceUtils.getNumberOfKnownResourceTypes() > 2) {
            ResourceInformation[] resources = res.getResources();
            for (int i = 2; i < resources.length; ++i) {
                ResourceInformation resource = resources[i];
                if (!this.values.containsKey(resource.getName())) {
                    this.values.put(resource.getName(), 0L);
                }
                this.values.merge(resource.getName(), resource.getValue(), operation);
            }
        }
    }

    public Map<String, Long> getValues() {
        return this.values;
    }
}

