/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.ClientCommandHookFactory;
import org.apache.hive.beeline.ClientHook;
import org.apache.hive.beeline.Commands;
import org.apache.hive.beeline.KyuubiBeeLine;
import org.apache.hive.beeline.KyuubiDatabaseConnection;
import org.apache.hive.beeline.common.util.HiveStringUtils;
import org.apache.hive.beeline.logs.KyuubiBeelineInPlaceUpdateStream;
import org.apache.kyuubi.jdbc.hive.KyuubiStatement;
import org.apache.kyuubi.jdbc.hive.Utils;
import org.apache.kyuubi.jdbc.hive.logs.InPlaceUpdateStream;
import org.apache.kyuubi.jdbc.hive.logs.KyuubiLoggable;

public class KyuubiCommands
extends Commands {
    protected KyuubiBeeLine beeLine;
    protected static final int DEFAULT_QUERY_PROGRESS_INTERVAL = 1000;
    protected static final int DEFAULT_QUERY_PROGRESS_THREAD_TIMEOUT = 10000;

    public KyuubiCommands(KyuubiBeeLine beeLine) {
        super(beeLine);
        this.beeLine = beeLine;
    }

    @Override
    public boolean sql(String line) {
        return this.execute(line, false, false);
    }

    private String trimForNonPythonMode(String line) {
        return this.beeLine.isPythonMode() ? line : line.trim();
    }

    private String getFirstCmd(String cmd, int length) {
        return this.trimForNonPythonMode(cmd.substring(length));
    }

    private String[] tokenizeCmd(String cmd) {
        return cmd.split("\\s+");
    }

    private boolean isSourceCMD(String cmd) {
        if (cmd == null || cmd.isEmpty()) {
            return false;
        }
        String[] tokens = this.tokenizeCmd(cmd);
        return tokens[0].equalsIgnoreCase("source");
    }

    private boolean sourceFile(String cmd) {
        boolean ret;
        String[] tokens = this.tokenizeCmd(cmd);
        String cmd_1 = this.getFirstCmd(cmd, tokens[0].length());
        File sourceFile = new File(cmd_1);
        if (!sourceFile.isFile()) {
            return false;
        }
        try {
            ret = this.sourceFileInternal(sourceFile);
        }
        catch (IOException e) {
            this.beeLine.error(e);
            return false;
        }
        return ret;
    }

    private boolean sourceFileInternal(File sourceFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(sourceFile.toPath());){
            String[] cmds;
            String extra;
            String lines = null;
            while ((extra = reader.readLine()) != null) {
                if (this.beeLine.isComment(extra)) continue;
                if (lines == null) {
                    lines = extra;
                    continue;
                }
                lines = lines + "\n" + extra;
            }
            for (String c : cmds = lines.split(this.beeLine.getOpts().getDelimiter())) {
                if (this.executeInternal(c = this.trimForNonPythonMode(c), false)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(String sql, boolean call) {
        String prefix;
        if (!this.beeLine.isBeeLine()) {
            sql = this.cliToBeelineCmd(sql);
        }
        if (sql == null || sql.length() == 0) {
            return true;
        }
        if (this.beeLine.isComment(sql)) {
            return true;
        }
        if (this.isSourceCMD(sql)) {
            return this.sourceFile(sql);
        }
        if (sql.startsWith("!")) {
            return this.beeLine.execCommandWithPrefix(sql);
        }
        String string = prefix = call ? "call" : "sql";
        if (sql.startsWith(prefix)) {
            sql = sql.substring(prefix.length());
        }
        if (this.beeLine.getBatch() != null) {
            this.beeLine.getBatch().add(sql);
            return true;
        }
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        ClientHook hook = ClientCommandHookFactory.get().getHook(this.beeLine, sql);
        try {
            Statement stmnt = null;
            Thread logThread = null;
            try {
                boolean hasResults;
                long start = System.currentTimeMillis();
                if (call) {
                    stmnt = this.beeLine.getDatabaseConnection().getConnection().prepareCall(sql);
                    hasResults = ((CallableStatement)stmnt).execute();
                } else {
                    stmnt = this.beeLine.createStatement();
                    if (this.beeLine.getOpts().isSilent()) {
                        hasResults = stmnt.execute(sql);
                    } else {
                        InPlaceUpdateStream.EventNotifier eventNotifier = new InPlaceUpdateStream.EventNotifier();
                        logThread = new Thread(this.createLogRunnable(stmnt, eventNotifier));
                        logThread.setDaemon(true);
                        logThread.start();
                        if (stmnt instanceof KyuubiStatement) {
                            KyuubiStatement kyuubiStatement = (KyuubiStatement)stmnt;
                            kyuubiStatement.setInPlaceUpdateStream((InPlaceUpdateStream)new KyuubiBeelineInPlaceUpdateStream(this.beeLine.getErrorStream(), eventNotifier));
                        }
                        hasResults = stmnt.execute(sql);
                        logThread.interrupt();
                        logThread.join(10000L);
                    }
                }
                this.beeLine.showWarnings();
                if (hasResults) {
                    do {
                        ResultSet rs = stmnt.getResultSet();
                        try {
                            int count = this.beeLine.print(rs);
                            long end = System.currentTimeMillis();
                            this.beeLine.info(this.beeLine.loc("rows-selected", count) + " " + this.beeLine.locElapsedTime(end - start));
                        }
                        finally {
                            if (logThread != null) {
                                logThread.join(10000L);
                                this.showRemainingLogsIfAny(stmnt);
                                logThread = null;
                            }
                            rs.close();
                        }
                    } while (BeeLine.getMoreResults(stmnt));
                } else {
                    int count = stmnt.getUpdateCount();
                    long end = System.currentTimeMillis();
                    this.beeLine.info(this.beeLine.loc("rows-affected", count) + " " + this.beeLine.locElapsedTime(end - start));
                }
            }
            finally {
                if (logThread != null) {
                    if (!logThread.isInterrupted()) {
                        logThread.interrupt();
                    }
                    logThread.join(10000L);
                    this.showRemainingLogsIfAny(stmnt);
                }
                if (stmnt != null) {
                    stmnt.close();
                }
            }
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        this.beeLine.showWarnings();
        if (hook != null) {
            hook.postHook(this.beeLine);
        }
        return true;
    }

    @Override
    public boolean sql(String line, boolean entireLineAsCommand) {
        return this.execute(line, false, entireLineAsCommand);
    }

    @Override
    public boolean call(String line) {
        return this.execute(line, true, false);
    }

    private boolean execute(String line, boolean call, boolean entireLineAsCommand) {
        if (line == null || line.length() == 0) {
            return false;
        }
        try {
            line = this.handleMultiLineCmd(line);
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
        line = this.trimForNonPythonMode(line);
        List<String> cmdList = this.getCmdList(line, entireLineAsCommand);
        for (int i = 0; i < cmdList.size(); ++i) {
            String sql = this.trimForNonPythonMode(cmdList.get(i));
            if (sql.length() == 0 || this.executeInternal(sql, call)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public List<String> getCmdList(String line, boolean entireLineAsCommand) {
        ArrayList<String> cmdList = new ArrayList<String>();
        if (entireLineAsCommand) {
            cmdList.add(line);
        } else {
            int index;
            StringBuilder command = new StringBuilder();
            boolean hasUnterminatedDoubleQuote = false;
            boolean hasUnterminatedSingleQuote = false;
            int lastSemiColonIndex = 0;
            char[] lineChars = line.toCharArray();
            boolean wasPrevEscape = false;
            block6: for (index = 0; index < lineChars.length; ++index) {
                switch (lineChars[index]) {
                    case '\'': {
                        if (!hasUnterminatedDoubleQuote && !wasPrevEscape) {
                            hasUnterminatedSingleQuote = !hasUnterminatedSingleQuote;
                        }
                        wasPrevEscape = false;
                        continue block6;
                    }
                    case '\"': {
                        if (!hasUnterminatedSingleQuote && !wasPrevEscape) {
                            hasUnterminatedDoubleQuote = !hasUnterminatedDoubleQuote;
                        }
                        wasPrevEscape = false;
                        continue block6;
                    }
                    case ';': {
                        if (!hasUnterminatedDoubleQuote && !hasUnterminatedSingleQuote) {
                            this.addCmdPart(cmdList, command, line.substring(lastSemiColonIndex, index));
                            lastSemiColonIndex = index + 1;
                        }
                        wasPrevEscape = false;
                        continue block6;
                    }
                    case '\\': {
                        wasPrevEscape = !wasPrevEscape;
                        continue block6;
                    }
                    default: {
                        wasPrevEscape = false;
                    }
                }
            }
            if (lastSemiColonIndex != index || lineChars.length == 0) {
                this.addCmdPart(cmdList, command, line.substring(lastSemiColonIndex, index));
            }
        }
        return cmdList;
    }

    private void addCmdPart(List<String> cmdList, StringBuilder command, String cmdpart) {
        if (cmdpart.endsWith("\\")) {
            command.append(cmdpart, 0, cmdpart.length() - 1).append(";");
            return;
        }
        command.append(cmdpart);
        cmdList.add(command.toString());
        command.setLength(0);
    }

    protected Runnable createLogRunnable(Object sqlObject, InPlaceUpdateStream.EventNotifier eventNotifier) {
        if (sqlObject instanceof KyuubiLoggable) {
            return new KyuubiLogRunnable(this, (KyuubiLoggable)sqlObject, 1000L, eventNotifier);
        }
        this.beeLine.debug("The instance is not KyuubiLoggable type: " + sqlObject.getClass());
        return new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    private void showRemainingLogsIfAny(Object sqlObject) {
        if (sqlObject instanceof KyuubiLoggable) {
            KyuubiLoggable kyuubiLoggable = (KyuubiLoggable)sqlObject;
            List logs = null;
            do {
                try {
                    logs = kyuubiLoggable.getExecLog();
                }
                catch (SQLException e) {
                    this.beeLine.error(new SQLWarning(e));
                    return;
                }
                for (String log : logs) {
                    this.beeLine.info(log);
                }
            } while (logs.size() > 0);
        } else {
            this.beeLine.debug("The instance is not KyuubiLoggable type: " + sqlObject.getClass());
        }
    }

    private String getProperty(Properties props, String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            String string = props.getProperty(keys[i]);
            if (string == null) continue;
            return string;
        }
        for (String string : props.keySet()) {
            for (int j = 0; j < keys.length; ++j) {
                if (!string.endsWith(keys[j])) continue;
                return props.getProperty(string);
            }
        }
        return null;
    }

    @Override
    public boolean connect(Properties props) throws IOException {
        String url = this.getProperty(props, new String[]{"url", "javax.jdo.option.ConnectionURL", "ConnectionURL"});
        String driver = this.getProperty(props, new String[]{"driver", "javax.jdo.option.ConnectionDriverName", "ConnectionDriverName"});
        String username = this.getProperty(props, new String[]{"user", "javax.jdo.option.ConnectionUserName", "ConnectionUserName"});
        String password = this.getProperty(props, new String[]{"password", "javax.jdo.option.ConnectionPassword", "ConnectionPassword"});
        if (url == null || url.length() == 0) {
            return this.beeLine.error("Property \"url\" is required");
        }
        if (!(driver != null && driver.length() != 0 || this.beeLine.scanForDriver(url))) {
            return this.beeLine.error(this.beeLine.loc("no-driver", url));
        }
        String auth = this.getProperty(props, new String[]{"auth"});
        if (auth == null && (auth = this.beeLine.getOpts().getAuthType()) != null) {
            props.setProperty("auth", auth);
        }
        this.beeLine.info("Connecting to " + url);
        if (Utils.parsePropertyFromUrl((String)url, (String)"principal") == null && Utils.parsePropertyFromUrl((String)url, (String)"kyuubiServerPrincipal") == null) {
            String urlForPrompt = url.substring(0, url.contains(";") ? url.indexOf(59) : url.length());
            if (username == null) {
                username = this.beeLine.getConsoleReader().readLine("Enter username for " + urlForPrompt + ": ");
            }
            props.setProperty("user", username);
            if (password == null) {
                password = this.beeLine.getConsoleReader().readLine("Enter password for " + urlForPrompt + ": ", Character.valueOf('*'));
            }
            props.setProperty("password", password);
        }
        try {
            this.beeLine.getDatabaseConnections().setConnection(new KyuubiDatabaseConnection(this.beeLine, driver, url, props));
            this.beeLine.getDatabaseConnection().getConnection();
            int initScriptExecutionResult = this.beeLine.runInit();
            if (initScriptExecutionResult != 0 && !this.beeLine.getOpts().getForce()) {
                return this.beeLine.error("init script execution failed.");
            }
            if (this.beeLine.getOpts().getInitFiles() != null) {
                this.beeLine.initializeConsoleReader(null);
            }
            this.beeLine.setCompletions();
            this.beeLine.getOpts().setLastConnectedUrl(url);
            return true;
        }
        catch (SQLException sqle) {
            this.beeLine.getDatabaseConnections().remove();
            return this.beeLine.error(sqle);
        }
        catch (IOException ioe) {
            return this.beeLine.error(ioe);
        }
    }

    @Override
    public String handleMultiLineCmd(String line) throws IOException {
        Character mask;
        Character c = mask = System.getProperty("jline.terminal", "").equals("jline.UnsupportedTerminal") ? null : Character.valueOf('\u0000');
        if (!this.beeLine.isPythonMode()) {
            line = HiveStringUtils.removeComments(line);
        }
        while (this.isMultiLine(line) && this.beeLine.getOpts().isAllowMultiLineCommand()) {
            StringBuilder prompt = new StringBuilder(this.beeLine.getPrompt());
            if (!this.beeLine.getOpts().isSilent()) {
                for (int i = 0; i < prompt.length() - 1; ++i) {
                    if (prompt.charAt(i) == '>') continue;
                    prompt.setCharAt(i, i % 2 == 0 ? (char)'.' : ' ');
                }
            }
            if (this.beeLine.getConsoleReader() == null) {
                throw new RuntimeException("Console reader not initialized. This could happen when there is a multi-line command using -e option and which requires further reading from console");
            }
            String extra = this.beeLine.getOpts().isSilent() && this.beeLine.getOpts().getScriptFile() != null ? this.beeLine.getConsoleReader().readLine(null, mask) : this.beeLine.getConsoleReader().readLine(prompt.toString());
            if (extra == null) break;
            if (!this.beeLine.isPythonMode()) {
                extra = HiveStringUtils.removeComments(extra);
            }
            if (extra.isEmpty()) continue;
            line = line + "\n" + extra;
        }
        return line;
    }

    private boolean isMultiLine(String line) {
        if ((line = this.trimForNonPythonMode(line)).endsWith(this.beeLine.getOpts().getDelimiter()) || this.beeLine.isComment(line)) {
            return false;
        }
        List<String> cmds = this.getCmdList(line, false);
        return cmds.isEmpty() || !this.trimForNonPythonMode(cmds.get(cmds.size() - 1)).startsWith("--");
    }

    static class KyuubiLogRunnable
    implements Runnable {
        private final KyuubiCommands commands;
        private final KyuubiLoggable kyuubiLoggable;
        private final long queryProgressInterval;
        private final InPlaceUpdateStream.EventNotifier notifier;

        KyuubiLogRunnable(KyuubiCommands commands, KyuubiLoggable kyuubiLoggable, long queryProgressInterval, InPlaceUpdateStream.EventNotifier eventNotifier) {
            this.kyuubiLoggable = kyuubiLoggable;
            this.commands = commands;
            this.queryProgressInterval = queryProgressInterval;
            this.notifier = eventNotifier;
        }

        private void updateExecLog() {
            try {
                List execLogs = this.kyuubiLoggable.getExecLog();
                for (String log : execLogs) {
                    this.commands.beeLine.info(log);
                }
                if (!execLogs.isEmpty()) {
                    this.notifier.operationLogShowedToUser();
                }
            }
            catch (SQLException e) {
                this.commands.beeLine.error(new SQLWarning(e));
            }
        }

        @Override
        public void run() {
            try {
                while (this.kyuubiLoggable.hasMoreLogs()) {
                    if (this.notifier.canOutputOperationLogs()) {
                        this.commands.beeLine.debug("going to print operations logs");
                        this.updateExecLog();
                        this.commands.beeLine.debug("printed operations logs");
                    }
                    Thread.sleep(this.queryProgressInterval);
                }
            }
            catch (InterruptedException e) {
                this.commands.beeLine.debug("Getting log thread is interrupted, since query is done!");
            }
            finally {
                this.commands.showRemainingLogsIfAny(this.kyuubiLoggable);
            }
        }
    }
}

