/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.identity.backend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.identity.KrbIdentity;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.identity.backend.AbstractIdentityBackend;

public class MemoryIdentityBackend
extends AbstractIdentityBackend {
    private static final int DEFAULT_STORAGE_SIZE = 10000000;
    private Map<String, KrbIdentity> storage;
    private int storageSize = 10000000;

    @Override
    protected void doInitialize() {
        LinkedHashMap<String, KrbIdentity> tmpMap = new LinkedHashMap<String, KrbIdentity>(this.storageSize){
            private static final long serialVersionUID = 714064587685837472L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, KrbIdentity> eldest) {
                return this.size() > MemoryIdentityBackend.this.storageSize;
            }
        };
        this.storage = new ConcurrentHashMap<String, KrbIdentity>(tmpMap);
    }

    @Override
    protected KrbIdentity doGetIdentity(String principalName) {
        return this.storage.get(principalName);
    }

    @Override
    protected KrbIdentity doAddIdentity(KrbIdentity identity) {
        this.storage.put(identity.getPrincipalName(), identity);
        return identity;
    }

    @Override
    protected KrbIdentity doUpdateIdentity(KrbIdentity identity) {
        return this.storage.put(identity.getPrincipalName(), identity);
    }

    @Override
    protected void doDeleteIdentity(String principalName) {
        this.storage.remove(principalName);
    }

    @Override
    protected Iterable<String> doGetIdentities() throws KrbException {
        ArrayList<String> identities = new ArrayList<String>(this.storage.keySet());
        Collections.sort(identities);
        return identities;
    }
}

