/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.Client;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientHandlerException;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientRequest;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientResponse;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.UniformInterfaceException;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.WebResource;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.filter.ClientFilter;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.GnuParser;
import org.apache.hadoop.shaded.org.apache.commons.cli.HelpFormatter;
import org.apache.hadoop.shaded.org.apache.commons.cli.Option;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.shaded.org.apache.commons.cli.ParseException;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.shaded.org.apache.commons.math3.util.Pair;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONArray;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONException;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONObject;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.logaggregation.ContainerLogFileInfo;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogCLIHelpers;
import org.apache.hadoop.yarn.logaggregation.LogToolUtils;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.util.WebServiceClient;
import org.apache.hadoop.yarn.webapp.util.YarnWebServiceUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class LogsCLI
extends Configured
implements Tool {
    private static final String CONTAINER_ID_OPTION = "containerId";
    private static final String APPLICATION_ID_OPTION = "applicationId";
    private static final String CLUSTER_ID_OPTION = "clusterId";
    private static final String NODE_ADDRESS_OPTION = "nodeAddress";
    private static final String APP_OWNER_OPTION = "appOwner";
    private static final String AM_CONTAINER_OPTION = "am";
    private static final String PER_CONTAINER_LOG_FILES_OPTION = "log_files";
    private static final String PER_CONTAINER_LOG_FILES_OLD_OPTION = "logFiles";
    private static final String PER_CONTAINER_LOG_FILES_REGEX_OPTION = "log_files_pattern";
    private static final String LIST_NODES_OPTION = "list_nodes";
    private static final String SHOW_APPLICATION_LOG_INFO = "show_application_log_info";
    private static final String SHOW_CONTAINER_LOG_INFO = "show_container_log_info";
    private static final String OUT_OPTION = "out";
    private static final String SIZE_OPTION = "size";
    private static final String CLIENT_MAX_RETRY_OPTION = "client_max_retries";
    private static final String CLIENT_RETRY_INTERVAL_OPTION = "client_retry_interval_ms";
    public static final String HELP_CMD = "help";
    private static final String SIZE_LIMIT_OPTION = "size_limit_mb";
    private PrintStream outStream = System.out;
    private YarnClient yarnClient = null;
    private Client webServiceClient = null;
    private static final int DEFAULT_MAX_RETRIES = 30;
    private static final long DEFAULT_RETRY_INTERVAL = 1000L;
    private static final long LOG_SIZE_LIMIT_DEFAULT = 10240L;
    private long logSizeLeft = 0x280000000L;
    private long specifedLogLimits = 10240L;
    @InterfaceAudience.Private
    @VisibleForTesting
    ClientConnectionRetry connectionRetry;

    @Override
    public int run(String[] args) throws Exception {
        try {
            this.webServiceClient = WebServiceClient.getWebServiceClient().createClient();
            int n = this.runCommand(args);
            return n;
        }
        finally {
            if (this.yarnClient != null) {
                this.yarnClient.close();
            }
            if (this.webServiceClient != null) {
                this.webServiceClient.destroy();
            }
        }
    }

    private int runCommand(String[] args) throws Exception {
        File file;
        Options opts = this.createCommandOpts();
        Options printOpts = this.createPrintOpts(opts);
        if (args.length < 1) {
            this.printHelpMessage(printOpts);
            return -1;
        }
        if (args[0].equals("-help")) {
            this.printHelpMessage(printOpts);
            return 0;
        }
        GnuParser parser = new GnuParser();
        String appIdStr = null;
        String clusterIdStr = null;
        String containerIdStr = null;
        String nodeAddress = null;
        String appOwner = null;
        boolean getAMContainerLogs = false;
        boolean nodesList = false;
        boolean showApplicationLogInfo = false;
        boolean showContainerLogInfo = false;
        boolean useRegex = false;
        String[] logFiles = null;
        String[] logFilesRegex = null;
        ArrayList<String> amContainersList = new ArrayList();
        String localDir = null;
        long bytes = Long.MAX_VALUE;
        boolean ignoreSizeLimit = false;
        int maxRetries = 30;
        long retryInterval = 1000L;
        try {
            CommandLine commandLine = parser.parse(opts, args, false);
            appIdStr = commandLine.getOptionValue(APPLICATION_ID_OPTION);
            containerIdStr = commandLine.getOptionValue(CONTAINER_ID_OPTION);
            nodeAddress = commandLine.getOptionValue(NODE_ADDRESS_OPTION);
            appOwner = commandLine.getOptionValue(APP_OWNER_OPTION);
            getAMContainerLogs = commandLine.hasOption(AM_CONTAINER_OPTION);
            nodesList = commandLine.hasOption(LIST_NODES_OPTION);
            localDir = commandLine.getOptionValue(OUT_OPTION);
            showApplicationLogInfo = commandLine.hasOption(SHOW_APPLICATION_LOG_INFO);
            showContainerLogInfo = commandLine.hasOption(SHOW_CONTAINER_LOG_INFO);
            if (getAMContainerLogs) {
                try {
                    amContainersList = this.parseAMContainer(commandLine, printOpts);
                }
                catch (NumberFormatException ex) {
                    System.err.println(ex.getMessage());
                    return -1;
                }
            }
            if (commandLine.hasOption(CLUSTER_ID_OPTION)) {
                clusterIdStr = commandLine.getOptionValue(CLUSTER_ID_OPTION);
                this.getConf().set("yarn.resourcemanager.cluster-id", clusterIdStr);
            }
            if (commandLine.hasOption(PER_CONTAINER_LOG_FILES_OPTION)) {
                logFiles = commandLine.getOptionValues(PER_CONTAINER_LOG_FILES_OPTION);
            } else if (commandLine.hasOption(PER_CONTAINER_LOG_FILES_OLD_OPTION)) {
                logFiles = commandLine.getOptionValues(PER_CONTAINER_LOG_FILES_OLD_OPTION);
            }
            if (commandLine.hasOption(PER_CONTAINER_LOG_FILES_REGEX_OPTION)) {
                logFilesRegex = commandLine.getOptionValues(PER_CONTAINER_LOG_FILES_REGEX_OPTION);
                useRegex = true;
            }
            if (commandLine.hasOption(SIZE_OPTION)) {
                bytes = Long.parseLong(commandLine.getOptionValue(SIZE_OPTION));
            }
            if (commandLine.hasOption(CLIENT_MAX_RETRY_OPTION)) {
                maxRetries = Integer.parseInt(commandLine.getOptionValue(CLIENT_MAX_RETRY_OPTION));
            }
            if (commandLine.hasOption(CLIENT_RETRY_INTERVAL_OPTION)) {
                retryInterval = Long.parseLong(commandLine.getOptionValue(CLIENT_RETRY_INTERVAL_OPTION));
            }
            if (commandLine.hasOption(SIZE_LIMIT_OPTION)) {
                this.specifedLogLimits = Long.parseLong(commandLine.getOptionValue(SIZE_LIMIT_OPTION));
                this.logSizeLeft = this.specifedLogLimits * 1024L * 1024L;
            }
            if (this.logSizeLeft < 0L) {
                ignoreSizeLimit = true;
            }
        }
        catch (ParseException e) {
            System.err.println("options parsing failed: " + e.getMessage());
            this.printHelpMessage(printOpts);
            return -1;
        }
        if (appIdStr == null && containerIdStr == null) {
            System.err.println("Both applicationId and containerId are missing,  one of them must be specified.");
            this.printHelpMessage(printOpts);
            return -1;
        }
        ApplicationId appId = null;
        if (appIdStr != null) {
            try {
                appId = ApplicationId.fromString(appIdStr);
            }
            catch (Exception e) {
                System.err.println("Invalid ApplicationId specified");
                return -1;
            }
        }
        if (containerIdStr != null) {
            try {
                ContainerId containerId = ContainerId.fromString(containerIdStr);
                if (appId == null) {
                    appId = containerId.getApplicationAttemptId().getApplicationId();
                } else if (!containerId.getApplicationAttemptId().getApplicationId().equals(appId)) {
                    System.err.println("The Application:" + appId + " does not have the container:" + containerId);
                    return -1;
                }
            }
            catch (Exception e) {
                System.err.println("Invalid ContainerId specified");
                return -1;
            }
        }
        if (showApplicationLogInfo && showContainerLogInfo) {
            System.err.println("Invalid options. Can only accept one of show_application_log_info/show_container_log_info.");
            return -1;
        }
        if (logFiles != null && logFiles.length > 0 && logFilesRegex != null && logFilesRegex.length > 0) {
            System.err.println("Invalid options. Can only accept one of log_files/log_files_pattern.");
            return -1;
        }
        if (localDir != null && (file = new File(localDir)).exists() && file.isFile()) {
            System.err.println("Invalid value for -out option. Please provide a directory.");
            return -1;
        }
        this.connectionRetry = new ClientConnectionRetry(maxRetries, retryInterval);
        ClientJerseyRetryFilter retryFilter = new ClientJerseyRetryFilter();
        this.webServiceClient.addFilter((ClientFilter)retryFilter);
        LogCLIHelpers logCliHelper = new LogCLIHelpers();
        logCliHelper.setConf(this.getConf());
        this.yarnClient = this.createYarnClient();
        YarnApplicationState appState = YarnApplicationState.NEW;
        ApplicationReport appReport = null;
        try {
            appReport = this.getApplicationReport(appId);
            appState = appReport.getYarnApplicationState();
            if (appState == YarnApplicationState.NEW || appState == YarnApplicationState.NEW_SAVING || appState == YarnApplicationState.SUBMITTED) {
                System.err.println("Logs are not available right now.");
                return -1;
            }
        }
        catch (IOException | YarnException e) {
            appState = YarnApplicationState.FINISHED;
            System.err.println("Unable to get ApplicationState. Attempting to fetch logs directly from the filesystem.");
        }
        if ((appOwner == null || appOwner.isEmpty()) && (appOwner = this.guessAppOwner(appReport, appId)) == null) {
            System.err.println("Can not find the appOwner. Please specify the correct appOwner");
            System.err.println("Could not locate application logs for " + appId);
            return -1;
        }
        HashSet<String> logs = new HashSet<String>();
        if (this.fetchAllLogFiles(logFiles, logFilesRegex)) {
            logs.add("ALL");
        } else if (logFiles != null && logFiles.length > 0) {
            logs.addAll(Arrays.asList(logFiles));
        } else if (logFilesRegex != null && logFilesRegex.length > 0) {
            logs.addAll(Arrays.asList(logFilesRegex));
        }
        ContainerLogsRequest request = new ContainerLogsRequest(appId, null, Apps.isApplicationFinalState(appState), appOwner, nodeAddress, null, containerIdStr, localDir, logs, bytes, null);
        if (showContainerLogInfo) {
            return this.showContainerLogInfo(request, logCliHelper);
        }
        if (nodesList) {
            return this.showNodeLists(request, logCliHelper);
        }
        if (showApplicationLogInfo) {
            return this.showApplicationLogInfo(request, logCliHelper);
        }
        if (getAMContainerLogs) {
            return this.fetchAMContainerLogs(request, amContainersList, logCliHelper, useRegex, ignoreSizeLimit);
        }
        int resultCode = 0;
        if (containerIdStr != null) {
            return this.fetchContainerLogs(request, logCliHelper, useRegex, ignoreSizeLimit);
        }
        if (nodeAddress == null) {
            resultCode = this.fetchApplicationLogs(request, logCliHelper, useRegex, ignoreSizeLimit);
        } else {
            System.err.println("Should at least provide ContainerId!");
            this.printHelpMessage(printOpts);
            resultCode = -1;
        }
        return resultCode;
    }

    private ApplicationReport getApplicationReport(ApplicationId appId) throws IOException, YarnException {
        return this.yarnClient.getApplicationReport(appId);
    }

    @VisibleForTesting
    protected YarnClient createYarnClient() {
        YarnClient client = YarnClient.createYarnClient();
        client.init(this.getConf());
        client.start();
        return client;
    }

    public static void main(String[] args) throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        LogsCLI logDumper = new LogsCLI();
        logDumper.setConf(conf);
        WebServiceClient.initialize(conf);
        int exitCode = logDumper.run(args);
        WebServiceClient.destroy();
        System.exit(exitCode);
    }

    private void printHelpMessage(Options options) {
        this.outStream.println("Retrieve logs for YARN applications.");
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("yarn logs -applicationId <application ID> [OPTIONS]", new Options());
        formatter.setSyntaxPrefix("");
        formatter.printHelp("general options are:", options);
    }

    protected List<JSONObject> getAMContainerInfoForRMWebService(Configuration conf, String appId) throws Exception {
        return WebAppUtils.execOnActiveRM(conf, this::getAMContainerInfoFromRM, appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JSONObject> getAMContainerInfoFromRM(String webAppAddress, String appId) throws ClientHandlerException, UniformInterfaceException, JSONException {
        ArrayList<JSONObject> amContainersList = new ArrayList<JSONObject>();
        try (ClientResponse response = null;){
            WebResource.Builder builder = this.webServiceClient.resource(webAppAddress).path("ws").path("v1").path("cluster").path("apps").path(appId).path("appattempts").accept(new String[]{"application/json"});
            response = (ClientResponse)builder.get(ClientResponse.class);
            JSONObject json = ((JSONObject)response.getEntity(JSONObject.class)).getJSONObject("appAttempts");
            JSONArray requests = json.getJSONArray("appAttempt");
            for (int j = 0; j < requests.length(); ++j) {
                amContainersList.add(requests.getJSONObject(j));
            }
            ArrayList<JSONObject> arrayList = amContainersList;
            return arrayList;
        }
    }

    private List<JSONObject> getAMContainerInfoForAHSWebService(Configuration conf, String appId) throws ClientHandlerException, UniformInterfaceException, JSONException {
        String webAppAddress = WebAppUtils.getHttpSchemePrefix(conf) + WebAppUtils.getAHSWebAppURLWithoutScheme(conf);
        WebResource webResource = this.webServiceClient.resource(webAppAddress);
        ClientResponse response = (ClientResponse)webResource.path("ws").path("v1").path("applicationhistory").path("apps").path(appId).path("appattempts").accept(new String[]{"application/json"}).get(ClientResponse.class);
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONArray requests = json.getJSONArray("appAttempt");
        ArrayList<JSONObject> amContainersList = new ArrayList<JSONObject>();
        for (int i = 0; i < requests.length(); ++i) {
            amContainersList.add(requests.getJSONObject(i));
        }
        Collections.reverse(amContainersList);
        return amContainersList;
    }

    private boolean fetchAllLogFiles(String[] logFiles, String[] logFilesRegex) {
        List<String> logsRegex;
        List<String> logs;
        if (!(logFiles != null && logFiles.length != 0 || logFilesRegex != null && logFilesRegex.length != 0)) {
            return true;
        }
        if (logFiles != null && logFiles.length > 0 && ((logs = Arrays.asList(logFiles)).contains("ALL") || logs.contains("*"))) {
            return true;
        }
        return logFilesRegex != null && logFilesRegex.length > 0 && (logsRegex = Arrays.asList(logFilesRegex)).contains(".*");
    }

    private List<Pair<ContainerLogFileInfo, String>> getContainerLogFiles(Configuration conf, String containerIdStr, String nodeHttpAddress) throws IOException {
        ArrayList<Pair<ContainerLogFileInfo, String>> logFileInfos;
        block12: {
            logFileInfos = new ArrayList<Pair<ContainerLogFileInfo, String>>();
            try {
                WebResource webResource = this.webServiceClient.resource(WebAppUtils.getHttpSchemePrefix(conf) + nodeHttpAddress);
                ClientResponse response = (ClientResponse)webResource.path("ws").path("v1").path("node").path("containers").path(containerIdStr).path("logs").accept(new String[]{"application/json"}).get(ClientResponse.class);
                if (response.getStatusInfo().getStatusCode() != ClientResponse.Status.OK.getStatusCode()) break block12;
                try {
                    JSONArray array = new JSONArray();
                    JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                    if (!json.has("containerLogsInfo")) {
                        return logFileInfos;
                    }
                    Object logsInfoObj = json.get("containerLogsInfo");
                    if (logsInfoObj instanceof JSONObject) {
                        array.put((Object)((JSONObject)logsInfoObj));
                    } else if (logsInfoObj instanceof JSONArray) {
                        JSONArray logsArray = (JSONArray)logsInfoObj;
                        for (int i = 0; i < logsArray.length(); ++i) {
                            array.put((Object)logsArray.getJSONObject(i));
                        }
                    }
                    for (int i = 0; i < array.length(); ++i) {
                        String aggregateType;
                        JSONObject log = array.getJSONObject(i);
                        String string = aggregateType = log.has("logAggregationType") ? log.getString("logAggregationType") : "N/A";
                        if (!log.has("containerLogInfo")) continue;
                        Object ob = log.get("containerLogInfo");
                        if (ob instanceof JSONArray) {
                            JSONArray obArray = (JSONArray)ob;
                            for (int j = 0; j < obArray.length(); ++j) {
                                logFileInfos.add((Pair<ContainerLogFileInfo, String>)new Pair((Object)this.generatePerContainerLogFileInfoFromJSON(obArray.getJSONObject(j)), (Object)aggregateType));
                            }
                            continue;
                        }
                        if (!(ob instanceof JSONObject)) continue;
                        logFileInfos.add((Pair<ContainerLogFileInfo, String>)new Pair((Object)this.generatePerContainerLogFileInfoFromJSON((JSONObject)ob), (Object)aggregateType));
                    }
                }
                catch (Exception e) {
                    System.err.println("Unable to parse json from webservice. Error:");
                    System.err.println(e.getMessage());
                    throw new IOException(e);
                }
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                System.err.println("Unable to fetch log files list");
                throw new IOException(ex);
            }
        }
        return logFileInfos;
    }

    private ContainerLogFileInfo generatePerContainerLogFileInfoFromJSON(JSONObject meta) throws JSONException {
        String fileName = meta.has("fileName") ? meta.getString("fileName") : "N/A";
        String fileSize = meta.has("fileSize") ? meta.getString("fileSize") : "N/A";
        String lastModificationTime = meta.has("lastModifiedTime") ? meta.getString("lastModifiedTime") : "N/A";
        return new ContainerLogFileInfo(fileName, fileSize, lastModificationTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public int printContainerLogsFromRunningApplication(Configuration conf, ContainerLogsRequest request, LogCLIHelpers logCliHelper, boolean useRegex, boolean ignoreSizeLimit) throws IOException {
        String containerIdStr = request.getContainerId().toString();
        String localDir = request.getOutputLocalDir();
        String nodeId = request.getNodeId();
        PrintStream out = LogToolUtils.createPrintStream(localDir, nodeId, containerIdStr);
        try {
            boolean foundAnyLogs = false;
            byte[] buffer = new byte[65536];
            for (String logFile : request.getLogTypes()) {
                InputStream is = null;
                try {
                    ClientResponse response = this.getResponseFromNMWebService(conf, this.webServiceClient, request, logFile);
                    if (response != null && response.getStatusInfo().getStatusCode() == ClientResponse.Status.OK.getStatusCode()) {
                        is = response.getEntityInputStream();
                        int len = 0;
                        while ((len = is.read(buffer)) != -1) {
                            out.write(buffer, 0, len);
                        }
                        out.println();
                    } else {
                        out.println("Can not get any logs for the log file: " + logFile);
                        String msg = "Response from the NodeManager:" + nodeId + " WebService is " + (response == null ? "null" : "not successful, HTTP error code: " + response.getStatus() + ", Server response:\n" + (String)response.getEntity(String.class));
                        out.println(msg);
                    }
                    out.flush();
                    foundAnyLogs = true;
                }
                catch (ClientHandlerException | UniformInterfaceException ex) {
                    try {
                        System.err.println("Can not find the log file:" + logFile + " for the container:" + containerIdStr + " in NodeManager:" + nodeId);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    continue;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            if (foundAnyLogs) {
                int n = 0;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            logCliHelper.closePrintStream(out);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public ContainerReport getContainerReport(String containerIdStr) throws YarnException, IOException {
        return this.yarnClient.getContainerReport(ContainerId.fromString(containerIdStr));
    }

    private int printAMContainerLogs(Configuration conf, ContainerLogsRequest request, List<String> amContainers, LogCLIHelpers logCliHelper, boolean useRegex, boolean ignoreSizeLimit) throws Exception {
        StringBuilder errorMessage;
        String appId;
        boolean getAMContainerLists;
        ArrayList<ContainerLogsRequest> requests;
        block19: {
            List<JSONObject> amContainersList = null;
            requests = new ArrayList<ContainerLogsRequest>();
            getAMContainerLists = false;
            appId = request.getAppId().toString();
            errorMessage = new StringBuilder();
            try {
                amContainersList = this.getAMContainerInfoForRMWebService(conf, appId);
                if (amContainersList != null && !amContainersList.isEmpty()) {
                    getAMContainerLists = true;
                    for (JSONObject amContainer : amContainersList) {
                        ContainerLogsRequest amRequest = new ContainerLogsRequest(request);
                        amRequest.setContainerId(amContainer.getString(CONTAINER_ID_OPTION));
                        String httpAddress = amContainer.getString("nodeHttpAddress");
                        if (httpAddress != null && !httpAddress.isEmpty()) {
                            amRequest.setNodeHttpAddress(httpAddress);
                        }
                        amRequest.setNodeId(amContainer.getString("nodeId"));
                        requests.add(amRequest);
                    }
                }
            }
            catch (Exception ex) {
                errorMessage.append(ex.getMessage() + "\n");
                if (!request.isAppFinished()) break block19;
                if (!conf.getBoolean("yarn.timeline-service.enabled", false)) {
                    errorMessage.append("Please enable the timeline service and make sure the timeline server is running.");
                }
                try {
                    if (YarnConfiguration.timelineServiceV2Enabled(conf)) {
                        try {
                            amContainersList = this.getAMContainerInfoFromTimelineReader(conf, appId);
                            getAMContainerLists = this.createContainerLogsRequestForMasterContainer(requests, request, amContainersList, "YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER");
                        }
                        catch (Exception e) {
                            System.err.println("Unable to get AM container informations from TimelineReader for the application:" + appId);
                            if (YarnConfiguration.timelineServiceV1Enabled(conf) || YarnConfiguration.timelineServiceV15Enabled(conf)) {
                                getAMContainerLists = this.getAMContainerInfoForAHSWebService(conf, appId, requests, request);
                                break block19;
                            }
                            throw e;
                        }
                    }
                    getAMContainerLists = this.getAMContainerInfoForAHSWebService(conf, appId, requests, request);
                }
                catch (Exception e) {
                    errorMessage.append(e.getMessage());
                }
            }
        }
        if (!getAMContainerLists) {
            System.err.println("Unable to get AM container informations for the application:" + appId);
            System.err.println(errorMessage);
            System.err.println("Can not get AMContainers logs for the application:" + appId + " with the appOwner:" + request.getAppOwner());
            return -1;
        }
        ArrayList<ContainerLogsRequest> candidates = new ArrayList<ContainerLogsRequest>();
        if (amContainers.contains("ALL")) {
            candidates.addAll(requests);
            this.outStream.println();
            this.outStream.println("Specified ALL for -am option. Printed logs for all am containers.");
        } else {
            for (String amContainer : amContainers) {
                int amContainerId = Integer.parseInt(amContainer.trim());
                if (amContainerId == -1) {
                    candidates.add((ContainerLogsRequest)requests.get(requests.size() - 1));
                    continue;
                }
                if (amContainerId <= requests.size()) {
                    candidates.add((ContainerLogsRequest)requests.get(amContainerId - 1));
                    continue;
                }
                System.err.println(String.format("ERROR: Specified AM containerId (%s) exceeds the number of AM containers (%s).", amContainerId, requests.size()));
                return -1;
            }
        }
        Map<Object, Object> newOptions = new HashMap();
        newOptions = request.isAppFinished() ? this.getMatchedLogTypesForFinishedApp(candidates, logCliHelper, useRegex, ignoreSizeLimit) : this.getMatchedLogTypesForRunningApp(candidates, useRegex, ignoreSizeLimit);
        for (Map.Entry<Object, Object> amRequest : newOptions.entrySet()) {
            this.outputAMContainerLogs((ContainerLogsRequest)amRequest.getValue(), conf, logCliHelper, useRegex, ignoreSizeLimit);
        }
        return 0;
    }

    private boolean getAMContainerInfoForAHSWebService(Configuration conf, String appId, List<ContainerLogsRequest> requests, ContainerLogsRequest request) throws JSONException {
        List<JSONObject> amContainersList = this.getAMContainerInfoForAHSWebService(conf, appId);
        return this.createContainerLogsRequestForMasterContainer(requests, request, amContainersList, "amContainerId");
    }

    private boolean createContainerLogsRequestForMasterContainer(List<ContainerLogsRequest> requests, ContainerLogsRequest request, List<JSONObject> amContainersList, String masterContainerInfo) throws JSONException {
        boolean getAMContainerLists = false;
        if (amContainersList != null && !amContainersList.isEmpty()) {
            getAMContainerLists = true;
            for (JSONObject amContainer : amContainersList) {
                ContainerLogsRequest amRequest = new ContainerLogsRequest(request);
                amRequest.setContainerId(amContainer.getString(masterContainerInfo));
                requests.add(amRequest);
            }
        }
        return getAMContainerLists;
    }

    private List<JSONObject> getAMContainerInfoFromTimelineReader(Configuration conf, String appId) throws IOException, ClientHandlerException, UniformInterfaceException, JSONException {
        ClientResponse response = this.getClientResponseFromTimelineReader(conf, appId);
        JSONArray appAttemptEntities = (JSONArray)response.getEntity(JSONArray.class);
        ArrayList<JSONObject> amContainersList = new ArrayList<JSONObject>();
        for (int i = 0; i < appAttemptEntities.length(); ++i) {
            JSONObject appAttemptEntity = appAttemptEntities.getJSONObject(i);
            JSONObject infoField = appAttemptEntity.getJSONObject("info");
            amContainersList.add(infoField);
        }
        Collections.reverse(amContainersList);
        return amContainersList;
    }

    protected ClientResponse getClientResponseFromTimelineReader(Configuration conf, String appId) throws IOException {
        String webAppAddress = WebAppUtils.getHttpSchemePrefix(conf) + WebAppUtils.getTimelineReaderWebAppURLWithoutScheme(conf);
        WebResource webResource = this.webServiceClient.resource(webAppAddress);
        ClientResponse response = (ClientResponse)webResource.path("ws").path("v2").path("timeline").path("clusters").path(conf.get("yarn.resourcemanager.cluster-id")).path("apps").path(appId).path("entities").path(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString()).queryParam("fields", "INFO").accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (response == null || response.getStatusInfo().getStatusCode() != ClientResponse.Status.OK.getStatusCode()) {
            String msg = "Response from the timeline reader server is " + (response == null ? "null" : "not successful, HTTP error code: " + response.getStatus() + ", Server response:\n" + (String)response.getEntity(String.class));
            System.out.println(msg);
            throw new IOException(msg);
        }
        return response;
    }

    private void outputAMContainerLogs(ContainerLogsRequest request, Configuration conf, LogCLIHelpers logCliHelper, boolean useRegex, boolean ignoreSizeLimit) throws Exception {
        String nodeHttpAddress = request.getNodeHttpAddress();
        String containerId = request.getContainerId();
        String nodeId = request.getNodeId();
        if (request.isAppFinished()) {
            if (containerId != null && !containerId.isEmpty()) {
                if (nodeId != null && !nodeId.isEmpty()) {
                    logCliHelper.dumpAContainerLogsForLogType(request);
                } else {
                    logCliHelper.dumpAContainerLogsForLogTypeWithoutNodeId(request);
                }
            }
        } else if (nodeHttpAddress != null && containerId != null && !nodeHttpAddress.isEmpty() && !containerId.isEmpty()) {
            ContainerState containerState = this.getContainerReport(containerId).getContainerState();
            request.setContainerState(containerState);
            this.printContainerLogsFromRunningApplication(conf, request, logCliHelper, useRegex, ignoreSizeLimit);
        }
    }

    private int showContainerLogInfo(ContainerLogsRequest request, LogCLIHelpers logCliHelper) throws IOException, YarnException, ClientHandlerException, UniformInterfaceException, JSONException {
        if (!request.isAppFinished()) {
            return this.printContainerInfoFromRunningApplication(request, logCliHelper);
        }
        return logCliHelper.printAContainerLogMetadata(request, System.out, System.err);
    }

    private int showNodeLists(ContainerLogsRequest request, LogCLIHelpers logCliHelper) throws IOException {
        if (!request.isAppFinished()) {
            System.err.println("The -list_nodes command can be only used with finished applications");
            return -1;
        }
        logCliHelper.printNodesList(request, System.out, System.err);
        return 0;
    }

    private int showApplicationLogInfo(ContainerLogsRequest request, LogCLIHelpers logCliHelper) throws IOException, YarnException {
        String appState = "Application State: " + (request.isAppFinished() ? "Completed." : "Running.");
        if (!request.isAppFinished()) {
            List<ContainerReport> reports = this.getContainerReportsFromRunningApplication(request);
            List<ContainerReport> filterReports = this.filterContainersInfo(request, reports);
            if (filterReports.isEmpty()) {
                System.err.println("Can not find any containers for the application:" + request.getAppId() + ".");
                return -1;
            }
            this.outStream.println(appState);
            for (ContainerReport report : filterReports) {
                this.outStream.println(String.format("Container: %s on %s", report.getContainerId(), report.getAssignedNode()));
            }
            return 0;
        }
        this.outStream.println(appState);
        logCliHelper.printContainersList(request, System.out, System.err);
        return 0;
    }

    private Options createCommandOpts() {
        Options opts = new Options();
        opts.addOption(HELP_CMD, false, "Displays help for all commands.");
        Option appIdOpt = new Option(APPLICATION_ID_OPTION, true, "ApplicationId (required)");
        opts.addOption(appIdOpt);
        opts.addOption(CONTAINER_ID_OPTION, true, "ContainerId. By default, it will print all available logs. Work with -log_files to get only specific logs. If specified, the applicationId can be omitted");
        opts.addOption(CLUSTER_ID_OPTION, true, "ClusterId. By default, it will take default cluster id from the RM");
        opts.addOption(NODE_ADDRESS_OPTION, true, "NodeAddress in the format nodename:port");
        opts.addOption(APP_OWNER_OPTION, true, "AppOwner (assumed to be current user if not specified)");
        Option amOption = new Option(AM_CONTAINER_OPTION, true, "Prints the AM Container logs for this application. Specify comma-separated value to get logs for related AM Container. For example, If we specify -am 1,2, we will get the logs for the first AM Container as well as the second AM Container. To get logs for all AM Containers, use -am ALL. To get logs for the latest AM Container, use -am -1. By default, it will print all available logs. Work with -log_files to get only specific logs.");
        amOption.setValueSeparator(',');
        amOption.setArgs(-2);
        amOption.setArgName("AM Containers");
        opts.addOption(amOption);
        Option logFileOpt = new Option(PER_CONTAINER_LOG_FILES_OPTION, true, "Specify comma-separated value to get exact matched log files. Use \"ALL\" or \"*\" to fetch all the log files for the container.");
        logFileOpt.setValueSeparator(',');
        logFileOpt.setArgs(-2);
        logFileOpt.setArgName("Log File Name");
        opts.addOption(logFileOpt);
        Option oldLogFileOpt = new Option(PER_CONTAINER_LOG_FILES_OLD_OPTION, true, "Deprecated name for log_files, please use log_files option instead");
        oldLogFileOpt.setValueSeparator(',');
        oldLogFileOpt.setArgs(-2);
        oldLogFileOpt.setArgName("Log File Name");
        opts.addOption(oldLogFileOpt);
        Option logFileRegexOpt = new Option(PER_CONTAINER_LOG_FILES_REGEX_OPTION, true, "Specify comma-separated value to get matched log files by using java regex. Use \".*\" to fetch all the log files for the container.");
        logFileRegexOpt.setValueSeparator(',');
        logFileRegexOpt.setArgs(-2);
        logFileRegexOpt.setArgName("Log File Pattern");
        opts.addOption(logFileRegexOpt);
        opts.addOption(SHOW_CONTAINER_LOG_INFO, false, "Show the container log metadata, including log-file names, the size of the log files. You can combine this with --containerId to get log metadata for the specific container, or with --nodeAddress to get log metadata for all the containers on the specific NodeManager.");
        opts.addOption(SHOW_APPLICATION_LOG_INFO, false, "Show the containerIds which belong to the specific Application. You can combine this with --nodeAddress to get containerIds for all the containers on the specific NodeManager.");
        opts.addOption(LIST_NODES_OPTION, false, "Show the list of nodes that successfully aggregated logs. This option can only be used with finished applications.");
        opts.addOption(OUT_OPTION, true, "Local directory for storing individual container logs. The container logs will be stored based on the node the container ran on.");
        opts.addOption(SIZE_OPTION, true, "Prints the log file's first 'n' bytes or the last 'n' bytes. Use negative values as bytes to read from the end and positive values as bytes to read from the beginning.");
        opts.addOption(CLIENT_MAX_RETRY_OPTION, true, "Set max retry number for a retry client to get the container logs for the running applications. Use a negative value to make retry forever. The default value is 30.");
        opts.addOption(CLIENT_RETRY_INTERVAL_OPTION, true, "Work with --client_max_retries to create a retry client. The default value is 1000.");
        opts.addOption(SIZE_LIMIT_OPTION, true, "Use this option to limit the size of the total logs which could be fetched. By default, we only allow to fetch at most 10240 MB logs. If the total log size is larger than the specified number, the CLI would fail. The user could specify -1 to ignore the size limit and fetch all logs.");
        opts.getOption(APPLICATION_ID_OPTION).setArgName("Application ID");
        opts.getOption(CONTAINER_ID_OPTION).setArgName("Container ID");
        opts.getOption(CLUSTER_ID_OPTION).setArgName("Cluster ID");
        opts.getOption(NODE_ADDRESS_OPTION).setArgName("Node Address");
        opts.getOption(APP_OWNER_OPTION).setArgName("Application Owner");
        opts.getOption(AM_CONTAINER_OPTION).setArgName("AM Containers");
        opts.getOption(OUT_OPTION).setArgName("Local Directory");
        opts.getOption(SIZE_OPTION).setArgName(SIZE_OPTION);
        opts.getOption(CLIENT_MAX_RETRY_OPTION).setArgName("Max Retries");
        opts.getOption(CLIENT_RETRY_INTERVAL_OPTION).setArgName("Retry Interval");
        opts.getOption(SIZE_LIMIT_OPTION).setArgName("Size Limit");
        return opts;
    }

    private Options createPrintOpts(Options commandOpts) {
        Options printOpts = new Options();
        printOpts.addOption(commandOpts.getOption(HELP_CMD));
        printOpts.addOption(commandOpts.getOption(CONTAINER_ID_OPTION));
        printOpts.addOption(commandOpts.getOption(CLUSTER_ID_OPTION));
        printOpts.addOption(commandOpts.getOption(NODE_ADDRESS_OPTION));
        printOpts.addOption(commandOpts.getOption(APP_OWNER_OPTION));
        printOpts.addOption(commandOpts.getOption(AM_CONTAINER_OPTION));
        printOpts.addOption(commandOpts.getOption(PER_CONTAINER_LOG_FILES_OPTION));
        printOpts.addOption(commandOpts.getOption(LIST_NODES_OPTION));
        printOpts.addOption(commandOpts.getOption(SHOW_APPLICATION_LOG_INFO));
        printOpts.addOption(commandOpts.getOption(SHOW_CONTAINER_LOG_INFO));
        printOpts.addOption(commandOpts.getOption(OUT_OPTION));
        printOpts.addOption(commandOpts.getOption(SIZE_OPTION));
        printOpts.addOption(commandOpts.getOption(PER_CONTAINER_LOG_FILES_REGEX_OPTION));
        printOpts.addOption(commandOpts.getOption(CLIENT_MAX_RETRY_OPTION));
        printOpts.addOption(commandOpts.getOption(CLIENT_RETRY_INTERVAL_OPTION));
        printOpts.addOption(commandOpts.getOption(SIZE_LIMIT_OPTION));
        return printOpts;
    }

    private List<String> parseAMContainer(CommandLine commandLine, Options printOpts) throws NumberFormatException {
        String[] amContainers;
        ArrayList<String> amContainersList = new ArrayList<String>();
        for (String am : amContainers = commandLine.getOptionValues(AM_CONTAINER_OPTION)) {
            boolean errorInput = false;
            if (am.trim().equalsIgnoreCase("ALL")) {
                amContainersList.add("ALL");
                break;
            }
            try {
                int id = Integer.parseInt(am.trim());
                if (id != -1 && id <= 0) {
                    errorInput = true;
                }
            }
            catch (NumberFormatException ex) {
                errorInput = true;
            }
            if (errorInput) {
                String errMessage = "Invalid input for option -am. Valid inputs are 'ALL', -1 and any other integer which is larger than 0.";
                this.printHelpMessage(printOpts);
                throw new NumberFormatException(errMessage);
            }
            amContainersList.add(am.trim());
        }
        return amContainersList;
    }

    private int fetchAMContainerLogs(ContainerLogsRequest request, List<String> amContainersList, LogCLIHelpers logCliHelper, boolean useRegex, boolean ignoreSizeLimit) throws Exception {
        return this.printAMContainerLogs(this.getConf(), request, amContainersList, logCliHelper, useRegex, ignoreSizeLimit);
    }

    private int fetchContainerLogs(ContainerLogsRequest request, LogCLIHelpers logCliHelper, boolean useRegex, boolean ignoreSizeLimit) throws IOException, ClientHandlerException, UniformInterfaceException, JSONException {
        String appIdStr = request.getAppId().toString();
        String containerIdStr = request.getContainerId();
        String nodeAddress = request.getNodeId();
        String appOwner = request.getAppOwner();
        boolean isAppFinished = request.isAppFinished();
        if (isAppFinished) {
            ContainerLogsRequest newOptions = this.getMatchedLogOptions(request, logCliHelper, useRegex, ignoreSizeLimit);
            if (newOptions == null) {
                System.err.println("Can not find any log file matching the pattern: " + request.getLogTypes() + " for the container: " + request.getContainerId() + " within the application: " + request.getAppId());
                return -1;
            }
            if (nodeAddress != null && !nodeAddress.isEmpty()) {
                return logCliHelper.dumpAContainerLogsForLogType(newOptions);
            }
            return logCliHelper.dumpAContainerLogsForLogTypeWithoutNodeId(newOptions);
        }
        String nodeHttpAddress = null;
        String nodeId = null;
        try {
            ContainerReport report = this.getContainerReport(containerIdStr);
            nodeHttpAddress = report.getNodeHttpAddress();
            if (nodeHttpAddress != null && !nodeHttpAddress.isEmpty()) {
                nodeHttpAddress = nodeHttpAddress.replaceFirst(WebAppUtils.getHttpSchemePrefix(this.getConf()), "");
                request.setNodeHttpAddress(nodeHttpAddress);
            }
            nodeId = report.getAssignedNode().toString();
            request.setNodeId(nodeId);
            request.setContainerState(report.getContainerState());
        }
        catch (IOException | YarnException ex) {
            nodeHttpAddress = this.getNodeHttpAddressFromRMWebString(request);
            if (nodeHttpAddress != null && !nodeHttpAddress.isEmpty()) {
                request.setNodeHttpAddress(nodeHttpAddress);
            }
            int result = -1;
            ContainerLogsRequest newOptions = this.getMatchedLogOptions(request, logCliHelper, useRegex, ignoreSizeLimit);
            if (newOptions == null) {
                System.err.println("Can not find any log file matching the pattern: " + request.getLogTypes() + " for the container: " + request.getContainerId() + " within the application: " + request.getAppId());
            } else {
                result = nodeAddress != null && !nodeAddress.isEmpty() ? logCliHelper.dumpAContainerLogsForLogType(newOptions) : logCliHelper.dumpAContainerLogsForLogTypeWithoutNodeId(newOptions);
            }
            if (result == -1) {
                System.err.println("Unable to get logs for this container:" + containerIdStr + " for the application:" + appIdStr + " with the appOwner: " + appOwner);
                System.err.println("The application: " + appIdStr + " is still running, and we can not get Container report for the container: " + containerIdStr + ". Please try later or after the application finishes.");
            }
            return result;
        }
        ContainerLogsRequest newRequest = this.getMatchedOptionForRunningApp(request, useRegex, ignoreSizeLimit);
        if (newRequest == null) {
            return -1;
        }
        return this.printContainerLogsFromRunningApplication(this.getConf(), request, logCliHelper, useRegex, ignoreSizeLimit);
    }

    private int fetchApplicationLogs(ContainerLogsRequest options, LogCLIHelpers logCliHelper, boolean useRegex, boolean ignoreSizeLimit) throws IOException, YarnException {
        int resultCode = -1;
        if (options.isAppFinished()) {
            ContainerLogsRequest newOptions = this.getMatchedLogOptions(options, logCliHelper, useRegex, ignoreSizeLimit);
            if (newOptions == null) {
                System.err.println("Can not find any log file matching the pattern: " + options.getLogTypes() + " for the application: " + options.getAppId());
            } else {
                resultCode = logCliHelper.dumpAllContainersLogs(newOptions);
            }
        } else {
            List<ContainerLogsRequest> containerLogRequests = this.getContainersLogRequestForRunningApplication(options);
            Map<String, ContainerLogsRequest> matchedLogTypes = this.getMatchedLogTypesForRunningApp(containerLogRequests, useRegex, ignoreSizeLimit);
            for (Map.Entry<String, ContainerLogsRequest> container : matchedLogTypes.entrySet()) {
                int result = this.printContainerLogsFromRunningApplication(this.getConf(), container.getValue(), logCliHelper, useRegex, ignoreSizeLimit);
                if (result != 0) continue;
                resultCode = 0;
            }
        }
        if (resultCode == -1) {
            System.err.println("Can not find the logs for the application: " + options.getAppId() + " with the appOwner: " + options.getAppOwner());
        }
        return resultCode;
    }

    private String guessAppOwner(ApplicationReport appReport, ApplicationId appId) throws IOException {
        String appOwner = null;
        if (appReport != null) {
            appOwner = appReport.getUser();
        } else {
            appOwner = UserGroupInformation.getCurrentUser().getShortUserName();
            appOwner = LogCLIHelpers.getOwnerForAppIdOrNull(appId, appOwner, this.getConf());
        }
        return appOwner;
    }

    private ContainerLogsRequest getMatchedLogOptions(ContainerLogsRequest request, LogCLIHelpers logCliHelper, boolean useRegex, boolean ignoreSizeLimit) throws IOException {
        ContainerLogsRequest newOptions = new ContainerLogsRequest(request);
        Set<ContainerLogFileInfo> files = logCliHelper.listContainerLogs(request);
        Set<String> matchedFiles = this.getMatchedLogFiles(request, files, useRegex, ignoreSizeLimit);
        if (matchedFiles.isEmpty()) {
            return null;
        }
        newOptions.setLogTypes(matchedFiles);
        return newOptions;
    }

    private Set<String> getMatchedLogFiles(ContainerLogsRequest options, Collection<ContainerLogFileInfo> candidate, boolean useRegex, boolean ignoreSizeLimit) throws IOException {
        HashSet<String> matchedFiles = new HashSet<String>();
        Set<String> filePattern = options.getLogTypes();
        long size = options.getBytes();
        boolean getAll = options.getLogTypes().contains("ALL");
        Iterator<ContainerLogFileInfo> iterator = candidate.iterator();
        while (iterator.hasNext()) {
            boolean matchedFile = false;
            ContainerLogFileInfo logInfo = iterator.next();
            if (getAll) {
                matchedFile = true;
            } else if (useRegex) {
                if (this.isFileMatching(logInfo.getFileName(), filePattern)) {
                    matchedFile = true;
                }
            } else if (filePattern.contains(logInfo.getFileName())) {
                matchedFile = true;
            }
            if (!matchedFile) continue;
            matchedFiles.add(logInfo.getFileName());
            if (ignoreSizeLimit) continue;
            this.decrLogSizeLimit(Math.min(Long.parseLong(logInfo.getFileSize()), size));
            if (this.getLogSizeLimitLeft() >= 0L) continue;
            throw new RuntimeException("The total log size is too large.The log size limit is " + this.specifedLogLimits + "MB. Please specify a proper value --size option or if you really want to fetch all, please specify -1 for --size_limit_mb option.");
        }
        return matchedFiles;
    }

    private boolean isFileMatching(String fileType, Set<String> logTypes) {
        for (String logType : logTypes) {
            Pattern filterPattern = Pattern.compile(logType);
            boolean match = filterPattern.matcher(fileType).find();
            if (!match) continue;
            return true;
        }
        return false;
    }

    private List<ContainerLogsRequest> getContainersLogRequestForRunningApplication(ContainerLogsRequest options) throws YarnException, IOException {
        ArrayList<ContainerLogsRequest> newOptionsList = new ArrayList<ContainerLogsRequest>();
        List<ContainerReport> reports = this.getContainerReportsFromRunningApplication(options);
        for (ContainerReport container : reports) {
            ContainerLogsRequest newOptions = new ContainerLogsRequest(options);
            newOptions.setContainerId(container.getContainerId().toString());
            newOptions.setNodeId(container.getAssignedNode().toString());
            String httpAddress = container.getNodeHttpAddress();
            if (httpAddress != null && !httpAddress.isEmpty()) {
                newOptions.setNodeHttpAddress(httpAddress.replaceFirst(WebAppUtils.getHttpSchemePrefix(this.getConf()), ""));
            }
            newOptions.setContainerState(container.getContainerState());
            newOptionsList.add(newOptions);
        }
        return newOptionsList;
    }

    private List<ContainerReport> getContainerReportsFromRunningApplication(ContainerLogsRequest options) throws YarnException, IOException {
        ArrayList<ContainerReport> reports = new ArrayList<ContainerReport>();
        List<ApplicationAttemptReport> attempts = this.yarnClient.getApplicationAttempts(options.getAppId());
        TreeMap<ContainerId, ContainerReport> containerMap = new TreeMap<ContainerId, ContainerReport>();
        for (ApplicationAttemptReport attempt : attempts) {
            List<ContainerReport> containers = this.yarnClient.getContainers(attempt.getApplicationAttemptId());
            for (ContainerReport container : containers) {
                if (containerMap.containsKey(container.getContainerId())) continue;
                containerMap.put(container.getContainerId(), container);
            }
        }
        reports.addAll(containerMap.values());
        return reports;
    }

    private List<ContainerReport> filterContainersInfo(ContainerLogsRequest options, List<ContainerReport> containers) {
        boolean filterBasedOnContainerId;
        ArrayList<ContainerReport> filterReports = new ArrayList<ContainerReport>(containers);
        String nodeId = options.getNodeId();
        boolean filterBasedOnNodeId = nodeId != null && !nodeId.isEmpty();
        String containerId = options.getContainerId();
        boolean bl = filterBasedOnContainerId = containerId != null && !containerId.isEmpty();
        if (filterBasedOnNodeId || filterBasedOnContainerId) {
            for (ContainerReport report : containers) {
                if (filterBasedOnContainerId && !report.getContainerId().toString().equalsIgnoreCase(containerId)) {
                    filterReports.remove(report);
                }
                if (!filterBasedOnNodeId || report.getAssignedNode().toString().equalsIgnoreCase(nodeId)) continue;
                filterReports.remove(report);
            }
        }
        return filterReports;
    }

    private int printContainerInfoFromRunningApplication(ContainerLogsRequest options, LogCLIHelpers logCliHelper) throws YarnException, IOException, ClientHandlerException, UniformInterfaceException, JSONException {
        String containerIdStr = options.getContainerId();
        String nodeIdStr = options.getNodeId();
        List<ContainerReport> reports = this.getContainerReportsFromRunningApplication(options);
        List<ContainerReport> filteredReports = this.filterContainersInfo(options, reports);
        if (filteredReports.isEmpty()) {
            String nodeHttpAddress = null;
            if (options.getContainerId() != null && !options.getContainerId().isEmpty()) {
                nodeHttpAddress = this.getNodeHttpAddressFromRMWebString(options);
            }
            if (nodeHttpAddress != null) {
                this.outputContainerLogMeta(options.getContainerId(), options.getNodeId(), nodeHttpAddress);
                return 0;
            }
            int result = logCliHelper.printAContainerLogMetadata(options, System.out, System.err);
            if (result == -1) {
                StringBuilder sb = new StringBuilder();
                if (containerIdStr != null && !containerIdStr.isEmpty()) {
                    sb.append("Trying to get container with ContainerId: " + containerIdStr + "\n");
                }
                if (nodeIdStr != null && !nodeIdStr.isEmpty()) {
                    sb.append("Trying to get container from NodeManager: " + nodeIdStr + "\n");
                }
                sb.append("Can not find any matched containers for the application: " + options.getAppId());
                System.err.println(sb.toString());
            }
            return result;
        }
        for (ContainerReport report : filteredReports) {
            String nodeId = report.getAssignedNode().toString();
            String nodeHttpAddress = report.getNodeHttpAddress().replaceFirst(WebAppUtils.getHttpSchemePrefix(this.getConf()), "");
            String containerId = report.getContainerId().toString();
            this.outputContainerLogMeta(containerId, nodeId, nodeHttpAddress);
        }
        return 0;
    }

    private void outputContainerLogMeta(String containerId, String nodeId, String nodeHttpAddress) throws IOException {
        String containerString = String.format("Container: %s on %s", containerId, nodeId);
        this.outStream.println(containerString);
        this.outStream.println(StringUtils.repeat((String)"=", (int)containerString.length()));
        this.outStream.printf(LogCLIHelpers.PER_LOG_FILE_INFO_PATTERN, "LogFile", "LogLength", "LastModificationTime", "LogAggregationType");
        this.outStream.println(StringUtils.repeat((String)"=", (int)(containerString.length() * 2)));
        List<Pair<ContainerLogFileInfo, String>> infos = this.getContainerLogFiles(this.getConf(), containerId, nodeHttpAddress);
        for (Pair<ContainerLogFileInfo, String> info : infos) {
            this.outStream.printf(LogCLIHelpers.PER_LOG_FILE_INFO_PATTERN, ((ContainerLogFileInfo)info.getKey()).getFileName(), ((ContainerLogFileInfo)info.getKey()).getFileSize(), ((ContainerLogFileInfo)info.getKey()).getLastModifiedTime(), info.getValue());
        }
    }

    @VisibleForTesting
    public Set<String> getMatchedContainerLogFiles(ContainerLogsRequest request, boolean useRegex, boolean ignoreSizeLimit) throws IOException {
        List<Pair<ContainerLogFileInfo, String>> allLogFileInfos = this.getContainerLogFiles(this.getConf(), request.getContainerId(), request.getNodeHttpAddress());
        ArrayList<ContainerLogFileInfo> fileNames = new ArrayList<ContainerLogFileInfo>();
        for (Pair<ContainerLogFileInfo, String> fileInfo : allLogFileInfos) {
            fileNames.add((ContainerLogFileInfo)fileInfo.getKey());
        }
        return this.getMatchedLogFiles(request, fileNames, useRegex, ignoreSizeLimit);
    }

    @VisibleForTesting
    public ClientResponse getResponseFromNMWebService(Configuration conf, Client webServiceClient, ContainerLogsRequest request, String logFile) {
        return LogToolUtils.getResponseFromNMWebService(conf, webServiceClient, request, logFile);
    }

    @VisibleForTesting
    public String getNodeHttpAddressFromRMWebString(ContainerLogsRequest request) throws ClientHandlerException, UniformInterfaceException, JSONException {
        if (request.getNodeId() == null || request.getNodeId().isEmpty()) {
            return null;
        }
        JSONObject nodeInfo = YarnWebServiceUtils.getNodeInfoFromRMWebService(this.getConf(), request.getNodeId()).getJSONObject("node");
        return nodeInfo.has("nodeHTTPAddress") ? nodeInfo.getString("nodeHTTPAddress") : null;
    }

    private long getLogSizeLimitLeft() {
        return this.logSizeLeft;
    }

    private void decrLogSizeLimit(long used) {
        this.logSizeLeft -= used;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public ContainerLogsRequest getMatchedOptionForRunningApp(ContainerLogsRequest container, boolean useRegex, boolean ignoreSizeLimit) throws IOException {
        String containerIdStr = container.getContainerId().toString();
        String nodeHttpAddress = container.getNodeHttpAddress();
        if (nodeHttpAddress == null || nodeHttpAddress.isEmpty()) {
            System.err.println("Can not get the logs for the container: " + containerIdStr);
            System.err.println("The node http address is required to get container logs for the Running application.");
            return null;
        }
        Set<String> matchedFiles = this.getMatchedContainerLogFiles(container, useRegex, ignoreSizeLimit);
        if (matchedFiles.isEmpty()) {
            System.err.println("Can not find any log file matching the pattern: " + container.getLogTypes() + " for the container: " + containerIdStr + " within the application: " + container.getAppId());
            return null;
        }
        container.setLogTypes(matchedFiles);
        return container;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public Map<String, ContainerLogsRequest> getMatchedLogTypesForRunningApp(List<ContainerLogsRequest> containerLogRequests, boolean useRegex, boolean ignoreSizeLimit) {
        HashMap<String, ContainerLogsRequest> containerMatchedLog = new HashMap<String, ContainerLogsRequest>();
        for (ContainerLogsRequest container : containerLogRequests) {
            try {
                ContainerLogsRequest request = this.getMatchedOptionForRunningApp(container, useRegex, ignoreSizeLimit);
                if (request == null) continue;
                containerMatchedLog.put(container.getContainerId(), request);
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
        return containerMatchedLog;
    }

    private Map<String, ContainerLogsRequest> getMatchedLogTypesForFinishedApp(List<ContainerLogsRequest> containerLogRequests, LogCLIHelpers logCliHelper, boolean useRegex, boolean ignoreSizeLimit) {
        HashMap<String, ContainerLogsRequest> containerMatchedLog = new HashMap<String, ContainerLogsRequest>();
        for (ContainerLogsRequest container : containerLogRequests) {
            try {
                ContainerLogsRequest request = this.getMatchedLogOptions(container, logCliHelper, useRegex, ignoreSizeLimit);
                if (request == null) {
                    System.err.println("Can not find any log file matching the pattern: " + container.getLogTypes() + " for the container: " + container.getContainerId() + " within the application: " + container.getAppId());
                    continue;
                }
                containerMatchedLog.put(container.getContainerId(), request);
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
        return containerMatchedLog;
    }

    private static abstract class ClientRetryOp {
        private ClientRetryOp() {
        }

        public abstract Object run() throws IOException;

        public abstract boolean shouldRetryOn(Exception var1);
    }

    private class ClientJerseyRetryFilter
    extends ClientFilter {
        private ClientJerseyRetryFilter() {
        }

        public ClientResponse handle(final ClientRequest cr) throws ClientHandlerException {
            ClientRetryOp jerseyRetryOp = new ClientRetryOp(){

                @Override
                public Object run() {
                    return ClientJerseyRetryFilter.this.getNext().handle(cr);
                }

                @Override
                public boolean shouldRetryOn(Exception e) {
                    return e instanceof ClientHandlerException && (e.getCause() instanceof ConnectException || e.getCause() instanceof SocketTimeoutException || e.getCause() instanceof SocketException);
                }
            };
            try {
                return (ClientResponse)LogsCLI.this.connectionRetry.retryOn(jerseyRetryOp);
            }
            catch (IOException e) {
                throw new ClientHandlerException("Jersey retry failed!\nMessage: " + e.getMessage());
            }
        }
    }

    static class ClientConnectionRetry {
        @InterfaceAudience.Private
        @VisibleForTesting
        public int maxRetries;
        @InterfaceAudience.Private
        @VisibleForTesting
        public long retryInterval;
        private boolean retried = false;

        @InterfaceAudience.Private
        @VisibleForTesting
        boolean getRetired() {
            return this.retried;
        }

        public ClientConnectionRetry(int inputMaxRetries, long inputRetryInterval) {
            this.maxRetries = inputMaxRetries;
            this.retryInterval = inputRetryInterval;
        }

        public Object retryOn(ClientRetryOp op) throws RuntimeException, IOException {
            int leftRetries = this.maxRetries;
            this.retried = false;
            while (true) {
                try {
                    return op.run();
                }
                catch (IOException | RuntimeException e) {
                    if (leftRetries != 0) {
                        if (!op.shouldRetryOn(e)) {
                            throw e;
                        }
                        this.logException(e, leftRetries);
                        if (leftRetries > 0) {
                            --leftRetries;
                        }
                        this.retried = true;
                        try {
                            Thread.sleep(this.retryInterval);
                        }
                        catch (InterruptedException ie) {
                            System.out.println("Client retry sleep interrupted! ");
                        }
                        continue;
                    }
                    throw new RuntimeException("Connection retries limit exceeded.");
                }
                break;
            }
        }

        private void logException(Exception e, int leftRetries) {
            if (leftRetries > 0) {
                System.out.println("Exception caught by ClientConnectionRetry, will try " + leftRetries + " more time(s).\nMessage: " + e.getMessage());
            } else {
                System.out.println("ConnectionException caught by ClientConnectionRetry, will keep retrying.\nMessage: " + e.getMessage());
            }
        }
    }
}

