/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.minifi.toolkit.schema.SensitivePropsSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.StringUtil;
import org.apache.nifi.minifi.toolkit.schema.common.WritableSchema;
import org.apache.nifi.security.util.KeystoreType;

public class SecurityPropertiesSchema
extends BaseSchema
implements WritableSchema {
    public static final String KEYSTORE_KEY = "keystore";
    public static final String KEYSTORE_TYPE_KEY = "keystore type";
    public static final String KEYSTORE_PASSWORD_KEY = "keystore password";
    public static final String KEY_PASSWORD_KEY = "key password";
    public static final String TRUSTSTORE_KEY = "truststore";
    public static final String TRUSTSTORE_TYPE_KEY = "truststore type";
    public static final String TRUSTSTORE_PASSWORD_KEY = "truststore password";
    public static final String SSL_PROTOCOL_KEY = "ssl protocol";
    private String keystore = "";
    private String keystoreType = "";
    private String keystorePassword = "";
    private String keyPassword = "";
    private String truststore = "";
    private String truststoreType = "";
    private String truststorePassword = "";
    private String sslProtocol = "";
    private SensitivePropsSchema sensitiveProps;

    public SecurityPropertiesSchema() {
        this.sensitiveProps = new SensitivePropsSchema();
    }

    public SecurityPropertiesSchema(Map map) {
        this.keystore = this.getOptionalKeyAsType(map, KEYSTORE_KEY, String.class, "Security Properties", "");
        this.keystoreType = this.getOptionalKeyAsType(map, KEYSTORE_TYPE_KEY, String.class, "Security Properties", "");
        if (!StringUtil.isNullOrEmpty(this.keystoreType) && this.validateStoreType(this.keystoreType)) {
            this.addValidationIssue(KEYSTORE_TYPE_KEY, "Security Properties", "it is not a supported type (must be either " + Arrays.stream(KeystoreType.values()).map(KeystoreType::getType).collect(Collectors.joining(", ")) + " format)");
        }
        this.keystorePassword = this.getOptionalKeyAsType(map, KEYSTORE_PASSWORD_KEY, String.class, "Security Properties", "");
        this.keyPassword = this.getOptionalKeyAsType(map, KEY_PASSWORD_KEY, String.class, "Security Properties", "");
        this.truststore = this.getOptionalKeyAsType(map, TRUSTSTORE_KEY, String.class, "Security Properties", "");
        this.truststoreType = this.getOptionalKeyAsType(map, TRUSTSTORE_TYPE_KEY, String.class, "Security Properties", "");
        if (!StringUtil.isNullOrEmpty(this.truststoreType) && this.validateStoreType(this.truststoreType)) {
            this.addValidationIssue(TRUSTSTORE_TYPE_KEY, "Security Properties", "it is not a supported type (must be either " + Arrays.stream(KeystoreType.values()).map(KeystoreType::getType).collect(Collectors.joining(", ")) + " format)");
        }
        this.truststorePassword = this.getOptionalKeyAsType(map, TRUSTSTORE_PASSWORD_KEY, String.class, "Security Properties", "");
        this.sslProtocol = this.getOptionalKeyAsType(map, SSL_PROTOCOL_KEY, String.class, "Security Properties", "");
        if (!StringUtil.isNullOrEmpty(this.sslProtocol)) {
            switch (this.sslProtocol) {
                case "SSL": {
                    break;
                }
                case "SSLv2Hello": {
                    break;
                }
                case "SSLv3": {
                    break;
                }
                case "TLS": {
                    break;
                }
                case "TLSv1": {
                    break;
                }
                case "TLSv1.1": {
                    break;
                }
                case "TLSv1.2": {
                    break;
                }
                default: {
                    this.addValidationIssue(SSL_PROTOCOL_KEY, "Security Properties", "it is not an allowable value of SSL protocol");
                }
            }
            if (StringUtil.isNullOrEmpty(this.keystore)) {
                this.addValidationIssue("When the 'ssl protocol' key of 'Security Properties' is set, the 'keystore' must also be set");
            } else if (StringUtil.isNullOrEmpty(this.keystoreType) || StringUtil.isNullOrEmpty(this.keystorePassword) || StringUtil.isNullOrEmpty(this.keyPassword)) {
                this.addValidationIssue("When the 'keystore' key of 'Security Properties' is set, the 'keystore type', 'keystore password' and 'key password' all must also be set");
            }
            if (!StringUtil.isNullOrEmpty(this.truststore) && (StringUtil.isNullOrEmpty(this.truststoreType) || StringUtil.isNullOrEmpty(this.truststorePassword))) {
                this.addValidationIssue("When the 'truststore' key of 'Security Properties' is set, the 'truststore type' and 'truststore password' must also be set");
            }
        }
        this.sensitiveProps = this.getMapAsType(map, "Sensitive Props", SensitivePropsSchema.class, "Security Properties", false);
        this.addIssuesIfNotNull(this.sensitiveProps);
    }

    @Override
    public Map<String, Object> toMap() {
        Map result = (Map)this.mapSupplier.get();
        result.put(KEYSTORE_KEY, this.keystore);
        result.put(KEYSTORE_TYPE_KEY, this.keystoreType);
        result.put(KEYSTORE_PASSWORD_KEY, this.keystorePassword);
        result.put(KEY_PASSWORD_KEY, this.keyPassword);
        result.put(TRUSTSTORE_KEY, this.truststore);
        result.put(TRUSTSTORE_TYPE_KEY, this.truststoreType);
        result.put(TRUSTSTORE_PASSWORD_KEY, this.truststorePassword);
        result.put(SSL_PROTOCOL_KEY, this.sslProtocol);
        SecurityPropertiesSchema.putIfNotNull(result, "Sensitive Props", this.sensitiveProps);
        return result;
    }

    private boolean validateStoreType(String store) {
        return !store.isEmpty() && !KeystoreType.isValidKeystoreType((String)store);
    }

    public boolean useSSL() {
        return !StringUtil.isNullOrEmpty(this.sslProtocol);
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public SensitivePropsSchema getSensitiveProps() {
        return this.sensitiveProps;
    }
}

