/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hibernate.validator.constraints.BitcoinAddress;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;

public class BitcoinAddressValidator
implements ConstraintValidator<BitcoinAddress, CharSequence> {
    static final String BITCOIN_BASE_MESSAGE_KEY = "org.hibernate.validator.constraints.BitcoinAddress.message";
    static final String ADDRESS_TYPE_VALIDATION_MESSAGE_PREFIX = "org.hibernate.validator.constraints.BitcoinAddress.type.";
    private final Set<AddressValidator> validators = new TreeSet<AddressValidator>();

    public void initialize(BitcoinAddress bitcoinAddress) {
        for (BitcoinAddress.BitcoinAddressType addressType : bitcoinAddress.value()) {
            this.validators.addAll(AddressValidator.validators(addressType));
        }
    }

    public boolean isValid(CharSequence charSequence, ConstraintValidatorContext context) {
        if (charSequence == null) {
            return true;
        }
        for (AddressValidator validator : this.validators) {
            if (!validator.matches(charSequence)) continue;
            return true;
        }
        context.disableDefaultConstraintViolation();
        boolean isSingle = this.isSingleType();
        if (isSingle) {
            ((HibernateConstraintValidatorContext)context.unwrap(HibernateConstraintValidatorContext.class)).buildConstraintViolationWithTemplate(String.format(Locale.ROOT, "{%s.single} %s", BITCOIN_BASE_MESSAGE_KEY, this.getAddressTypeName(this.validators.iterator().next()))).addConstraintViolation();
        } else {
            ((HibernateConstraintValidatorContext)context.unwrap(HibernateConstraintValidatorContext.class)).buildConstraintViolationWithTemplate(String.format(Locale.ROOT, "{%s.multiple} %s", BITCOIN_BASE_MESSAGE_KEY, this.validators.stream().map(this::getAddressTypeName).collect(Collectors.joining(", ")))).addConstraintViolation();
        }
        return false;
    }

    private boolean isSingleType() {
        return this.validators.size() == 1;
    }

    String getAddressTypeName(AddressValidator validator) {
        return String.format(Locale.ROOT, "{%s%s}", ADDRESS_TYPE_VALIDATION_MESSAGE_PREFIX, validator.name().toLowerCase(Locale.ROOT));
    }

    private static enum AddressValidator {
        P2PKH("^(1)[a-zA-HJ-NP-Z0-9]{25,61}$"),
        P2SH("^(3)[a-zA-HJ-NP-Z0-9]{33}$"),
        BECH32("^(bc1)[a-zA-HJ-NP-Z0-9]{39,59}$"),
        P2WSH("^(bc1q)[a-zA-HJ-NP-Z0-9]{58}$"),
        P2WPKH("^(bc1q)[a-zA-HJ-NP-Z0-9]{38}$"),
        P2TR("^(bc1p)[a-zA-HJ-NP-Z0-9]{58}$");

        private static final EnumMap<BitcoinAddress.BitcoinAddressType, Set<AddressValidator>> validators;
        private final Pattern pattern;

        private AddressValidator(String pattern) {
            this.pattern = pattern != null ? Pattern.compile(pattern) : null;
        }

        public boolean matches(CharSequence address) {
            return this.pattern.matcher(address).matches();
        }

        static Set<AddressValidator> validators(BitcoinAddress.BitcoinAddressType addressType) {
            return validators.get((Object)addressType);
        }

        static {
            validators = new EnumMap(BitcoinAddress.BitcoinAddressType.class);
            validators.put(BitcoinAddress.BitcoinAddressType.ANY, Set.of(AddressValidator.values()));
            validators.put(BitcoinAddress.BitcoinAddressType.P2PKH, Set.of(P2PKH));
            validators.put(BitcoinAddress.BitcoinAddressType.P2SH, Set.of(P2SH));
            validators.put(BitcoinAddress.BitcoinAddressType.BECH32, Set.of(BECH32));
            validators.put(BitcoinAddress.BitcoinAddressType.P2WSH, Set.of(P2WSH));
            validators.put(BitcoinAddress.BitcoinAddressType.P2WPKH, Set.of(P2WPKH));
            validators.put(BitcoinAddress.BitcoinAddressType.P2TR, Set.of(P2TR));
        }
    }
}

