/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.sps;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.sps.BlockMoveTaskHandler;
import org.apache.hadoop.hdfs.server.namenode.sps.BlockMovementListener;
import org.apache.hadoop.hdfs.server.namenode.sps.Context;
import org.apache.hadoop.hdfs.server.namenode.sps.FileCollector;
import org.apache.hadoop.hdfs.server.namenode.sps.SPSService;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.protocol.BlockStorageMovementCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.sps.ExternalSPSBlockMoveTaskHandler;
import org.apache.hadoop.hdfs.server.sps.ExternalSPSFilePathCollector;
import org.apache.hadoop.hdfs.server.sps.metrics.ExternalSPSBeanMetrics;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ExternalSPSContext
implements Context {
    public static final Logger LOG = LoggerFactory.getLogger(ExternalSPSContext.class);
    private final SPSService service;
    private final NameNodeConnector nnc;
    private final BlockStoragePolicySuite createDefaultSuite = BlockStoragePolicySuite.createDefaultSuite();
    private final FileCollector fileCollector;
    private final BlockMoveTaskHandler externalHandler;
    private final BlockMovementListener blkMovementListener;
    private ExternalSPSBeanMetrics spsBeanMetrics;

    public ExternalSPSContext(SPSService service, NameNodeConnector nnc) {
        this.service = service;
        this.nnc = nnc;
        this.fileCollector = new ExternalSPSFilePathCollector(service);
        this.externalHandler = new ExternalSPSBlockMoveTaskHandler(service.getConf(), nnc, service);
        this.blkMovementListener = new ExternalBlockMovementListener();
    }

    @Override
    public boolean isRunning() {
        return this.service.isRunning();
    }

    @Override
    public boolean isInSafeMode() {
        try {
            return this.nnc != null ? this.nnc.getDistributedFileSystem().isInSafeMode() : false;
        }
        catch (IOException e) {
            LOG.warn("Exception while creating Namenode Connector..", (Throwable)e);
            return false;
        }
    }

    @Override
    public NetworkTopology getNetworkTopology(StoragePolicySatisfier.DatanodeMap datanodeMap) {
        NetworkTopology cluster = NetworkTopology.getInstance((Configuration)this.service.getConf());
        List<StoragePolicySatisfier.DatanodeWithStorage> targets = datanodeMap.getTargets();
        for (StoragePolicySatisfier.DatanodeWithStorage node : targets) {
            cluster.add((Node)node.getDatanodeInfo());
        }
        return cluster;
    }

    @Override
    public boolean isFileExist(long path) {
        Path filePath = DFSUtilClient.makePathFromFileId((long)path);
        try {
            return this.nnc.getDistributedFileSystem().exists(filePath);
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.warn("Exception while getting file is for the given path:{}", (Object)filePath, (Object)e);
            return false;
        }
    }

    @Override
    public BlockStoragePolicy getStoragePolicy(byte policyId) {
        return this.createDefaultSuite.getPolicy(policyId);
    }

    @Override
    public void removeSPSHint(long inodeId) throws IOException {
        block2: {
            Path filePath = DFSUtilClient.makePathFromFileId((long)inodeId);
            try {
                this.nnc.getDistributedFileSystem().removeXAttr(filePath, "user.hdfs.sps");
            }
            catch (IOException e) {
                List listXAttrs = this.nnc.getDistributedFileSystem().listXAttrs(filePath);
                if (listXAttrs.contains("user.hdfs.sps")) break block2;
                LOG.info("SPS hint already removed for the inodeId:{}. Ignoring exception:{}", (Object)inodeId, (Object)e.getMessage());
            }
        }
    }

    @Override
    public int getNumLiveDataNodes() {
        try {
            return this.nnc.getDistributedFileSystem().getDataNodeStats(HdfsConstants.DatanodeReportType.LIVE).length;
        }
        catch (IOException e) {
            LOG.warn("Exception while getting number of live datanodes.", (Throwable)e);
            return 0;
        }
    }

    @Override
    public HdfsFileStatus getFileInfo(long path) throws IOException {
        HdfsLocatedFileStatus fileInfo = null;
        try {
            Path filePath = DFSUtilClient.makePathFromFileId((long)path);
            fileInfo = this.nnc.getDistributedFileSystem().getClient().getLocatedFileInfo(filePath.toString(), false);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Path:{} doesn't exists!", (Object)path, (Object)e);
        }
        return fileInfo;
    }

    @Override
    public DatanodeStorageReport[] getLiveDatanodeStorageReport() throws IOException {
        return this.nnc.getLiveDatanodeStorageReport();
    }

    @Override
    public Long getNextSPSPath() {
        try {
            return this.nnc.getNNProtocolConnection().getNextSPSPath();
        }
        catch (IOException e) {
            LOG.warn("Exception while getting next sps path id from Namenode.", (Throwable)e);
            return null;
        }
    }

    @Override
    public void scanAndCollectFiles(long path) throws IOException, InterruptedException {
        this.fileCollector.scanAndCollectFiles(path);
    }

    @Override
    public void submitMoveTask(BlockStorageMovementCommand.BlockMovingInfo blkMovingInfo) throws IOException {
        this.externalHandler.submitMoveTask(blkMovingInfo);
    }

    @Override
    public void notifyMovementTriedBlocks(Block[] moveAttemptFinishedBlks) {
        if (this.blkMovementListener != null) {
            this.blkMovementListener.notifyMovementTriedBlocks(moveAttemptFinishedBlks);
        }
    }

    public void initMetrics(StoragePolicySatisfier sps) {
        this.spsBeanMetrics = new ExternalSPSBeanMetrics(sps);
    }

    public void closeMetrics() {
        this.spsBeanMetrics.close();
    }

    @VisibleForTesting
    public ExternalSPSBeanMetrics getSpsBeanMetrics() {
        return this.spsBeanMetrics;
    }

    private static class ExternalBlockMovementListener
    implements BlockMovementListener {
        private List<Block> actualBlockMovements = new ArrayList<Block>();

        private ExternalBlockMovementListener() {
        }

        @Override
        public void notifyMovementTriedBlocks(Block[] moveAttemptFinishedBlks) {
            for (Block block : moveAttemptFinishedBlks) {
                this.actualBlockMovements.add(block);
            }
            LOG.info("Movement attempted blocks", this.actualBlockMovements);
        }
    }
}

