/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.anvl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.io.UTF8Bytes;
import org.archive.util.anvl.Element;
import org.archive.util.anvl.Label;
import org.archive.util.anvl.Value;

public class ANVLRecord
extends LinkedList<Element>
implements UTF8Bytes {
    private static final Logger logger = Logger.getLogger(ANVLRecord.class.getName());
    public static final String MIMETYPE = "application/warc-fields";
    public static final ANVLRecord EMPTY_ANVL_RECORD = new ANVLRecord();
    public static final long MAXIMUM_SIZE = 10240L;
    protected static final String CRLF = "\r\n";
    protected static final String FOLD_PREFIX = "\r\n ";

    public ANVLRecord() {
    }

    public ANVLRecord(Collection<? extends Element> c) {
        super(c);
    }

    public boolean addLabel(String l) {
        return super.add(new Element(new Label(l)));
    }

    public boolean addLabelValue(String l, String v) {
        try {
            return super.add(new Element(new Label(l), new Value(v)));
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "bad label " + l + " or value " + v, e);
            return false;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            sb.append(CRLF);
        }
        sb.append(CRLF);
        return sb.toString();
    }

    public Map<String, String> asMap() {
        HashMap<String, String> m = new HashMap<String, String>(this.size());
        for (Element e : this) {
            m.put(e.getLabel().toString(), e.isValue() ? e.getValue().toString() : (String)null);
        }
        return m;
    }

    @Override
    public ANVLRecord clone() {
        return (ANVLRecord)super.clone();
    }

    @Override
    public byte[] getUTF8Bytes() throws UnsupportedEncodingException {
        return this.toString().getBytes(UTF8);
    }

    public static ANVLRecord load(InputStream is) throws IOException {
        boolean isCRLF = false;
        boolean recordStart = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        boolean done = false;
        int read = 0;
        int c = -1;
        while (!done) {
            if ((long)read++ >= 10240L) {
                throw new IOException("Read 10240 bytes without finding  \\r\\n\\r\\n End-Of-ANVLRecord");
            }
            int previousCharacter = c;
            c = is.read();
            if (c == -1) {
                throw new IOException("End-Of-Stream before \\r\\n\\r\\n End-Of-ANVLRecord:\n" + new String(baos.toByteArray(), UTF8));
            }
            if (ANVLRecord.isLF((char)c) && ANVLRecord.isCR((char)previousCharacter)) {
                if (isCRLF) {
                    done = true;
                } else {
                    isCRLF = true;
                }
            } else {
                if (!recordStart && Character.isWhitespace(c)) continue;
                if (isCRLF && !ANVLRecord.isCR((char)c)) {
                    isCRLF = false;
                }
                if (!recordStart) {
                    recordStart = true;
                }
            }
            baos.write(c);
        }
        return ANVLRecord.load(new String(baos.toByteArray(), UTF8));
    }

    public static ANVLRecord load(String s) throws IOException {
        ANVLRecord record = new ANVLRecord();
        boolean inValue = false;
        boolean inLabel = false;
        boolean inComment = false;
        boolean inNewLine = false;
        String label = null;
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i + 1 > s.length()) {
                throw new IOException("Premature End-of-ANVLRecord:\n" + s.substring(i));
            }
            if (inNewLine && ANVLRecord.isLF(c)) continue;
            if (inNewLine && ANVLRecord.isCR(c) && ANVLRecord.isLF(s.charAt(i + 1))) break;
            if (inNewLine && inValue && Character.isWhitespace(c)) continue;
            boolean bl = inNewLine = ANVLRecord.isCR(c) && ANVLRecord.isLF(s.charAt(i + 1));
            if (inNewLine) {
                if (inComment) {
                    inComment = false;
                    continue;
                }
                if (label != null && !inValue) {
                    record.addLabel(label);
                    label = null;
                    sb.setLength(0);
                    continue;
                }
                if (!inValue) continue;
                if (i + 3 > s.length()) {
                    throw new IOException("Premature End-of-ANVLRecord (2):\n" + s.substring(i));
                }
                if (!ANVLRecord.isCR(s.charAt(i + 2)) && !ANVLRecord.isLF(s.charAt(i + 3)) && Character.isWhitespace(s.charAt(i + 2))) {
                    sb.append(CRLF);
                    sb.append(' ');
                    continue;
                }
                record.addLabelValue(label, sb.toString());
                sb.setLength(0);
                label = null;
                inValue = false;
                continue;
            }
            if (inComment) continue;
            if (inLabel) {
                if (c == ':') {
                    label = sb.toString();
                    sb.setLength(0);
                    inLabel = false;
                    continue;
                }
            } else if (!(inLabel || inValue || inComment)) {
                if (Character.isWhitespace(c)) continue;
                if (label == null && c == '#') {
                    inComment = true;
                    continue;
                }
                if (label == null) {
                    inLabel = true;
                } else {
                    inValue = true;
                }
            }
            sb.append(c);
        }
        return record;
    }

    public synchronized int getLength() {
        int length = -1;
        try {
            length = this.getUTF8Bytes().length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return length;
    }

    public static boolean isCROrLF(char c) {
        return ANVLRecord.isCR(c) || ANVLRecord.isLF(c);
    }

    public static boolean isCR(char c) {
        return c == CRLF.charAt(0);
    }

    public static boolean isLF(char c) {
        return c == CRLF.charAt(1);
    }
}

